/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.ParseField;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

public class GetIndexMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private Logger logger = LogManager.getLogger(GetIndexMappingsResponse.class);
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final ImmutableOpenMap<String, MappingMetadata> mappings;

    public GetIndexMappingsResponse(ImmutableOpenMap<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    public GetIndexMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int mappingCount = in.readVInt();
                if (mappingCount == 0) {
                    indexMapBuilder.put((Object)index, (Object)MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (mappingCount == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    indexMapBuilder.put((Object)index, (Object)new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + mappingCount);
            }
            boolean hasMapping = in.readBoolean();
            indexMapBuilder.put((Object)index, (Object)(hasMapping ? new MappingMetadata(in) : MappingMetadata.EMPTY_MAPPINGS));
        }
        this.mappings = indexMapBuilder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor indexEntry : this.mappings) {
            out.writeString((String)indexEntry.key);
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(indexEntry.value == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (indexEntry.value == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                ((MappingMetadata)indexEntry.value).writeTo(out);
                continue;
            }
            out.writeOptionalWriteable((Writeable)indexEntry.value);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ObjectObjectCursor indexEntry : this.getMappings()) {
            builder.startObject((String)indexEntry.key);
            if (indexEntry.value != null) {
                builder.field(MAPPINGS.getPreferredName(), ((MappingMetadata)indexEntry.value).sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public ImmutableOpenMap<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    public String toString() {
        try {
            return Strings.toString((XContentBuilder)this.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GetIndexMappingsResponse other = (GetIndexMappingsResponse)((Object)obj);
        return this.mappings.equals(other.mappings);
    }
}

