/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

public class GetMappingsViewResponse
extends ActionResponse
implements ToXContentObject {
    private Logger logger = LogManager.getLogger(GetMappingsViewResponse.class);
    public static final String UNMAPPED_INDEX_FIELDS = "unmapped_index_fields";
    public static final String UNMAPPED_FIELD_ALIASES = "unmapped_field_aliases";
    private Map<String, Object> aliasMappings;
    List<String> unmappedIndexFields;
    List<String> unmappedFieldAliases;

    public GetMappingsViewResponse(Map<String, Object> aliasMappings, List<String> unmappedIndexFields, List<String> unmappedFieldAliases) {
        this.aliasMappings = aliasMappings;
        this.unmappedIndexFields = unmappedIndexFields;
        this.unmappedFieldAliases = unmappedFieldAliases;
    }

    public GetMappingsViewResponse(StreamInput in) throws IOException {
        super(in);
        int unmappedFieldAliasesSize;
        int unmappedIndexFieldsSize;
        if (in.readBoolean()) {
            this.aliasMappings = in.readMap();
        }
        if ((unmappedIndexFieldsSize = in.readVInt()) > 0) {
            this.unmappedIndexFields = new ArrayList<String>(unmappedIndexFieldsSize);
            for (int i = 0; i < unmappedIndexFieldsSize; ++i) {
                this.unmappedIndexFields.add(in.readString());
            }
        }
        if ((unmappedFieldAliasesSize = in.readVInt()) > 0) {
            this.unmappedFieldAliases = new ArrayList<String>(unmappedFieldAliasesSize);
            for (int i = 0; i < unmappedFieldAliasesSize; ++i) {
                this.unmappedFieldAliases.add(in.readString());
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.aliasMappings != null) {
            out.writeBoolean(true);
            out.writeMap(this.aliasMappings);
        } else {
            out.writeBoolean(false);
        }
        if (this.unmappedIndexFields != null) {
            out.writeVInt(this.unmappedIndexFields.size());
            for (String f : this.unmappedIndexFields) {
                out.writeString(f);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.unmappedFieldAliases != null) {
            out.writeVInt(this.unmappedFieldAliases.size());
            for (String f : this.unmappedFieldAliases) {
                out.writeString(f);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.aliasMappings != null && this.aliasMappings.size() > 0) {
            builder.field("properties", (Object)((Map)this.aliasMappings.get("properties")));
        }
        if (this.unmappedIndexFields != null && this.unmappedIndexFields.size() > 0) {
            builder.field(UNMAPPED_INDEX_FIELDS, this.unmappedIndexFields);
        }
        if (this.unmappedFieldAliases != null && this.unmappedFieldAliases.size() > 0) {
            builder.field(UNMAPPED_FIELD_ALIASES, this.unmappedFieldAliases);
        }
        return builder.endObject();
    }

    public Map<String, Object> aliasMappings() {
        return this.aliasMappings;
    }

    public List<String> unmappedFieldAliases() {
        return this.unmappedFieldAliases;
    }

    public List<String> unmappedIndexFields() {
        return this.unmappedIndexFields;
    }

    public Map<String, Object> getAliasMappings() {
        return this.aliasMappings;
    }

    public List<String> getUnmappedFieldAliases() {
        return this.unmappedFieldAliases;
    }

    public List<String> getUnmappedIndexFields() {
        return this.unmappedIndexFields;
    }

    public String toString() {
        try {
            return Strings.toString((XContentBuilder)this.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    public int hashCode() {
        return Objects.hash(this.aliasMappings, this.unmappedFieldAliases, this.unmappedIndexFields);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsViewResponse other = (GetMappingsViewResponse)((Object)obj);
        return this.aliasMappings.equals(other.aliasMappings) && this.unmappedIndexFields.equals(other.unmappedIndexFields) && this.unmappedFieldAliases.equals(other.unmappedFieldAliases);
    }
}

