/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.findings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.GetFindingsRequest;
import org.opensearch.commons.alerting.action.GetFindingsResponse;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.FindingWithDocs;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.rest.RestStatus;
import org.opensearch.securityanalytics.action.FindingDto;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetDetectorRequest;
import org.opensearch.securityanalytics.action.GetDetectorResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class FindingsService {
    private Client client;
    private static final Logger log = LogManager.getLogger(FindingsService.class);

    public FindingsService() {
    }

    public FindingsService(Client client) {
        this.client = client;
    }

    public void getFindingsByDetectorId(final String detectorId, final Table table, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        this.client.execute((ActionType)GetDetectorAction.INSTANCE, (ActionRequest)new GetDetectorRequest(detectorId, -3L), (ActionListener)new ActionListener<GetDetectorResponse>(){

            public void onResponse(GetDetectorResponse getDetectorResponse) {
                Detector detector = getDetectorResponse.getDetector();
                List<String> monitorIds = detector.getMonitorIds();
                ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> getFindingsResponseListener = new ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse>(){

                    public void onResponse(org.opensearch.securityanalytics.action.GetFindingsResponse resp) {
                        Integer totalFindings = 0;
                        ArrayList<FindingDto> findings = new ArrayList<FindingDto>();
                        totalFindings = totalFindings + resp.getTotalFindings();
                        findings.addAll(resp.getFindings());
                        org.opensearch.securityanalytics.action.GetFindingsResponse masterResponse = new org.opensearch.securityanalytics.action.GetFindingsResponse(totalFindings, findings);
                        listener.onResponse((Object)masterResponse);
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to fetch findings for detector " + detectorId, (Throwable)e);
                        listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
                    }
                };
                HashMap<String, Detector> monitorToDetectorMapping = new HashMap<String, Detector>();
                detector.getMonitorIds().forEach(monitorId -> monitorToDetectorMapping.put((String)monitorId, detector));
                FindingsService.this.getFindingsByMonitorIds(monitorToDetectorMapping, monitorIds, DetectorMonitorConfig.getAllFindingsIndicesPattern(detector.getDetectorType()), table, getFindingsResponseListener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void getFindingsByMonitorIds(final Map<String, Detector> monitorToDetectorMapping, List<String> monitorIds, String findingIndexName, Table table, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        GetFindingsRequest req = new GetFindingsRequest(null, table, null, findingIndexName, monitorIds);
        AlertingPluginInterface.INSTANCE.getFindings((NodeClient)this.client, req, (ActionListener)new ActionListener<GetFindingsResponse>(){

            public void onResponse(GetFindingsResponse getFindingsResponse) {
                listener.onResponse((Object)new org.opensearch.securityanalytics.action.GetFindingsResponse(getFindingsResponse.getTotalFindings(), getFindingsResponse.getFindings().stream().map(e -> FindingsService.this.mapFindingWithDocsToFindingDto((FindingWithDocs)e, (Detector)monitorToDetectorMapping.get(e.getFinding().getMonitorId()))).collect(Collectors.toList())));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    void setIndicesAdminClient(Client client) {
        this.client = client;
    }

    public void getFindings(final List<Detector> detectors, Detector.DetectorType detectorType, Table table, final ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse> listener) {
        if (detectors.size() == 0) {
            throw new OpenSearchStatusException("detector list is empty!", RestStatus.NOT_FOUND, new Object[0]);
        }
        ArrayList<String> allMonitorIds = new ArrayList<String>();
        HashMap<String, Detector> monitorToDetectorMapping = new HashMap<String, Detector>();
        detectors.forEach(detector -> {
            detector.getMonitorIds().forEach(monitorId -> monitorToDetectorMapping.put((String)monitorId, (Detector)detector));
            allMonitorIds.addAll(detector.getMonitorIds());
        });
        this.getFindingsByMonitorIds(monitorToDetectorMapping, allMonitorIds, DetectorMonitorConfig.getAllFindingsIndicesPattern(detectorType.getDetectorType()), table, new ActionListener<org.opensearch.securityanalytics.action.GetFindingsResponse>(){

            public void onResponse(org.opensearch.securityanalytics.action.GetFindingsResponse getFindingsResponse) {
                listener.onResponse((Object)getFindingsResponse);
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch findings for detectors: [" + detectors.stream().map(d -> d.getId()).collect(Collectors.joining(",")) + "]", (Throwable)e);
                listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
            }
        });
    }

    public FindingDto mapFindingWithDocsToFindingDto(FindingWithDocs findingWithDocs, Detector detector) {
        List<DocLevelQuery> docLevelQueries = findingWithDocs.getFinding().getDocLevelQueries();
        if (docLevelQueries.isEmpty()) {
            for (Map.Entry<String, String> entry : detector.getRuleIdMonitorIdMap().entrySet()) {
                if (!entry.getValue().equals(findingWithDocs.getFinding().getMonitorId())) continue;
                docLevelQueries = Collections.singletonList(new DocLevelQuery(entry.getKey(), "", "", Collections.emptyList()));
            }
        }
        return new FindingDto(detector.getId(), findingWithDocs.getFinding().getId(), findingWithDocs.getFinding().getRelatedDocIds(), findingWithDocs.getFinding().getIndex(), docLevelQueries, findingWithDocs.getFinding().getTimestamp(), findingWithDocs.getDocuments());
    }
}

