/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;

public class IndexTemplateUtils {
    public static Set<String> getAllSapComponentTemplates(ClusterState state) {
        HashSet<String> componentTemplates = new HashSet<String>();
        state.metadata().componentTemplates().forEach((name, instance) -> {
            if (name.startsWith(IndexTemplateManager.OPENSEARCH_SAP_COMPONENT_TEMPLATE_PREFIX)) {
                componentTemplates.add((String)name);
            }
        });
        return componentTemplates;
    }

    public static boolean isSapComposableIndexTemplate(String templateName, ComposableIndexTemplate template) {
        if (!templateName.startsWith(IndexTemplateManager.OPENSEARCH_SAP_INDEX_TEMPLATE_PREFIX) || template.template() != null) {
            return false;
        }
        for (String componentTemplate : template.composedOf()) {
            if (componentTemplate.startsWith(IndexTemplateManager.OPENSEARCH_SAP_COMPONENT_TEMPLATE_PREFIX)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, ComposableIndexTemplate> getAllSapComposableIndexTemplates(ClusterState state) {
        HashMap<String, ComposableIndexTemplate> sapTemplates = new HashMap<String, ComposableIndexTemplate>();
        state.metadata().templatesV2().forEach((name, instance) -> {
            if (IndexTemplateUtils.isSapComposableIndexTemplate(name, instance)) {
                sapTemplates.put((String)name, (ComposableIndexTemplate)instance);
            }
        });
        return sapTemplates;
    }

    public static String computeIndexTemplateName(String indexName) {
        return IndexTemplateManager.OPENSEARCH_SAP_INDEX_TEMPLATE_PREFIX + IndexTemplateUtils.normalizeIndexName(indexName);
    }

    public static String computeComponentTemplateName(String indexName) {
        if (indexName.endsWith("*")) {
            indexName = indexName.substring(0, indexName.length() - 1);
        }
        return IndexTemplateManager.OPENSEARCH_SAP_COMPONENT_TEMPLATE_PREFIX + IndexTemplateUtils.normalizeIndexName(indexName);
    }

    public static String normalizeIndexName(String indexName) {
        if (indexName.endsWith("*")) {
            return indexName.substring(0, indexName.length() - 1);
        }
        return indexName;
    }

    public static boolean isUserCreatedComposableTemplate(String templateName) {
        return !templateName.startsWith(IndexTemplateManager.OPENSEARCH_SAP_INDEX_TEMPLATE_PREFIX);
    }

    public static Template copyTemplate(Template template) throws IOException {
        if (template == null) {
            return null;
        }
        CompressedXContent outMappings = null;
        CompressedXContent mappings = template.mappings();
        if (mappings != null) {
            Map mappingsAsMap = (Map)XContentHelper.convertToMap((BytesReference)mappings.compressedReference(), (boolean)true, (XContentType)XContentType.JSON).v2();
            if (mappingsAsMap.containsKey("_doc")) {
                mappingsAsMap = (Map)mappingsAsMap.get("_doc");
            }
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(mappingsAsMap);
            outMappings = new CompressedXContent(BytesReference.bytes((XContentBuilder)builder));
        }
        return new Template(template.settings(), outMappings, template.aliases());
    }
}

