/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class DetectorRule
implements Writeable,
ToXContentObject {
    private String id;
    private static final List<String> INVALID_CHARACTERS = List.of(" ", "[", "]", "{", "}", "(", ")");
    protected static final String RULE_ID_FIELD = "id";

    public DetectorRule(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Custom Rule id is invalid");
        }
        this.id = id;
    }

    public DetectorRule(StreamInput sin) throws IOException {
        this(sin.readString());
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(RULE_ID_FIELD, this.id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(RULE_ID_FIELD, this.id).endObject();
        return builder;
    }

    public static DetectorRule parse(XContentParser xcp) throws IOException {
        String id = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = xcp.text();
                }
            }
        }
        return new DetectorRule(id);
    }

    public static DetectorRule readFrom(StreamInput sin) throws IOException {
        return new DetectorRule(sin);
    }

    public String getId() {
        return this.id;
    }
}

