/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;

public class RuleCategory
implements Writeable,
ToXContentObject {
    public static final String KEY = "key";
    public static final String DISPLAY_NAME = "display_name";
    private String name;
    private String displayName;
    private static final String RULE_CATEGORIES_CONFIG_FILE = "rules/rule_categories.json";
    public static final List<RuleCategory> ALL_RULE_CATEGORIES;

    public RuleCategory(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString());
    }

    public RuleCategory(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.displayName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(KEY, this.name).field(DISPLAY_NAME, this.displayName).endObject();
    }

    public String getName() {
        return this.name;
    }

    static {
        ArrayList<RuleCategory> ruleCategories = new ArrayList<RuleCategory>();
        try (InputStream is = RuleCategory.class.getClassLoader().getResourceAsStream(RULE_CATEGORIES_CONFIG_FILE);){
            String ruleCategoriesJson = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
            if (ruleCategoriesJson != null) {
                Map configMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)ruleCategoriesJson, (boolean)false);
                List categories = (List)configMap.get("rule_categories");
                for (Map c : categories) {
                    ruleCategories.add(new RuleCategory((String)c.get(KEY), (String)c.get(DISPLAY_NAME)));
                }
            }
        }
        catch (OpenSearchParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SettingsException("Failed to load settings from [rules/rule_categories.json]", (Throwable)e);
        }
        ALL_RULE_CATEGORIES = Collections.unmodifiableList(ruleCategories);
    }
}

