/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.condition;

import java.util.List;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetection;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class ConditionIdentifier
extends ConditionItem {
    private int argCount = 1;
    private boolean tokenList = true;
    private String identifier;

    public ConditionIdentifier(List<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> args) {
        super(1, true, args);
        this.identifier = args.get(0).get();
    }

    @Override
    public ConditionItem postProcess(SigmaDetections detections, Object parent) throws SigmaConditionError {
        this.setParent((ConditionItem)parent);
        if (detections.getDetections().containsKey(this.identifier)) {
            SigmaDetection detection = detections.getDetections().get(this.identifier);
            AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression> item = detection.postProcess(detections, this);
            return item.isLeft() ? (ConditionItem)item.getLeft() : (item.isMiddle() ? (ConditionItem)item.getMiddle() : (ConditionItem)item.get());
        }
        throw new SigmaConditionError("Detection '" + this.identifier + "' not defined in detections");
    }
}

