/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.SetOnce;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorRequest;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.securityanalytics.action.DeleteDetectorRequest;
import org.opensearch.securityanalytics.action.DeleteDetectorResponse;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportDeleteDetectorAction
extends HandledTransportAction<DeleteDetectorRequest, DeleteDetectorResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeleteDetectorAction.class);
    private final Client client;
    private final RuleTopicIndices ruleTopicIndices;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;
    private final IndexTemplateManager indexTemplateManager;

    @Inject
    public TransportDeleteDetectorAction(TransportService transportService, IndexTemplateManager indexTemplateManager, Client client, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, RuleTopicIndices ruleTopicIndices) {
        super("cluster:admin/opensearch/securityanalytics/detector/delete", transportService, actionFilters, DeleteDetectorRequest::new);
        this.client = client;
        this.ruleTopicIndices = ruleTopicIndices;
        this.xContentRegistry = xContentRegistry;
        this.threadPool = client.threadPool();
        this.indexTemplateManager = indexTemplateManager;
    }

    protected void doExecute(Task task, DeleteDetectorRequest request, ActionListener<DeleteDetectorResponse> listener) {
        AsyncDeleteDetectorAction asyncAction = new AsyncDeleteDetectorAction(task, request, listener);
        asyncAction.start();
    }

    private void deleteAlertingMonitor(String monitorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteMonitorResponse> listener) {
        DeleteMonitorRequest request = new DeleteMonitorRequest(monitorId, refreshPolicy);
        AlertingPluginInterface.INSTANCE.deleteMonitor((NodeClient)this.client, request, listener);
    }

    private void deleteDetector(String detectorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteResponse> listener) {
        DeleteRequest request = (DeleteRequest)new DeleteRequest(".opensearch-sap-detectors-config", detectorId).setRefreshPolicy(refreshPolicy);
        this.client.delete(request, listener);
    }

    class AsyncDeleteDetectorAction {
        private final DeleteDetectorRequest request;
        private final ActionListener<DeleteDetectorResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncDeleteDetectorAction(Task task, DeleteDetectorRequest request, ActionListener<DeleteDetectorResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            TransportDeleteDetectorAction.this.threadPool.getThreadContext().stashContext();
            final String detectorId = this.request.getDetectorId();
            GetRequest getRequest = new GetRequest(".opensearch-sap-detectors-config", detectorId);
            TransportDeleteDetectorAction.this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", detectorId), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportDeleteDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                        Detector detector = Detector.docParse(xcp, response.getId(), response.getVersion());
                        AsyncDeleteDetectorAction.this.onGetResponse(detector);
                    }
                    catch (Exception e) {
                        AsyncDeleteDetectorAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception t) {
                    AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", detectorId), RestStatus.NOT_FOUND, new Object[0]));
                }
            });
        }

        private void onGetResponse(final Detector detector) {
            List<String> monitorIds = detector.getMonitorIds();
            String ruleIndex = detector.getRuleIndex();
            GroupedActionListener deletesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<DeleteMonitorResponse>>(){

                public void onResponse(Collection<DeleteMonitorResponse> responses) {
                    SetOnce errorStatusSupplier = new SetOnce();
                    if (responses.stream().filter(response -> {
                        if (response.getStatus() != RestStatus.OK) {
                            log.error("Detector not being deleted because monitor [{}] could not be deleted. Status [{}]", (Object)response.getId(), (Object)response.getStatus());
                            errorStatusSupplier.trySet((Object)response.getStatus());
                            return true;
                        }
                        return false;
                    }).count() > 0L) {
                        AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException("Monitor associated with detected could not be deleted", (RestStatus)errorStatusSupplier.get(), new Object[0]));
                    }
                    AsyncDeleteDetectorAction.this.deleteDetectorFromConfig(detector.getId(), AsyncDeleteDetectorAction.this.request.getRefreshPolicy());
                }

                public void onFailure(Exception e) {
                    if (AsyncDeleteDetectorAction.this.counter.compareAndSet(false, true)) {
                        AsyncDeleteDetectorAction.this.finishHim(null, e);
                    }
                }
            }, monitorIds.size());
            for (String monitorId : monitorIds) {
                TransportDeleteDetectorAction.this.deleteAlertingMonitor(monitorId, this.request.getRefreshPolicy(), (ActionListener<DeleteMonitorResponse>)deletesListener);
            }
        }

        private void deleteDetectorFromConfig(String detectorId, WriteRequest.RefreshPolicy refreshPolicy) {
            TransportDeleteDetectorAction.this.deleteDetector(detectorId, refreshPolicy, new ActionListener<DeleteResponse>(){

                public void onResponse(final DeleteResponse response) {
                    TransportDeleteDetectorAction.this.indexTemplateManager.deleteAllUnusedTemplates(new ActionListener<Void>(){

                        public void onResponse(Void unused) {
                            AsyncDeleteDetectorAction.this.onOperation(response);
                        }

                        public void onFailure(Exception e) {
                            log.error("Error deleting unused templates: " + e.getMessage());
                            AsyncDeleteDetectorAction.this.onOperation(response);
                        }
                    });
                }

                public void onFailure(Exception t) {
                    AsyncDeleteDetectorAction.this.onFailures(t);
                }
            });
        }

        private void onOperation(DeleteResponse response) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response.getId(), null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(String detectorId, Exception t) {
            TransportDeleteDetectorAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new DeleteDetectorResponse(detectorId, Detector.NO_VERSION, RestStatus.NO_CONTENT);
            }));
        }
    }
}

