/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.SetOnce;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorRequest;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.script.Script;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.GetIndexMappingsAction;
import org.opensearch.securityanalytics.action.GetIndexMappingsRequest;
import org.opensearch.securityanalytics.action.GetIndexMappingsResponse;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.IndexDetectorResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.securityanalytics.mapper.MapperUtils;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorInput;
import org.opensearch.securityanalytics.model.DetectorRule;
import org.opensearch.securityanalytics.model.DetectorTrigger;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.model.Value;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.backend.QueryBackend;
import org.opensearch.securityanalytics.rules.exceptions.SigmaError;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndexDetectorAction
extends HandledTransportAction<IndexDetectorRequest, IndexDetectorResponse>
implements SecureTransportAction {
    public static final String PLUGIN_OWNER_FIELD = "security_analytics";
    private static final Logger log = LogManager.getLogger(TransportIndexDetectorAction.class);
    public static final String TIMESTAMP_FIELD_ALIAS = "timestamp";
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final DetectorIndices detectorIndices;
    private final RuleTopicIndices ruleTopicIndices;
    private final RuleIndices ruleIndices;
    private final MapperService mapperService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile Boolean filterByEnabled;
    private final Settings settings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportIndexDetectorAction(TransportService transportService, Client client, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, DetectorIndices detectorIndices, RuleTopicIndices ruleTopicIndices, RuleIndices ruleIndices, MapperService mapperService, ClusterService clusterService, Settings settings, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/opensearch/securityanalytics/detector/write", transportService, actionFilters, IndexDetectorRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.detectorIndices = detectorIndices;
        this.ruleTopicIndices = ruleTopicIndices;
        this.ruleIndices = ruleIndices;
        this.mapperService = mapperService;
        this.clusterService = clusterService;
        this.settings = settings;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, IndexDetectorRequest request, ActionListener<IndexDetectorResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        this.checkIndicesAndExecute(task, request, listener, user);
    }

    private void checkIndicesAndExecute(final Task task, final IndexDetectorRequest request, final ActionListener<IndexDetectorResponse> listener, final User user) {
        final String[] detectorIndices = (String[])request.getDetector().getInputs().stream().flatMap(detectorInput -> detectorInput.getIndices().stream()).toArray(String[]::new);
        SearchRequest searchRequest = new SearchRequest(detectorIndices).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                AsyncIndexDetectorsAction asyncAction = new AsyncIndexDetectorsAction(user, task, request, (ActionListener<IndexDetectorResponse>)listener);
                asyncAction.start();
            }

            public void onFailure(Exception e) {
                if (e instanceof OpenSearchStatusException) {
                    listener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "User doesn't have read permissions for one or more configured index %s", (Object[])detectorIndices), RestStatus.FORBIDDEN, new Object[0])));
                } else if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Indices not found %s", String.join((CharSequence)", ", detectorIndices)), RestStatus.NOT_FOUND, new Object[0])));
                } else {
                    listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
                }
            }
        });
    }

    private void createMonitorFromQueries(String index, List<Pair<String, Rule>> rulesById, Detector detector, final ActionListener<List<IndexMonitorResponse>> listener, WriteRequest.RefreshPolicy refreshPolicy) throws SigmaError, IOException {
        List<Pair<String, Rule>> docLevelRules = rulesById.stream().filter(it -> !((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        List<Pair<String, Rule>> bucketLevelRules = rulesById.stream().filter(it -> ((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        ArrayList<IndexMonitorRequest> monitorRequests = new ArrayList<IndexMonitorRequest>();
        if (!docLevelRules.isEmpty()) {
            monitorRequests.add(this.createDocLevelMonitorRequest(docLevelRules, detector, refreshPolicy, "", RestRequest.Method.POST));
        }
        if (!bucketLevelRules.isEmpty()) {
            monitorRequests.addAll(this.buildBucketLevelMonitorRequests(bucketLevelRules, detector, refreshPolicy, "", RestRequest.Method.POST));
        }
        if (monitorRequests.isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        final ArrayList monitorResponses = new ArrayList();
        StepListener addFirstMonitorStep = new StepListener();
        AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, (IndexMonitorRequest)monitorRequests.get(0), this.namedWriteableRegistry, (ActionListener)addFirstMonitorStep);
        addFirstMonitorStep.whenComplete(addedFirstMonitorResponse -> {
            monitorResponses.add(addedFirstMonitorResponse);
            int numberOfUnprocessedResponses = monitorRequests.size() - 1;
            if (numberOfUnprocessedResponses == 0) {
                listener.onResponse((Object)monitorResponses);
            } else {
                GroupedActionListener monitorResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorResponse>>(){

                    public void onResponse(Collection<IndexMonitorResponse> indexMonitorResponse) {
                        monitorResponses.addAll(indexMonitorResponse.stream().collect(Collectors.toList()));
                        listener.onResponse((Object)monitorResponses);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                }, numberOfUnprocessedResponses);
                for (int i = 1; i < monitorRequests.size(); ++i) {
                    AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, (IndexMonitorRequest)monitorRequests.get(i), this.namedWriteableRegistry, (ActionListener)monitorResponseListener);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void updateMonitorFromQueries(String index, List<Pair<String, Rule>> rulesById, Detector detector, ActionListener<List<IndexMonitorResponse>> listener, WriteRequest.RefreshPolicy refreshPolicy) throws SigmaError, IOException {
        List<Pair<String, Rule>> docLevelRules;
        ArrayList<IndexMonitorRequest> monitorsToBeUpdated = new ArrayList<IndexMonitorRequest>();
        List bucketLevelRules = rulesById.stream().filter(it -> ((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        ArrayList<IndexMonitorRequest> monitorsToBeAdded = new ArrayList<IndexMonitorRequest>();
        if (!bucketLevelRules.isEmpty()) {
            List ruleCategories = bucketLevelRules.stream().map(Pair::getRight).map(Rule::getCategory).distinct().collect(Collectors.toList());
            HashMap<String, OSQueryBackend> queryBackendMap = new HashMap<String, OSQueryBackend>();
            for (String category : ruleCategories) {
                queryBackendMap.put(category, new OSQueryBackend(category, true, true));
            }
            Map<String, String> monitorPerRule = detector.getRuleIdMonitorIdMap();
            for (Pair query : bucketLevelRules) {
                Rule rule = (Rule)query.getRight();
                if (rule.getAggregationQueries() == null) continue;
                if (monitorPerRule.containsKey(rule.getId())) {
                    String monitorId = monitorPerRule.get(rule.getId());
                    monitorsToBeUpdated.add(this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, monitorId, RestRequest.Method.PUT, (QueryBackend)queryBackendMap.get(rule.getCategory())));
                    continue;
                }
                monitorsToBeAdded.add(this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, "", RestRequest.Method.POST, (QueryBackend)queryBackendMap.get(rule.getCategory())));
            }
        }
        if (!(docLevelRules = rulesById.stream().filter(it -> !((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList())).isEmpty()) {
            if (detector.getDocLevelMonitorId() == null) {
                monitorsToBeAdded.add(this.createDocLevelMonitorRequest(docLevelRules, detector, refreshPolicy, "", RestRequest.Method.POST));
            } else {
                monitorsToBeUpdated.add(this.createDocLevelMonitorRequest(docLevelRules, detector, refreshPolicy, detector.getDocLevelMonitorId(), RestRequest.Method.PUT));
            }
        }
        List<String> monitorIdsToBeDeleted = detector.getRuleIdMonitorIdMap().values().stream().collect(Collectors.toList());
        monitorIdsToBeDeleted.removeAll(monitorsToBeUpdated.stream().map(IndexMonitorRequest::getMonitorId).collect(Collectors.toList()));
        this.updateAlertingMonitors(monitorsToBeAdded, monitorsToBeUpdated, monitorIdsToBeDeleted, refreshPolicy, listener);
    }

    private void updateAlertingMonitors(List<IndexMonitorRequest> monitorsToBeAdded, List<IndexMonitorRequest> monitorsToBeUpdated, List<String> monitorsToBeDeleted, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<List<IndexMonitorResponse>> listener) {
        ArrayList updatedMonitors = new ArrayList();
        StepListener addNewMonitorsStep = new StepListener();
        this.executeMonitorActionRequest(monitorsToBeAdded, (ActionListener<List<IndexMonitorResponse>>)addNewMonitorsStep);
        addNewMonitorsStep.whenComplete(addNewMonitorsResponse -> {
            if (addNewMonitorsResponse != null && !addNewMonitorsResponse.isEmpty()) {
                updatedMonitors.addAll(addNewMonitorsResponse);
            }
            StepListener updateMonitorsStep = new StepListener();
            this.executeMonitorActionRequest(monitorsToBeUpdated, (ActionListener<List<IndexMonitorResponse>>)updateMonitorsStep);
            updateMonitorsStep.whenComplete(updateMonitorResponse -> {
                if (updateMonitorResponse != null && !updateMonitorResponse.isEmpty()) {
                    updatedMonitors.addAll(updateMonitorResponse);
                }
                StepListener deleteMonitorStep = new StepListener();
                this.deleteAlertingMonitors(monitorsToBeDeleted, refreshPolicy, (ActionListener<List<DeleteMonitorResponse>>)deleteMonitorStep);
                deleteMonitorStep.whenComplete(deleteMonitorResponses -> listener.onResponse((Object)updatedMonitors), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private IndexMonitorRequest createDocLevelMonitorRequest(List<Pair<String, Rule>> queries, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String monitorId, RestRequest.Method restMethod) {
        ArrayList<DocLevelMonitorInput> docLevelMonitorInputs = new ArrayList<DocLevelMonitorInput>();
        ArrayList<DocLevelQuery> docLevelQueries = new ArrayList<DocLevelQuery>();
        for (Pair<String, Rule> query : queries) {
            String id = (String)query.getLeft();
            Rule rule = (Rule)query.getRight();
            String name = (String)query.getLeft();
            String actualQuery = rule.getQueries().get(0).getValue();
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(rule.getLevel());
            tags.add(rule.getCategory());
            tags.addAll(rule.getTags().stream().map(Value::getValue).collect(Collectors.toList()));
            DocLevelQuery docLevelQuery = new DocLevelQuery(id, name, actualQuery, tags);
            docLevelQueries.add(docLevelQuery);
        }
        DocLevelMonitorInput docLevelMonitorInput = new DocLevelMonitorInput(detector.getName(), detector.getInputs().get(0).getIndices(), docLevelQueries);
        docLevelMonitorInputs.add(docLevelMonitorInput);
        ArrayList<DocumentLevelTrigger> triggers = new ArrayList<DocumentLevelTrigger>();
        List<DetectorTrigger> detectorTriggers = detector.getTriggers();
        for (DetectorTrigger detectorTrigger : detectorTriggers) {
            String id = detectorTrigger.getId();
            String name = detectorTrigger.getName();
            String severity = detectorTrigger.getSeverity();
            List<Action> actions = detectorTrigger.getActions();
            Script condition = detectorTrigger.convertToCondition();
            triggers.add(new DocumentLevelTrigger(id, name, severity, actions, condition));
        }
        Monitor monitor = new Monitor(monitorId, 1L, detector.getName(), detector.getEnabled().booleanValue(), detector.getSchedule(), detector.getLastUpdateTime(), detector.getEnabledTime(), Monitor.MonitorType.DOC_LEVEL_MONITOR, detector.getUser(), 1, docLevelMonitorInputs, triggers, Map.of(), new DataSources(detector.getRuleIndex(), detector.getFindingsIndex(), detector.getFindingsIndexPattern(), detector.getAlertsIndex(), detector.getAlertsHistoryIndex(), detector.getAlertsHistoryIndexPattern(), DetectorMonitorConfig.getRuleIndexMappingsByType(detector.getDetectorType()), Boolean.valueOf(true)), PLUGIN_OWNER_FIELD);
        return new IndexMonitorRequest(monitorId, -2L, 0L, refreshPolicy, restMethod, monitor, null);
    }

    private List<IndexMonitorRequest> buildBucketLevelMonitorRequests(List<Pair<String, Rule>> queries, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String monitorId, RestRequest.Method restMethod) throws IOException, SigmaError {
        List ruleCategories = queries.stream().map(Pair::getRight).map(Rule::getCategory).distinct().collect(Collectors.toList());
        HashMap<String, OSQueryBackend> queryBackendMap = new HashMap<String, OSQueryBackend>();
        for (String category : ruleCategories) {
            queryBackendMap.put(category, new OSQueryBackend(category, true, true));
        }
        ArrayList<IndexMonitorRequest> monitorRequests = new ArrayList<IndexMonitorRequest>();
        for (Pair<String, Rule> query : queries) {
            Rule rule = (Rule)query.getRight();
            if (rule.getAggregationQueries() == null) continue;
            monitorRequests.add(this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, "", RestRequest.Method.POST, (QueryBackend)queryBackendMap.get(rule.getCategory())));
        }
        return monitorRequests;
    }

    private IndexMonitorRequest createBucketLevelMonitorRequest(Rule rule, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String monitorId, RestRequest.Method restMethod, QueryBackend queryBackend) throws SigmaError {
        List<String> indices = detector.getInputs().get(0).getIndices();
        OSQueryBackend.AggregationQueries aggregationQueries = queryBackend.convertAggregation(rule.getAggregationItemsFromRule().get(0));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)QueryBuilders.queryStringQuery((String)rule.getQueries().get(0).getValue())).aggregation(aggregationQueries.getAggBuilder());
        String concreteIndex = IndexUtils.getNewIndexByCreationDate(this.clusterService.state(), this.indexNameExpressionResolver, indices.get(0));
        try {
            GetIndexMappingsResponse getIndexMappingsResponse = (GetIndexMappingsResponse)((Object)this.client.execute((ActionType)GetIndexMappingsAction.INSTANCE, (ActionRequest)new GetIndexMappingsRequest(concreteIndex)).actionGet());
            MappingMetadata mappingMetadata = (MappingMetadata)getIndexMappingsResponse.mappings().get((Object)concreteIndex);
            List<Pair<String, String>> pairs = MapperUtils.getAllAliasPathPairs(mappingMetadata);
            boolean timeStampAliasPresent = pairs.stream().anyMatch(p -> TIMESTAMP_FIELD_ALIAS.equals(p.getLeft()) || TIMESTAMP_FIELD_ALIAS.equals(p.getRight()));
            if (timeStampAliasPresent) {
                BoolQueryBuilder boolQueryBuilder = searchSourceBuilder.query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchSourceBuilder.query());
                RangeQueryBuilder timeRangeFilter = QueryBuilders.rangeQuery((String)TIMESTAMP_FIELD_ALIAS).gt((Object)"{{period_end}}||-1h").lte((Object)"{{period_end}}").format("epoch_millis");
                boolQueryBuilder.must((QueryBuilder)timeRangeFilter);
                searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            }
        }
        catch (Exception e) {
            log.error(String.format(Locale.getDefault(), "Unable to verify presence of timestamp alias for index [%s] in detector [%s]. Not setting time range filter for bucket level monitor.", concreteIndex, detector.getName()), (Throwable)e);
        }
        ArrayList<SearchInput> bucketLevelMonitorInputs = new ArrayList<SearchInput>();
        bucketLevelMonitorInputs.add(new SearchInput(indices, searchSourceBuilder));
        ArrayList<BucketLevelTrigger> triggers = new ArrayList<BucketLevelTrigger>();
        BucketLevelTrigger bucketLevelTrigger = new BucketLevelTrigger(rule.getId(), rule.getTitle(), rule.getLevel(), aggregationQueries.getCondition(), Collections.emptyList());
        triggers.add(bucketLevelTrigger);
        Monitor monitor = new Monitor(monitorId, 1L, detector.getName(), detector.getEnabled().booleanValue(), detector.getSchedule(), detector.getLastUpdateTime(), detector.getEnabledTime(), Monitor.MonitorType.BUCKET_LEVEL_MONITOR, detector.getUser(), 1, bucketLevelMonitorInputs, triggers, Map.of(), new DataSources(detector.getRuleIndex(), detector.getFindingsIndex(), detector.getFindingsIndexPattern(), detector.getAlertsIndex(), detector.getAlertsHistoryIndex(), detector.getAlertsHistoryIndexPattern(), DetectorMonitorConfig.getRuleIndexMappingsByType(detector.getDetectorType()), Boolean.valueOf(true)), PLUGIN_OWNER_FIELD);
        return new IndexMonitorRequest(monitorId, -2L, 0L, refreshPolicy, restMethod, monitor, null);
    }

    public void executeMonitorActionRequest(List<IndexMonitorRequest> indexMonitors, final ActionListener<List<IndexMonitorResponse>> listener) {
        if (indexMonitors == null || indexMonitors.isEmpty()) {
            listener.onResponse(new ArrayList());
            return;
        }
        GroupedActionListener monitorResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorResponse>>(){

            public void onResponse(Collection<IndexMonitorResponse> indexMonitorResponse) {
                listener.onResponse(indexMonitorResponse.stream().collect(Collectors.toList()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, indexMonitors.size());
        for (IndexMonitorRequest req : indexMonitors) {
            AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, req, this.namedWriteableRegistry, (ActionListener)monitorResponseListener);
        }
    }

    private void deleteAlertingMonitors(List<String> monitorIds, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<List<DeleteMonitorResponse>> listener) {
        if (monitorIds == null || monitorIds.isEmpty()) {
            listener.onResponse(new ArrayList());
            return;
        }
        GroupedActionListener deletesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<DeleteMonitorResponse>>(){

            public void onResponse(Collection<DeleteMonitorResponse> responses) {
                SetOnce errorStatusSupplier = new SetOnce();
                if (responses.stream().filter(response -> {
                    if (response.getStatus() != RestStatus.OK) {
                        log.error("Monitor [{}] could not be deleted. Status [{}]", (Object)response.getId(), (Object)response.getStatus());
                        errorStatusSupplier.trySet((Object)response.getStatus());
                        return true;
                    }
                    return false;
                }).count() > 0L) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Monitor associated with detected could not be deleted", (RestStatus)errorStatusSupplier.get(), new Object[0]));
                }
                listener.onResponse(responses.stream().collect(Collectors.toList()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, monitorIds.size());
        for (String monitorId : monitorIds) {
            this.deleteAlertingMonitor(monitorId, refreshPolicy, (ActionListener<DeleteMonitorResponse>)deletesListener);
        }
    }

    private void deleteAlertingMonitor(String monitorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteMonitorResponse> listener) {
        DeleteMonitorRequest request = new DeleteMonitorRequest(monitorId, refreshPolicy);
        AlertingPluginInterface.INSTANCE.deleteMonitor((NodeClient)this.client, request, listener);
    }

    private void onCreateMappingsResponse(CreateIndexResponse response) throws IOException {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Created %s with mappings.", ".opensearch-sap-detectors-config"));
        IndexUtils.detectorIndexUpdated();
    }

    private void onUpdateMappingsResponse(AcknowledgedResponse response) {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Updated  %s with mappings.", ".opensearch-sap-detectors-config"));
        IndexUtils.detectorIndexUpdated();
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }

    class AsyncIndexDetectorsAction {
        private final IndexDetectorRequest request;
        private final ActionListener<IndexDetectorResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;
        private final User user;

        AsyncIndexDetectorsAction(User user, Task task, IndexDetectorRequest request, ActionListener<IndexDetectorResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.user = user;
            this.response = new AtomicReference();
        }

        void start() {
            try {
                TransportIndexDetectorAction.this.threadPool.getThreadContext().stashContext();
                if (!TransportIndexDetectorAction.this.detectorIndices.detectorIndexExists()) {
                    TransportIndexDetectorAction.this.detectorIndices.initDetectorIndex(new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            try {
                                TransportIndexDetectorAction.this.onCreateMappingsResponse(response);
                                AsyncIndexDetectorsAction.this.prepareDetectorIndexing();
                            }
                            catch (IOException e) {
                                AsyncIndexDetectorsAction.this.onFailures(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                } else if (!IndexUtils.detectorIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-detectors-config", DetectorIndices.detectorMappings(), TransportIndexDetectorAction.this.clusterService.state(), TransportIndexDetectorAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            TransportIndexDetectorAction.this.onUpdateMappingsResponse(response);
                            try {
                                AsyncIndexDetectorsAction.this.prepareDetectorIndexing();
                            }
                            catch (IOException e) {
                                AsyncIndexDetectorsAction.this.onFailures(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                } else {
                    this.prepareDetectorIndexing();
                }
            }
            catch (IOException e) {
                this.onFailures(e);
            }
        }

        void prepareDetectorIndexing() throws IOException {
            if (this.request.getMethod() == RestRequest.Method.POST) {
                this.createDetector();
            } else if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateDetector();
            }
        }

        void createDetector() {
            Detector detector = this.request.getDetector();
            String ruleTopic = detector.getDetectorType();
            this.request.getDetector().setAlertsIndex(DetectorMonitorConfig.getAlertsIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndex(DetectorMonitorConfig.getAlertsHistoryIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndexPattern(DetectorMonitorConfig.getAlertsHistoryIndexPattern(ruleTopic));
            this.request.getDetector().setFindingsIndex(DetectorMonitorConfig.getFindingsIndex(ruleTopic));
            this.request.getDetector().setFindingsIndexPattern(DetectorMonitorConfig.getFindingsIndexPattern(ruleTopic));
            this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndex(ruleTopic));
            User originalContextUser = this.user;
            log.debug("user from original context is {}", (Object)originalContextUser);
            this.request.getDetector().setUser(originalContextUser);
            if (!detector.getInputs().isEmpty()) {
                try {
                    TransportIndexDetectorAction.this.ruleTopicIndices.initRuleTopicIndexTemplate(new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                            AsyncIndexDetectorsAction.this.initRuleIndexAndImportRules(AsyncIndexDetectorsAction.this.request, new ActionListener<List<IndexMonitorResponse>>(){

                                public void onResponse(List<IndexMonitorResponse> monitorResponses) {
                                    AsyncIndexDetectorsAction.this.request.getDetector().setMonitorIds(AsyncIndexDetectorsAction.this.getMonitorIds(monitorResponses));
                                    AsyncIndexDetectorsAction.this.request.getDetector().setRuleIdMonitorIdMap(AsyncIndexDetectorsAction.this.mapMonitorIds(monitorResponses));
                                    try {
                                        AsyncIndexDetectorsAction.this.indexDetector();
                                    }
                                    catch (IOException e) {
                                        AsyncIndexDetectorsAction.this.onFailures(e);
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }
                catch (IOException e) {
                    this.onFailures(e);
                }
            }
        }

        void updateDetector() {
            final String id = this.request.getDetectorId();
            final User originalContextUser = this.user;
            log.debug("user from original context is {}", (Object)originalContextUser);
            GetRequest request = new GetRequest(".opensearch-sap-detectors-config", id);
            TransportIndexDetectorAction.this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", id), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                        Detector detector = Detector.docParse(xcp, response.getId(), response.getVersion());
                        if (!TransportIndexDetectorAction.this.checkUserPermissionsWithResource(originalContextUser, detector.getUser(), "detector", detector.getId(), TransportIndexDetectorAction.this.filterByEnabled)) {
                            this.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0])));
                            return;
                        }
                        AsyncIndexDetectorsAction.this.onGetResponse(detector, detector.getUser());
                    }
                    catch (IOException e) {
                        AsyncIndexDetectorsAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        void onGetResponse(Detector currentDetector, User user) {
            if (this.request.getDetector().getEnabled().booleanValue() && currentDetector.getEnabled().booleanValue()) {
                this.request.getDetector().setEnabledTime(currentDetector.getEnabledTime());
            }
            this.request.getDetector().setMonitorIds(currentDetector.getMonitorIds());
            this.request.getDetector().setRuleIdMonitorIdMap(currentDetector.getRuleIdMonitorIdMap());
            Detector detector = this.request.getDetector();
            String ruleTopic = detector.getDetectorType();
            log.debug("user in update detector {}", (Object)user);
            this.request.getDetector().setAlertsIndex(DetectorMonitorConfig.getAlertsIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndex(DetectorMonitorConfig.getAlertsHistoryIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndexPattern(DetectorMonitorConfig.getAlertsHistoryIndexPattern(ruleTopic));
            this.request.getDetector().setFindingsIndex(DetectorMonitorConfig.getFindingsIndex(ruleTopic));
            this.request.getDetector().setFindingsIndexPattern(DetectorMonitorConfig.getFindingsIndexPattern(ruleTopic));
            this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndex(ruleTopic));
            this.request.getDetector().setUser(user);
            if (!detector.getInputs().isEmpty()) {
                try {
                    TransportIndexDetectorAction.this.ruleTopicIndices.initRuleTopicIndexTemplate(new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                            AsyncIndexDetectorsAction.this.initRuleIndexAndImportRules(AsyncIndexDetectorsAction.this.request, new ActionListener<List<IndexMonitorResponse>>(){

                                public void onResponse(List<IndexMonitorResponse> monitorResponses) {
                                    AsyncIndexDetectorsAction.this.request.getDetector().setMonitorIds(AsyncIndexDetectorsAction.this.getMonitorIds(monitorResponses));
                                    AsyncIndexDetectorsAction.this.request.getDetector().setRuleIdMonitorIdMap(AsyncIndexDetectorsAction.this.mapMonitorIds(monitorResponses));
                                    try {
                                        AsyncIndexDetectorsAction.this.indexDetector();
                                    }
                                    catch (IOException e) {
                                        AsyncIndexDetectorsAction.this.onFailures(e);
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }
                catch (IOException e) {
                    this.onFailures(e);
                }
            }
        }

        public void initRuleIndexAndImportRules(final IndexDetectorRequest request, final ActionListener<List<IndexMonitorResponse>> listener) {
            TransportIndexDetectorAction.this.ruleIndices.initPrepackagedRulesIndex(new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    TransportIndexDetectorAction.this.ruleIndices.onCreateMappingsResponse(response, true);
                    TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                        public void onResponse(BulkResponse response) {
                            if (!response.hasFailures()) {
                                AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                            } else {
                                AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            }, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    TransportIndexDetectorAction.this.ruleIndices.onUpdateMappingsResponse(response, true);
                    TransportIndexDetectorAction.this.ruleIndices.deleteRules(new ActionListener<BulkByScrollResponse>(){

                        public void onResponse(BulkByScrollResponse response) {
                            TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (!response.hasFailures()) {
                                        AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                                    } else {
                                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            }, new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    long count;
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    if ((count = response.getHits().getTotalHits().value) == 0L) {
                        TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                            public void onResponse(BulkResponse response) {
                                if (!response.hasFailures()) {
                                    AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                                } else {
                                    AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                }
                            }

                            public void onFailure(Exception e) {
                                AsyncIndexDetectorsAction.this.onFailures(e);
                            }
                        });
                    } else {
                        AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        public void importRules(final IndexDetectorRequest request, final ActionListener<List<IndexMonitorResponse>> listener) {
            final Detector detector = request.getDetector();
            String ruleTopic = detector.getDetectorType();
            final DetectorInput detectorInput = detector.getInputs().get(0);
            final String logIndex = detectorInput.getIndices().get(0);
            List<String> ruleIds = detectorInput.getPrePackagedRules().stream().map(DetectorRule::getId).collect(Collectors.toList());
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"rule", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"rule.category", (Object)ruleTopic)).must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (String[])ruleIds.toArray(new String[0]))), (ScoreMode)ScoreMode.Avg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-pre-packaged-rules-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000));
            TransportIndexDetectorAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    SearchHits hits = response.getHits();
                    ArrayList<Pair<String, Rule>> queries = new ArrayList<Pair<String, Rule>>();
                    try {
                        for (SearchHit hit : hits) {
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
                            String id = hit.getId();
                            queries.add((Pair<String, Rule>)Pair.of((Object)id, (Object)rule));
                        }
                        if (TransportIndexDetectorAction.this.ruleIndices.ruleIndexExists(false)) {
                            AsyncIndexDetectorsAction.this.importCustomRules(detector, detectorInput, queries, (ActionListener<List<IndexMonitorResponse>>)listener);
                        } else if (detectorInput.getCustomRules().size() > 0) {
                            AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException("Custom Rule Index not found", RestStatus.NOT_FOUND, new Object[0]));
                        } else if (request.getMethod() == RestRequest.Method.POST) {
                            TransportIndexDetectorAction.this.createMonitorFromQueries(logIndex, queries, detector, (ActionListener<List<IndexMonitorResponse>>)listener, request.getRefreshPolicy());
                        } else if (request.getMethod() == RestRequest.Method.PUT) {
                            TransportIndexDetectorAction.this.updateMonitorFromQueries(logIndex, queries, detector, (ActionListener<List<IndexMonitorResponse>>)listener, request.getRefreshPolicy());
                        }
                    }
                    catch (IOException | SigmaError e) {
                        AsyncIndexDetectorsAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        public void importCustomRules(final Detector detector, DetectorInput detectorInput, final List<Pair<String, Rule>> queries, final ActionListener<List<IndexMonitorResponse>> listener) {
            final String logIndex = detectorInput.getIndices().get(0);
            List<String> ruleIds = detectorInput.getCustomRules().stream().map(DetectorRule::getId).collect(Collectors.toList());
            TermsQueryBuilder queryBuilder = QueryBuilders.termsQuery((String)"_id", (String[])ruleIds.toArray(new String[0]));
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-custom-rules-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000));
            TransportIndexDetectorAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    SearchHits hits = response.getHits();
                    try {
                        for (SearchHit hit : hits) {
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
                            String id = hit.getId();
                            queries.add(Pair.of((Object)id, (Object)rule));
                        }
                        if (AsyncIndexDetectorsAction.this.request.getMethod() == RestRequest.Method.POST) {
                            TransportIndexDetectorAction.this.createMonitorFromQueries(logIndex, queries, detector, (ActionListener<List<IndexMonitorResponse>>)listener, AsyncIndexDetectorsAction.this.request.getRefreshPolicy());
                        } else if (AsyncIndexDetectorsAction.this.request.getMethod() == RestRequest.Method.PUT) {
                            TransportIndexDetectorAction.this.updateMonitorFromQueries(logIndex, queries, detector, (ActionListener<List<IndexMonitorResponse>>)listener, AsyncIndexDetectorsAction.this.request.getRefreshPolicy());
                        }
                    }
                    catch (IOException | SigmaError ex) {
                        AsyncIndexDetectorsAction.this.onFailures(ex);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        public void indexDetector() throws IOException {
            IndexRequest indexRequest = this.request.getMethod() == RestRequest.Method.POST ? (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-detectors-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(this.request.getDetector().toXContentWithUser(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).timeout(TransportIndexDetectorAction.this.indexTimeout) : (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-detectors-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(this.request.getDetector().toXContentWithUser(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).id(this.request.getDetectorId()).timeout(TransportIndexDetectorAction.this.indexTimeout);
            TransportIndexDetectorAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    Detector responseDetector = AsyncIndexDetectorsAction.this.request.getDetector();
                    responseDetector.setId(response.getId());
                    AsyncIndexDetectorsAction.this.onOperation(response, responseDetector);
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        private void onOperation(IndexResponse response, Detector detector) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(detector, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(Detector detector, Exception t) {
            TransportIndexDetectorAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new IndexDetectorResponse(detector.getId(), detector.getVersion(), this.request.getMethod() == RestRequest.Method.POST ? RestStatus.CREATED : RestStatus.OK, detector);
            }));
        }

        private List<String> getMonitorIds(List<IndexMonitorResponse> monitorResponses) {
            return monitorResponses.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList());
        }

        private Map<String, String> mapMonitorIds(List<IndexMonitorResponse> monitorResponses) {
            return monitorResponses.stream().collect(Collectors.toMap(it -> {
                if (Monitor.MonitorType.BUCKET_LEVEL_MONITOR == it.getMonitor().getMonitorType()) {
                    return ((Trigger)it.getMonitor().getTriggers().get(0)).getId();
                }
                return "-1";
            }, IndexMonitorResponse::getId));
        }
    }
}

