/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.IndexDetectorResponse;
import org.opensearch.securityanalytics.action.IndexRuleRequest;
import org.opensearch.securityanalytics.action.IndexRuleResponse;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.exceptions.SigmaError;
import org.opensearch.securityanalytics.rules.objects.SigmaRule;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndexRuleAction
extends HandledTransportAction<IndexRuleRequest, IndexRuleResponse> {
    private static final Logger log = LogManager.getLogger(TransportIndexRuleAction.class);
    private final Client client;
    private final RuleIndices ruleIndices;
    private final DetectorIndices detectorIndices;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Settings settings;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportIndexRuleAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, DetectorIndices detectorIndices, RuleIndices ruleIndices, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/securityanalytics/rule/write", transportService, actionFilters, IndexRuleRequest::new);
        this.client = client;
        this.detectorIndices = detectorIndices;
        this.ruleIndices = ruleIndices;
        this.threadPool = ruleIndices.getThreadPool();
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.settings = settings;
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
    }

    protected void doExecute(Task task, IndexRuleRequest request, ActionListener<IndexRuleResponse> listener) {
        AsyncIndexRulesAction asyncAction = new AsyncIndexRulesAction(task, request, listener);
        asyncAction.start();
    }

    class AsyncIndexRulesAction {
        private final IndexRuleRequest request;
        private final ActionListener<IndexRuleResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final AtomicInteger checker = new AtomicInteger();
        private final Task task;

        AsyncIndexRulesAction(Task task, IndexRuleRequest request, ActionListener<IndexRuleResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            TransportIndexRuleAction.this.threadPool.getThreadContext().stashContext();
            try {
                if (!TransportIndexRuleAction.this.ruleIndices.ruleIndexExists(false)) {
                    TransportIndexRuleAction.this.ruleIndices.initRuleIndex(new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            TransportIndexRuleAction.this.ruleIndices.onCreateMappingsResponse(response, false);
                            AsyncIndexRulesAction.this.prepareRuleIndexing();
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexRulesAction.this.onFailures(e);
                        }
                    }, false);
                } else if (!IndexUtils.customRuleIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-custom-rules-config", RuleIndices.ruleMappings(), TransportIndexRuleAction.this.clusterService.state(), TransportIndexRuleAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            TransportIndexRuleAction.this.ruleIndices.onUpdateMappingsResponse(response, false);
                            AsyncIndexRulesAction.this.prepareRuleIndexing();
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexRulesAction.this.onFailures(e);
                        }
                    });
                } else {
                    this.prepareRuleIndexing();
                }
            }
            catch (IOException ex) {
                this.onFailures(ex);
            }
        }

        void prepareRuleIndexing() {
            String rule = this.request.getRule();
            String category = this.request.getLogType().toLowerCase(Locale.ROOT);
            try {
                SigmaRule parsedRule = SigmaRule.fromYaml(rule, true);
                if (parsedRule.getErrors() != null && parsedRule.getErrors().size() > 0) {
                    this.onFailures(parsedRule.getErrors().toArray(new SigmaError[0]));
                    return;
                }
                OSQueryBackend backend = new OSQueryBackend(category, true, true);
                List<Object> queries = backend.convertRule(parsedRule);
                Set<String> queryFieldNames = backend.getQueryFields().keySet();
                Rule ruleDoc = new Rule("", Detector.NO_VERSION, parsedRule, category, queries, new ArrayList<String>(queryFieldNames), rule);
                this.indexRule(ruleDoc);
            }
            catch (IOException | SigmaError e) {
                this.onFailures(e);
            }
        }

        void indexRule(final Rule rule) throws IOException {
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                if (TransportIndexRuleAction.this.detectorIndices.detectorIndexExists()) {
                    this.searchDetectors(this.request.getRuleId(), new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            if (response.isTimedOut()) {
                                AsyncIndexRulesAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with id %s cannot be updated", rule.getId()), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                                return;
                            }
                            if (response.getHits().getTotalHits().value > 0L) {
                                if (!AsyncIndexRulesAction.this.request.isForced().booleanValue()) {
                                    AsyncIndexRulesAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with id %s is actively used by detectors. Update can be forced by setting forced flag to true", AsyncIndexRulesAction.this.request.getRuleId()), RestStatus.BAD_REQUEST, new Object[0])});
                                    return;
                                }
                                ArrayList<Detector> detectors = new ArrayList<Detector>();
                                try {
                                    for (SearchHit hit : response.getHits()) {
                                        XContentParser xcp = XContentType.JSON.xContent().createParser(TransportIndexRuleAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                                        Detector detector = Detector.docParse(xcp, hit.getId(), hit.getVersion());
                                        detectors.add(detector);
                                    }
                                    AsyncIndexRulesAction.this.updateRule(rule, detectors);
                                }
                                catch (IOException ex) {
                                    AsyncIndexRulesAction.this.onFailures(ex);
                                }
                            } else {
                                try {
                                    AsyncIndexRulesAction.this.updateRule(rule, List.of());
                                }
                                catch (IOException ex) {
                                    AsyncIndexRulesAction.this.onFailures(ex);
                                }
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexRulesAction.this.onFailures(e);
                        }
                    });
                } else {
                    this.updateRule(rule, List.of());
                }
            } else {
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-custom-rules-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(rule.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).timeout(TransportIndexRuleAction.this.indexTimeout);
                TransportIndexRuleAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        rule.setId(response.getId());
                        AsyncIndexRulesAction.this.onOperation(response, rule);
                    }

                    public void onFailure(Exception e) {
                        AsyncIndexRulesAction.this.onFailures(e);
                    }
                });
            }
        }

        private void searchDetectors(String ruleId, ActionListener<SearchResponse> listener) {
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector.inputs.detector_input.custom_rules", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.inputs.detector_input.custom_rules.id", (Object)ruleId)), (ScoreMode)ScoreMode.Avg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-detectors-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000));
            TransportIndexRuleAction.this.client.search(searchRequest, listener);
        }

        private void updateDetectors(final IndexResponse indexResponse, final Rule rule, final List<Detector> detectors) {
            for (Detector detector : detectors) {
                IndexDetectorRequest indexRequest = new IndexDetectorRequest(detector.getId(), this.request.getRefreshPolicy(), RestRequest.Method.PUT, detector);
                TransportIndexRuleAction.this.client.execute((ActionType)IndexDetectorAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexDetectorResponse>(){

                    public void onResponse(IndexDetectorResponse response) {
                        if (response.getStatus() != RestStatus.OK) {
                            AsyncIndexRulesAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with id %s cannot be updated", AsyncIndexRulesAction.this.request.getRuleId()), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                        }
                        AsyncIndexRulesAction.this.onComplete(indexResponse, rule, detectors.size());
                    }

                    public void onFailure(Exception e) {
                        AsyncIndexRulesAction.this.onFailures(e);
                    }
                });
            }
        }

        private void updateRule(final Rule rule, final List<Detector> detectors) throws IOException {
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-custom-rules-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(rule.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).id(this.request.getRuleId()).timeout(TransportIndexRuleAction.this.indexTimeout);
            TransportIndexRuleAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    rule.setId(response.getId());
                    if (detectors.size() > 0) {
                        AsyncIndexRulesAction.this.updateDetectors(response, rule, detectors);
                    } else {
                        AsyncIndexRulesAction.this.onOperation(response, rule);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexRulesAction.this.onFailures(e);
                }
            });
        }

        private void onComplete(IndexResponse response, Rule rule, int target) {
            if (this.checker.incrementAndGet() == target) {
                this.onOperation(response, rule);
            }
        }

        private void onOperation(IndexResponse response, Rule rule) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(rule, new Exception[0]);
            }
        }

        private void onFailures(Exception ... t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(Rule rule, Exception ... t) {
            TransportIndexRuleAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null && t.length > 0) {
                    if (t.length > 1) {
                        throw SecurityAnalyticsException.wrap(Arrays.asList(t));
                    }
                    throw SecurityAnalyticsException.wrap(t[0]);
                }
                return new IndexRuleResponse(rule.getId(), rule.getVersion(), RestStatus.CREATED, rule);
            }));
        }
    }
}

