/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;

public class IndexUtils {
    private static final String _META = "_meta";
    private static final Integer NO_SCHEMA_VERSION = 0;
    private static final String SCHEMA_VERSION = "schema_version";
    public static Boolean detectorIndexUpdated = false;
    public static Boolean customRuleIndexUpdated = false;
    public static Boolean prePackagedRuleIndexUpdated = false;

    public static void detectorIndexUpdated() {
        detectorIndexUpdated = true;
    }

    public static void customRuleIndexUpdated() {
        customRuleIndexUpdated = true;
    }

    public static void prePackagedRuleIndexUpdated() {
        prePackagedRuleIndexUpdated = true;
    }

    public static Integer getSchemaVersion(String mapping) throws IOException {
        XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
        while (!xcp.isClosed()) {
            XContentParser.Token token = xcp.currentToken();
            if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                if (!Objects.equals(xcp.currentName(), _META)) {
                    xcp.nextToken();
                    xcp.skipChildren();
                } else {
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        switch (xcp.currentName()) {
                            case "schema_version": {
                                int version = xcp.intValue();
                                if (version < 0) {
                                    throw new IllegalArgumentException(String.format(Locale.getDefault(), "%s cannot be negative", SCHEMA_VERSION));
                                }
                                return version;
                            }
                        }
                        xcp.nextToken();
                    }
                }
            }
            xcp.nextToken();
        }
        return NO_SCHEMA_VERSION;
    }

    public static Boolean shouldUpdateIndex(IndexMetadata index, String mapping) throws IOException {
        HashMap metaData;
        Integer oldVersion = NO_SCHEMA_VERSION;
        Integer newVersion = IndexUtils.getSchemaVersion(mapping);
        Map indexMapping = index.mapping().sourceAsMap();
        if (indexMapping != null && indexMapping.containsKey(_META) && indexMapping.get(_META) instanceof HashMap && (metaData = (HashMap)indexMapping.get(_META)).containsKey(SCHEMA_VERSION)) {
            oldVersion = (Integer)metaData.get(SCHEMA_VERSION);
        }
        return newVersion > oldVersion;
    }

    public static void updateIndexMapping(String index, String mapping, ClusterState clusterState, IndicesAdminClient client, ActionListener<AcknowledgedResponse> actionListener) throws IOException {
        if (clusterState.metadata().indices().containsKey((Object)index)) {
            if (IndexUtils.shouldUpdateIndex(clusterState.metadata().index(index), mapping).booleanValue()) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index}).source(mapping, XContentType.JSON);
                client.putMapping(putMappingRequest, actionListener);
            } else {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }
    }

    public static boolean isDataStream(String name, ClusterState clusterState) {
        return clusterState.getMetadata().dataStreams().containsKey(name);
    }

    public static boolean isAlias(String indexName, ClusterState clusterState) {
        return clusterState.getMetadata().hasAlias(indexName);
    }

    public static String getWriteIndex(String indexName, ClusterState clusterState) {
        IndexMetadata metadata;
        if ((IndexUtils.isAlias(indexName, clusterState) || IndexUtils.isDataStream(indexName, clusterState)) && (metadata = ((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(indexName)).getWriteIndex()) != null) {
            return metadata.getIndex().getName();
        }
        return null;
    }

    public static boolean isConcreteIndex(String indexName, ClusterState clusterState) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(indexName);
        if (indexAbstraction != null) {
            return indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX;
        }
        return false;
    }

    public static String getNewestIndexByCreationDate(String[] concreteIndices, ClusterState clusterState) {
        SortedMap lookup = clusterState.getMetadata().getIndicesLookup();
        long maxCreationDate = Long.MIN_VALUE;
        String newestIndex = null;
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            IndexMetadata indexMetadata = clusterState.getMetadata().index(indexName);
            if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX || indexMetadata.getCreationDate() <= maxCreationDate) continue;
            maxCreationDate = indexMetadata.getCreationDate();
            newestIndex = indexName;
        }
        return newestIndex;
    }

    public static String getNewIndexByCreationDate(ClusterState state, IndexNameExpressionResolver i, String index) {
        String[] strings = i.concreteIndexNames(state, IndicesOptions.LENIENT_EXPAND_OPEN, new String[]{index});
        return IndexUtils.getNewestIndexByCreationDate(strings, state);
    }
}

