/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends ClusterManagerNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest,
ToXContentFragment {
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    @Deprecated
    @Nullable
    private String template;
    private int order;
    private boolean create;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private BytesReference mappings = null;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Integer version;

    public PutIndexTemplateRequest(String name) {
        this.name(name);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.template == null && (this.indexPatterns == null || this.indexPatterns.size() == 0)) {
            validationException = ValidateActions.addValidationError((String)"index patterns are missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String source, XContentType xContentType) {
        this.internalMapping((Map)XContentHelper.convertToMap((BytesReference)new BytesArray(source), (boolean)true, (XContentType)xContentType).v2());
        return this;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(XContentBuilder source) {
        this.internalMapping((Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)source), (boolean)true, (XContentType)source.contentType()).v2());
        return this;
    }

    public PutIndexTemplateRequest mapping(BytesReference source, XContentType xContentType) {
        this.internalMapping((Map)XContentHelper.convertToMap((BytesReference)source, (boolean)true, (XContentType)xContentType).v2());
        return this;
    }

    public PutIndexTemplateRequest mapping(Map<String, Object> source) {
        return this.internalMapping(source);
    }

    private PutIndexTemplateRequest internalMapping(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(source);
            Objects.requireNonNull(builder.contentType());
            try {
                this.mappings = new BytesArray(XContentHelper.convertToJson((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (boolean)false, (XContentType)builder.contentType()));
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to convert source to json", e);
            }
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", (Throwable)e);
        }
    }

    public BytesReference mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes((XContentBuilder)templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map<String, Object> templateSource) {
        Map<String, Object> source = templateSource;
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("template")) {
                if (!(entry.getValue() instanceof String)) continue;
                this.template = (String)entry.getValue();
                continue;
            }
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.toList());
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [index_patterns] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue((Object)entry.getValue(), (int)this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                this.mapping(mappings);
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new OpenSearchParseException("unknown key [{}] in the template ", new Object[]{name});
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap((XContent)xContentType.xContent(), (String)templateSource, (boolean)true));
    }

    public PutIndexTemplateRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source((BytesReference)new BytesArray(source, offset, length), xContentType);
    }

    public PutIndexTemplateRequest source(BytesReference source, XContentType xContentType) {
        return this.source((Map)XContentHelper.convertToMap((BytesReference)source, (boolean)true, (XContentType)xContentType).v2());
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes((XContentBuilder)builder));
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", (Throwable)e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes((XContentBuilder)source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases((BytesReference)new BytesArray(source));
    }

    public PutIndexTemplateRequest aliases(BytesReference source) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent((XContentParser)parser));
                }
                putIndexTemplateRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putIndexTemplateRequest;
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.template != null) {
            builder.field("template", this.template);
        } else {
            builder.field("index_patterns", this.indexPatterns);
        }
        builder.field("order", this.order);
        if (this.version != null) {
            builder.field("version", this.version);
        }
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        if (this.mappings != null) {
            builder.field("mappings");
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, this.mappings.utf8ToString());){
                builder.copyCurrentStructure(parser);
            }
        }
        builder.startObject("aliases");
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

