/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.util.SafeSecurityInjector;
import org.opensearch.ad.util.SecurityUtil;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;

public class ADSafeSecurityInjector
extends SafeSecurityInjector {
    private static final Logger LOG = LogManager.getLogger(ADSafeSecurityInjector.class);
    private NodeStateManager nodeStateManager;

    public ADSafeSecurityInjector(String detectorId, Settings settings, ThreadContext tc, NodeStateManager stateManager) {
        super(detectorId, settings, tc);
        this.nodeStateManager = stateManager;
    }

    public void injectUserRolesFromDetector(ActionListener<Void> injectListener) {
        if (Strings.isEmpty((CharSequence)this.id)) {
            LOG.debug("Empty id");
            injectListener.onResponse(null);
            return;
        }
        if (!this.shouldInject()) {
            LOG.debug("Don't need to inject");
            injectListener.onResponse(null);
            return;
        }
        ActionListener getDetectorListener = ActionListener.wrap(detectorOp -> {
            if (!detectorOp.isPresent()) {
                injectListener.onFailure((Exception)new EndRunException(this.id, "AnomalyDetector is not available.", false));
                return;
            }
            AnomalyDetector detector = (AnomalyDetector)detectorOp.get();
            User userInfo = SecurityUtil.getUserFromDetector(detector, this.settings);
            this.inject(userInfo.getName(), userInfo.getRoles());
            injectListener.onResponse(null);
        }, arg_0 -> injectListener.onFailure(arg_0));
        this.nodeStateManager.getAnomalyDetector(this.id, (ActionListener<Optional<AnomalyDetector>>)getDetectorListener);
    }

    public void injectUserRoles(User user) {
        if (user == null) {
            LOG.debug("null user");
            return;
        }
        if (this.shouldInject()) {
            this.inject(user.getName(), user.getRoles());
        }
    }
}

