/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.planner.physical.AggregationOperator;
import org.opensearch.sql.planner.physical.DedupeOperator;
import org.opensearch.sql.planner.physical.EvalOperator;
import org.opensearch.sql.planner.physical.FilterOperator;
import org.opensearch.sql.planner.physical.LimitOperator;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.ProjectOperator;
import org.opensearch.sql.planner.physical.RareTopNOperator;
import org.opensearch.sql.planner.physical.RemoveOperator;
import org.opensearch.sql.planner.physical.RenameOperator;
import org.opensearch.sql.planner.physical.SortOperator;
import org.opensearch.sql.planner.physical.ValuesOperator;
import org.opensearch.sql.planner.physical.WindowOperator;

public final class PhysicalPlanDSL {
    public static AggregationOperator agg(PhysicalPlan input, List<NamedAggregator> aggregators, List<NamedExpression> groups) {
        return new AggregationOperator(input, aggregators, groups);
    }

    public static FilterOperator filter(PhysicalPlan input, Expression condition) {
        return new FilterOperator(input, condition);
    }

    public static RenameOperator rename(PhysicalPlan input, Map<ReferenceExpression, ReferenceExpression> renameMap) {
        return new RenameOperator(input, renameMap);
    }

    public static ProjectOperator project(PhysicalPlan input, NamedExpression ... fields) {
        return new ProjectOperator(input, Arrays.asList(fields), (List<NamedExpression>)ImmutableList.of());
    }

    public static ProjectOperator project(PhysicalPlan input, List<NamedExpression> fields, List<NamedExpression> namedParseExpressions) {
        return new ProjectOperator(input, fields, namedParseExpressions);
    }

    public static RemoveOperator remove(PhysicalPlan input, ReferenceExpression ... fields) {
        return new RemoveOperator(input, (Set<ReferenceExpression>)ImmutableSet.copyOf((Object[])fields));
    }

    public static EvalOperator eval(PhysicalPlan input, Pair<ReferenceExpression, Expression> ... expressions) {
        return new EvalOperator(input, Arrays.asList(expressions));
    }

    public static SortOperator sort(PhysicalPlan input, Pair<Sort.SortOption, Expression> ... sorts) {
        return new SortOperator(input, Arrays.asList(sorts));
    }

    public static DedupeOperator dedupe(PhysicalPlan input, Expression ... expressions) {
        return new DedupeOperator(input, Arrays.asList(expressions));
    }

    public static DedupeOperator dedupe(PhysicalPlan input, int allowedDuplication, boolean keepEmpty, boolean consecutive, Expression ... expressions) {
        return new DedupeOperator(input, Arrays.asList(expressions), allowedDuplication, keepEmpty, consecutive);
    }

    public static WindowOperator window(PhysicalPlan input, NamedExpression windowFunction, WindowDefinition windowDefinition) {
        return new WindowOperator(input, windowFunction, windowDefinition);
    }

    public static RareTopNOperator rareTopN(PhysicalPlan input, RareTopN.CommandType commandType, List<Expression> groups, Expression ... expressions) {
        return new RareTopNOperator(input, commandType, Arrays.asList(expressions), groups);
    }

    public static RareTopNOperator rareTopN(PhysicalPlan input, RareTopN.CommandType commandType, int noOfResults, List<Expression> groups, Expression ... expressions) {
        return new RareTopNOperator(input, commandType, noOfResults, Arrays.asList(expressions), groups);
    }

    @SafeVarargs
    public static ValuesOperator values(List<LiteralExpression> ... values) {
        return new ValuesOperator(Arrays.asList(values));
    }

    public static LimitOperator limit(PhysicalPlan input, Integer limit, Integer offset) {
        return new LimitOperator(input, limit, offset);
    }

    @Generated
    private PhysicalPlanDSL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

