/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.observability.model.ScheduledJobDoc;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/observability/resthandler/SchedulerRestHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "executePostRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "getName", "", "prepareRequest", "responseParams", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-observability"})
public final class SchedulerRestHandler
extends BaseRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SCHEDULE_ACTION = "observability_jobs_actions";
    @NotNull
    public static final String SCHEDULED_JOB_INDEX = ".opensearch-observability-job";
    @NotNull
    private static final String OBSERVABILITY_SCHEDULE_URL = "_plugins/poc/_schedule";
    private static final int CONSTANT = 10;

    @NotNull
    public String getName() {
        return SCHEDULE_ACTION;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.POST, OBSERVABILITY_SCHEDULE_URL));
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"objectId", "objectIdList", "objectType", "sortField", "sortOrder", "fromIndex", "maxItems"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private final BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest request, NodeClient client) {
        if (request.method() == RestRequest.Method.POST) {
            String sampleId = "id" + Math.random() * (double)10;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Instant instant2 = instant;
            instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            ScheduledJobDoc scheduledJob = new ScheduledJobDoc(sampleId, instant2, instant, "__user__", CollectionsKt.emptyList(), ScheduledJobDoc.JobType.Metrics, (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES), true);
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(SCHEDULED_JOB_INDEX)).id(sampleId).source(ScheduledJobDoc.toXContent$default(scheduledJob, null, 1, null));
            Intrinsics.checkNotNullExpressionValue((Object)indexRequest, (String)"IndexRequest()\n         \u2026cheduledJob.toXContent())");
            IndexRequest indexRequest2 = indexRequest;
            return arg_0 -> SchedulerRestHandler.executePostRequest$lambda-0(client, indexRequest2, arg_0);
        }
        return arg_0 -> SchedulerRestHandler.executePostRequest$lambda-1(request, arg_0);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestRequest.Method method = request.method();
        return (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) == 1 ? this.executePostRequest(request, client) : arg_0 -> SchedulerRestHandler.prepareRequest$lambda-2(request, arg_0);
    }

    private static final void executePostRequest$lambda-0(NodeClient $client, IndexRequest $indexRequest, RestChannel restChannel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$indexRequest, (String)"$indexRequest");
        Intrinsics.checkNotNullParameter((Object)restChannel, (String)"restChannel");
        $client.index($indexRequest, (ActionListener)new ActionListener<IndexResponse>(restChannel){
            final /* synthetic */ RestChannel $restChannel;
            {
                this.$restChannel = $restChannel;
            }

            public void onResponse(@NotNull IndexResponse indexResponse) {
                Intrinsics.checkNotNullParameter((Object)indexResponse, (String)"indexResponse");
                try {
                    RestResponse restResponse = (RestResponse)new BytesRestResponse(RestStatus.OK, indexResponse.toXContent(JsonXContent.contentBuilder(), null));
                    this.$restChannel.sendResponse(restResponse);
                }
                catch (IOException e) {
                    this.$restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        });
    }

    private static final void executePostRequest$lambda-1(RestRequest $request, RestChannel restChannel) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)restChannel, (String)"restChannel");
        restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed."));
    }

    private static final void prepareRequest$lambda-2(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/observability/resthandler/SchedulerRestHandler$Companion;", "", "()V", "CONSTANT", "", "OBSERVABILITY_SCHEDULE_URL", "", "SCHEDULED_JOB_INDEX", "SCHEDULE_ACTION", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            nArray[RestRequest.Method.POST.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

