/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.scheduler;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.observability.model.ScheduledJobDoc;
import org.opensearch.observability.util.HelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/observability/scheduler/ObservabilityJobRunner;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobRunner;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "runJob", "", "job", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "context", "Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "opensearch-observability"})
public final class ObservabilityJobRunner
implements ScheduledJobRunner {
    @NotNull
    public static final ObservabilityJobRunner INSTANCE = new ObservabilityJobRunner();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityJobRunner.class);
    @NotNull
    private static final CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));

    private ObservabilityJobRunner() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public void runJob(@NotNull ScheduledJobParameter job, @NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(job instanceof ScheduledJobDoc)) {
            this.getLog().warn("observability:job is not of type ScheduledJobDoc:" + job.getClass().getName());
            throw new IllegalArgumentException("job is not of type ScheduledJobDoc:" + job.getClass().getName());
        }
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, null){
            int label;
            final /* synthetic */ ScheduledJobParameter $job;
            {
                this.$job = $job;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ScheduledJobDoc scheduledJob = (ScheduledJobDoc)this.$job;
                        ScheduledJobDoc.JobType jobType = scheduledJob.getJobType();
                        ObservabilityJobRunner.access$getLog(ObservabilityJobRunner.INSTANCE).info("POC: Running job type: " + jobType.name());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Logger access$getLog(ObservabilityJobRunner $this) {
        return $this.getLog();
    }
}

