/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.net.InetAddresses;
import org.opensearch.performanceanalyzer.config.PluginSettings;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.ClusterDetailsEventProcessor;

public class InstanceDetails {
    private final AllMetrics.NodeRole role;
    private final Id instanceId;
    private final Ip instanceIp;
    private final boolean isClusterManager;
    private final int grpcPort;

    public InstanceDetails(AllMetrics.NodeRole role, Id instanceId, Ip instanceIp, boolean isClusterManager) {
        this(role, instanceId, instanceIp, isClusterManager, PluginSettings.instance().getRpcPort());
    }

    public InstanceDetails(AllMetrics.NodeRole role, Id instanceId, Ip instanceIp, boolean isClusterManager, int grpcPort) {
        this.role = role;
        this.instanceId = instanceId;
        this.instanceIp = instanceIp;
        this.isClusterManager = isClusterManager;
        this.grpcPort = grpcPort;
    }

    public InstanceDetails(ClusterDetailsEventProcessor.NodeDetails nodeDetails) {
        this(AllMetrics.NodeRole.valueOf(nodeDetails.getRole()), new Id(nodeDetails.getId()), new Ip(nodeDetails.getHostAddress()), nodeDetails.getIsClusterManagerNode(), nodeDetails.getGrpcPort());
    }

    public InstanceDetails(AllMetrics.NodeRole role) {
        this(role, new Id("unknown"), new Ip("0.0.0.0"), false);
    }

    @VisibleForTesting
    public InstanceDetails(Id instanceId, Ip instanceIp, int myGrpcServerPort) {
        this(AllMetrics.NodeRole.UNKNOWN, instanceId, instanceIp, false, myGrpcServerPort);
    }

    public AllMetrics.NodeRole getRole() {
        return this.isClusterManager ? AllMetrics.NodeRole.ELECTED_CLUSTER_MANAGER : this.role;
    }

    public Id getInstanceId() {
        return this.instanceId;
    }

    public Ip getInstanceIp() {
        return this.instanceIp;
    }

    public boolean getIsClusterManager() {
        return this.isClusterManager;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceDetails)) {
            return false;
        }
        InstanceDetails that = (InstanceDetails)o;
        return this.isClusterManager == that.isClusterManager && this.getGrpcPort() == that.getGrpcPort() && this.getRole() == that.getRole() && Objects.equal((Object)this.getInstanceId(), (Object)that.getInstanceId()) && Objects.equal((Object)this.getInstanceIp(), (Object)that.getInstanceIp());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getRole(), this.getInstanceId(), this.getInstanceIp(), this.isClusterManager, this.getGrpcPort()});
    }

    public String toString() {
        return this.instanceId + "::" + this.instanceIp + "::" + this.role + "::" + this.grpcPort;
    }

    public static class Id {
        private String id;

        public Id(String id) {
            if (InetAddresses.isInetAddress((String)id)) {
                throw new IllegalArgumentException("The provided string is in the form an IPV4 address: '" + id + "'. Are you sure this is the host ID");
            }
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id id1 = (Id)o;
            return Objects.equal((Object)this.id, (Object)id1.id);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id});
        }

        public String toString() {
            return this.id;
        }
    }

    public static class Ip {
        private String ip;

        public Ip(String ip) {
            if (!InetAddresses.isInetAddress((String)ip)) {
                throw new IllegalArgumentException("The provided string is not an IPV4ip: '" + ip + "'");
            }
            this.ip = ip;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ip)) {
                return false;
            }
            Ip ip1 = (Ip)o;
            return Objects.equal((Object)this.ip, (Object)ip1.ip);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ip});
        }

        public String toString() {
            return this.ip;
        }
    }
}

