/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.classification.Label;
import org.tribuo.classification.example.DemoLabelDataSource;
import org.tribuo.impl.ArrayExample;

public final class NoisyInterlockingCrescentsDataSource
extends DemoLabelDataSource {
    @Config(description="Variance of the Gaussian noise")
    private double variance = 0.1;

    private NoisyInterlockingCrescentsDataSource() {
    }

    public NoisyInterlockingCrescentsDataSource(int numSamples, long seed, double variance) {
        super(numSamples, seed);
        this.variance = variance;
        this.postConfig();
    }

    @Override
    public void postConfig() {
        if (this.variance <= 0.0) {
            throw new PropertyException("", "variance", "Variance must be positive, found " + this.variance);
        }
        super.postConfig();
    }

    @Override
    protected List<Example<Label>> generate() {
        double u;
        double[] values;
        int i;
        ArrayList<Example<Label>> list = new ArrayList<Example<Label>>();
        for (i = 0; i < this.numSamples / 2; ++i) {
            values = new double[2];
            u = this.rng.nextDouble();
            values[0] = Math.cos(Math.PI * u) + this.rng.nextGaussian() * this.variance;
            values[1] = Math.sin(Math.PI * u) + this.rng.nextGaussian() * this.variance;
            list.add((Example<Label>)new ArrayExample((Output)FIRST_CLASS, FEATURE_NAMES, values));
        }
        for (i = this.numSamples / 2; i < this.numSamples; ++i) {
            values = new double[2];
            u = this.rng.nextDouble();
            values[0] = 1.0 - Math.cos(Math.PI * u) + this.rng.nextGaussian() * this.variance;
            values[1] = 0.5 - Math.sin(Math.PI * u) + this.rng.nextGaussian() * this.variance;
            list.add((Example<Label>)new ArrayExample((Output)SECOND_CLASS, FEATURE_NAMES, values));
        }
        return list;
    }

    public String toString() {
        return "NoisyInterlockingCrescents(numSamples=" + this.numSamples + ",seed=" + this.seed + ",variance=" + this.variance + ')';
    }
}

