/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.utils.MLNodeUtils;

public class DiscoveryNodeHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(DiscoveryNodeHelper.class);
    private final ClusterService clusterService;
    private final HotDataNodePredicate eligibleNodeFilter;
    private volatile Boolean onlyRunOnMLNode;

    public DiscoveryNodeHelper(ClusterService clusterService, Settings settings) {
        this.clusterService = clusterService;
        this.eligibleNodeFilter = new HotDataNodePredicate();
        this.onlyRunOnMLNode = (Boolean)MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE, it -> {
            this.onlyRunOnMLNode = it;
        });
    }

    public String[] getEligibleNodeIds() {
        DiscoveryNode[] nodes = this.getEligibleNodes();
        String[] nodeIds = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeIds[i] = nodes[i].getId();
        }
        return nodeIds;
    }

    public DiscoveryNode[] getEligibleNodes() {
        ClusterState state = this.clusterService.state();
        ArrayList<DiscoveryNode> eligibleMLNodes = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> eligibleDataNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : state.nodes()) {
            if (MLNodeUtils.isMLNode(node)) {
                eligibleMLNodes.add(node);
            }
            if (this.onlyRunOnMLNode.booleanValue() || !node.isDataNode() || !this.isEligibleDataNode(node)) continue;
            eligibleDataNodes.add(node);
        }
        if (eligibleMLNodes.size() > 0) {
            Object[] mlNodes = eligibleMLNodes.toArray(new DiscoveryNode[0]);
            log.debug("Find {} dedicated ML nodes: {}", (Object)eligibleMLNodes.size(), (Object)Arrays.toString(mlNodes));
            return mlNodes;
        }
        Object[] dataNodes = eligibleDataNodes.toArray(new DiscoveryNode[0]);
        log.debug("Find no dedicated ML nodes. But have {} data nodes: {}", (Object)eligibleDataNodes.size(), (Object)Arrays.toString(dataNodes));
        return dataNodes;
    }

    public DiscoveryNode[] getAllNodes() {
        ClusterState state = this.clusterService.state();
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : state.nodes()) {
            nodes.add(node);
        }
        return nodes.toArray(new DiscoveryNode[0]);
    }

    public String[] getAllNodeIds() {
        ClusterState state = this.clusterService.state();
        ArrayList<String> allNodes = new ArrayList<String>();
        for (DiscoveryNode node : state.nodes()) {
            allNodes.add(node.getId());
        }
        return allNodes.toArray(new String[0]);
    }

    public DiscoveryNode[] getNodes(String[] nodeIds) {
        ClusterState state = this.clusterService.state();
        HashSet<String> nodes = new HashSet<String>();
        for (String nodeId : nodeIds) {
            nodes.add(nodeId);
        }
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : state.nodes()) {
            if (!nodes.contains(node.getId())) continue;
            discoveryNodes.add(node);
        }
        return discoveryNodes.toArray(new DiscoveryNode[0]);
    }

    public String[] getNodeIds(DiscoveryNode[] nodes) {
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (DiscoveryNode node : nodes) {
            nodeIds.add(node.getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    public boolean isEligibleDataNode(DiscoveryNode node) {
        return this.eligibleNodeFilter.test(node);
    }

    public DiscoveryNode getNode(String nodeId) {
        ClusterState state = this.clusterService.state();
        for (DiscoveryNode node : state.nodes()) {
            if (!node.getId().equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    static class HotDataNodePredicate
    implements Predicate<DiscoveryNode> {
        HotDataNodePredicate() {
        }

        @Override
        public boolean test(DiscoveryNode discoveryNode) {
            return discoveryNode.isDataNode() && discoveryNode.getAttributes().getOrDefault("box_type", CommonValue.HOT_BOX_TYPE).equals(CommonValue.HOT_BOX_TYPE);
        }
    }
}

