/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.upload.MLUploadInput;
import org.opensearch.ml.common.transport.upload.MLUploadModelAction;
import org.opensearch.ml.common.transport.upload.MLUploadModelRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUploadModelAction
extends BaseRestHandler {
    private static final String ML_UPLOAD_MODEL_ACTION = "ml_upload_model_action";

    public String getName() {
        return ML_UPLOAD_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_upload", "/_plugins/_ml")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/{%s}/_upload", "/_plugins/_ml", "model_id", "version")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUploadModelRequest mlUploadModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUploadModelAction.INSTANCE, (ActionRequest)mlUploadModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLUploadModelRequest getRequest(RestRequest request) throws IOException {
        String modelName = request.param("model_id");
        String version = request.param("version");
        boolean loadModel = request.paramAsBoolean("load", false);
        if (modelName != null && !request.hasContent()) {
            MLUploadInput mlInput = MLUploadInput.builder().loadModel(loadModel).modelName(modelName).version(version).build();
            return new MLUploadModelRequest(mlInput);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLUploadInput mlInput = modelName == null ? MLUploadInput.parse((XContentParser)parser, (boolean)loadModel) : MLUploadInput.parse((XContentParser)parser, (String)modelName, (String)version, (boolean)loadModel);
        return new MLUploadModelRequest(mlInput);
    }
}

