/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.join.ScoreMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"addUserBackendRolesFilter", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "user", "Lorg/opensearch/commons/authuser/User;", "searchSourceBuilder", "isADMonitor", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "opensearch-alerting"})
public final class AnomalyDetectionUtilsKt {
    public static final boolean isADMonitor(@NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        if (monitor.getInputs().size() != 1) {
            return false;
        }
        Input input = (Input)monitor.getInputs().get(0);
        return input instanceof SearchInput && ((SearchInput)input).getIndices().size() == 1 && Intrinsics.areEqual(((SearchInput)input).getIndices().get(0), (Object)".opendistro-anomaly-results*");
    }

    @NotNull
    public static final SearchSourceBuilder addUserBackendRolesFilter(@Nullable User user, @NotNull SearchSourceBuilder searchSourceBuilder) {
        Object userRolesFilterQuery;
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        String userFieldName = "user";
        String userBackendRoleFieldName = "user.backend_roles.keyword";
        if (user == null || Strings.isEmpty((CharSequence)user.getName())) {
            userRolesFilterQuery = QueryBuilders.existsQuery((String)userFieldName);
            NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
            boolQueryBuilder.mustNot((QueryBuilder)nestedQueryBuilder);
        } else {
            userRolesFilterQuery = user.getBackendRoles();
            if (userRolesFilterQuery == null || userRolesFilterQuery.isEmpty()) {
                userRolesFilterQuery = QueryBuilders.existsQuery((String)userBackendRoleFieldName);
                NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
                ExistsQueryBuilder userExistsQuery = QueryBuilders.existsQuery((String)userFieldName);
                NestedQueryBuilder userExistsNestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userExistsQuery, ScoreMode.None);
                boolQueryBuilder.mustNot((QueryBuilder)nestedQueryBuilder);
                boolQueryBuilder.must((QueryBuilder)userExistsNestedQueryBuilder);
            } else {
                userRolesFilterQuery = QueryBuilders.termsQuery((String)userBackendRoleFieldName, (Collection)user.getBackendRoles());
                NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
                boolQueryBuilder.must((QueryBuilder)nestedQueryBuilder);
            }
        }
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        }
        return searchSourceBuilder;
    }
}

