/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public class KNNCodecUtil {
    public static final String HNSW_EXTENSION = ".hnsw";
    public static final String HNSW_COMPOUND_EXTENSION = ".hnswc";

    public static Pair getFloats(BinaryDocValues values) throws IOException {
        ArrayList<float[]> vectorList = new ArrayList<float[]>();
        ArrayList<Integer> docIdList = new ArrayList<Integer>();
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef bytesref = values.binaryValue();
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytesref.bytes, bytesref.offset, bytesref.length);){
                KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
                float[] vector = vectorSerializer.byteToFloatArray(byteStream);
                vectorList.add(vector);
            }
            docIdList.add(doc);
            doc = values.nextDoc();
        }
        return new Pair(docIdList.stream().mapToInt(Integer::intValue).toArray(), (float[][])vectorList.toArray((T[])new float[0][]));
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format("%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format("%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format("_%s%s", fieldName, extension);
    }

    public static final class Pair {
        public int[] docs;
        public float[][] vectors;

        public Pair(int[] docs, float[][] vectors) {
            this.docs = docs;
            this.vectors = vectors;
        }
    }
}

