/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.search.asynchronous.action.AsynchronousSearchStatsAction;
import org.opensearch.search.asynchronous.request.AsynchronousSearchStatsRequest;

public class RestAsynchronousSearchStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestAsynchronousSearchStatsAction.class);
    private static final String NAME = "asynchronous_search_stats_action";

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        AsynchronousSearchStatsRequest asynchronousSearchStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)AsynchronousSearchStatsAction.INSTANCE, (ActionRequest)asynchronousSearchStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_asynchronous_search/_nodes/{nodeId}/stats", RestRequest.Method.GET, "/_opendistro/_asynchronous_search/_nodes/{nodeId}/stats"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_asynchronous_search/stats", RestRequest.Method.GET, "/_opendistro/_asynchronous_search/stats"));
    }

    private AsynchronousSearchStatsRequest getRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        AsynchronousSearchStatsRequest asynchronousSearchStatsRequest = new AsynchronousSearchStatsRequest(nodesIds);
        asynchronousSearchStatsRequest.timeout(request.param("timeout"));
        return asynchronousSearchStatsRequest;
    }
}

