/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.opensearch.common.ParseField;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.NormalizingTokenFilterFactory;
import org.opensearch.index.analysis.TokenFilterFactory;

public class ASCIIFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    public static final ParseField PRESERVE_ORIGINAL = new ParseField("preserve_original", new String[0]);
    public static final boolean DEFAULT_PRESERVE_ORIGINAL = false;
    private final boolean preserveOriginal;

    public ASCIIFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIGINAL.getPreferredName(), Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        if (!this.preserveOriginal) {
            return this;
        }
        return new TokenFilterFactory(){

            public String name() {
                return ASCIIFoldingTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ASCIIFoldingFilter(tokenStream, false);
            }
        };
    }

    public TokenStream normalize(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, false);
    }
}

