/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.transform.TransformValidator;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformRequest;
import org.opensearch.indexmanagement.transform.action.index.IndexTransformResponse;
import org.opensearch.indexmanagement.transform.action.index.TransportIndexTransformAction;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001.BG\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00022\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n \u001b*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lorg/opensearch/indexmanagement/transform/action/index/TransportIndexTransformAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformRequest;", "Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexManagementIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/IndexManagementIndices;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getIndexManagementIndices", "()Lorg/opensearch/indexmanagement/IndexManagementIndices;", "getIndexNameExpressionResolver", "()Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "IndexTransformHandler", "opensearch-index-management"})
public final class TransportIndexTransformAction
extends HandledTransportAction<IndexTransformRequest, IndexTransformResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final IndexManagementIndices indexManagementIndices;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportIndexTransformAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull IndexManagementIndices indexManagementIndices, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexManagementIndices, (String)"indexManagementIndices");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/transform/index", transportService, actionFilters, IndexTransformRequest::new);
        this.client = client;
        this.indexManagementIndices = indexManagementIndices;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportIndexTransformAction._init_$lambda-0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final IndexManagementIndices getIndexManagementIndices() {
        return this.indexManagementIndices;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexTransformRequest request, @NotNull ActionListener<IndexTransformResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new IndexTransformHandler(this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda-0(TransportIndexTransformAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/indexmanagement/transform/action/index/TransportIndexTransformAction$IndexTransformHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformResponse;", "request", "Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/transform/action/index/TransportIndexTransformAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformRequest;Lorg/opensearch/commons/authuser/User;)V", "modifiedImmutableProperties", "", "", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "newTransform", "onConfigIndexAcknowledgedResponse", "", "response", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "onGetTransform", "Lorg/opensearch/action/get/GetResponse;", "putTransform", "start", "updateTransform", "validateAndPutTransform", "validateMappings", "indices", "Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "opensearch-index-management"})
    public final class IndexTransformHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexTransformResponse> actionListener;
        @NotNull
        private final IndexTransformRequest request;
        @Nullable
        private final User user;

        public IndexTransformHandler(@NotNull Client client, @NotNull ActionListener<IndexTransformResponse> actionListener, @Nullable IndexTransformRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportIndexTransformAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ IndexTransformHandler(Client client, ActionListener actionListener, IndexTransformRequest indexTransformRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class IndexTransformHand\u2026rn issues\n        }\n    }");
                user = SecurityUtils.Companion.buildUser(threadContext, indexTransformRequest.getTransform().getUser());
            }
            this(client, (ActionListener<IndexTransformResponse>)actionListener, indexTransformRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            TransportIndexTransformAction.this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportIndexTransformAction transportIndexTransformAction = TransportIndexTransformAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportIndexTransformAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                IndexManagementIndices indexManagementIndices = transportIndexTransformAction.getIndexManagementIndices();
                bl2 = ActionListener.wrap(this::onConfigIndexAcknowledgedResponse, arg_0 -> this.actionListener.onFailure(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"wrap(::onConfigIndexAckn\u2026ctionListener::onFailure)");
                indexManagementIndices.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)bl2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onConfigIndexAcknowledgedResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexTransformAction.this.log.info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                if (this.request.opType() == DocWriteRequest.OpType.CREATE) {
                    this.validateAndPutTransform();
                } else {
                    this.updateTransform();
                }
            } else {
                String message = "Unable to create or update .opendistro-ism-config with newest mappings.";
                TransportIndexTransformAction.this.log.error(message);
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void updateTransform() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getTransform().getId());
            this.client.get(getRequest, ActionListener.wrap(this::onGetTransform, arg_0 -> this.actionListener.onFailure(arg_0)));
        }

        private final void onGetTransform(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Transform transform2 = null;
            try {
                transform2 = (Transform)OpenSearchExtensionsKt.parseFromGetResponse(response2, TransportIndexTransformAction.this.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

                    @NotNull
                    public final Transform invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            User user = transform2.getUser();
            Boolean e = TransportIndexTransformAction.this.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, e, "transform", transform2.getId(), this.actionListener)) {
                return;
            }
            List<String> modified = this.modifiedImmutableProperties(transform2, this.request.getTransform());
            if (!((Collection)modified).isEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Not allowed to modify " + modified, RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            this.putTransform();
        }

        private final List<String> modifiedImmutableProperties(Transform transform2, Transform newTransform) {
            List modified = new ArrayList();
            if (!Intrinsics.areEqual((Object)transform2.getSourceIndex(), (Object)newTransform.getSourceIndex())) {
                modified.add("source_index");
            }
            if (!Intrinsics.areEqual((Object)transform2.getTargetIndex(), (Object)newTransform.getTargetIndex())) {
                modified.add("target_index");
            }
            if (!Intrinsics.areEqual((Object)transform2.getDataSelectionQuery(), (Object)newTransform.getDataSelectionQuery())) {
                modified.add("data_selection_query");
            }
            if (!Intrinsics.areEqual(transform2.getGroups(), newTransform.getGroups())) {
                modified.add("groups");
            }
            if (!Intrinsics.areEqual((Object)transform2.getAggregations(), (Object)newTransform.getAggregations())) {
                modified.add("aggregations");
            }
            if (transform2.getContinuous() != newTransform.getContinuous()) {
                modified.add("continuous");
            }
            return CollectionsKt.toList((Iterable)modified);
        }

        private final void putTransform() {
            Transform transform2 = Transform.copy$default(this.request.getTransform(), null, 0L, 0L, IndexUtils.Companion.getIndexManagementConfigSchemaVersion(), null, null, null, false, null, null, null, null, null, null, 0, null, null, false, this.user, 262135, null);
            IndexRequest indexRequest = ((IndexRequest)this.request.index(".opendistro-ism-config")).id(this.request.getTransform().getId());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            XContentBuilder xContentBuilder2 = xContentBuilder;
            xContentBuilder = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"EMPTY_PARAMS");
            indexRequest.source(transform2.toXContent(xContentBuilder2, (ToXContent.Params)xContentBuilder)).timeout(IndexRequest.DEFAULT_TIMEOUT);
            this.client.index((IndexRequest)this.request, (ActionListener)new ActionListener<IndexResponse>(this, transform2){
                final /* synthetic */ IndexTransformHandler this$0;
                final /* synthetic */ Transform $transform;
                {
                    this.this$0 = $receiver;
                    this.$transform = $transform;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (response2.getShardInfo().getFailed() > 0) {
                        ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                        String failureReasons2 = ArraysKt.joinToString$default((Object[])failureArray, (CharSequence)",", null, null, (int)0, null, (Function1)putTransform.onResponse.failureReasons.1.INSTANCE, (int)30, null);
                        IndexTransformHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)new OpenSearchStatusException(failureReasons2, response2.status(), new Object[0])));
                    } else {
                        RestStatus status = IndexTransformHandler.access$getRequest$p(this.this$0).opType() == DocWriteRequest.OpType.CREATE ? RestStatus.CREATED : RestStatus.OK;
                        ActionListener actionListener = IndexTransformHandler.access$getActionListener$p(this.this$0);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                        actionListener.onResponse((Object)((Object)new IndexTransformResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), status, Transform.copy$default(this.$transform, null, response2.getSeqNo(), response2.getPrimaryTerm(), 0L, null, null, null, false, null, null, null, null, null, null, 0, null, null, false, null, 524281, null))));
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexTransformHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final void validateAndPutTransform() {
            String[] stringArray = new String[]{this.request.getTransform().getSourceIndex()};
            String[] concreteIndices = TransportIndexTransformAction.this.getIndexNameExpressionResolver().concreteIndexNames(TransportIndexTransformAction.this.getClusterService().state(), IndicesOptions.lenientExpand(), true, stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)concreteIndices, (String)"concreteIndices");
            if (concreteIndices.length == 0) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("No specified source index exist in the cluster", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            GetMappingsRequest mappingRequest = (GetMappingsRequest)new GetMappingsRequest().indices(Arrays.copyOf(concreteIndices, concreteIndices.length));
            this.client.execute((ActionType)GetMappingsAction.INSTANCE, (ActionRequest)mappingRequest, (ActionListener)new ActionListener<GetMappingsResponse>(this, concreteIndices){
                final /* synthetic */ IndexTransformHandler this$0;
                final /* synthetic */ String[] $concreteIndices;
                {
                    this.this$0 = $receiver;
                    this.$concreteIndices = $concreteIndices;
                }

                public void onResponse(@NotNull GetMappingsResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String[] stringArray = this.$concreteIndices;
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"concreteIndices");
                    List issues = IndexTransformHandler.access$validateMappings(this.this$0, ArraysKt.toList((Object[])stringArray), response2, IndexTransformHandler.access$getRequest$p(this.this$0).getTransform());
                    if (!((Collection)issues).isEmpty()) {
                        String errorMessage = CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        IndexTransformHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0])));
                        return;
                    }
                    IndexTransformHandler.access$putTransform(this.this$0);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexTransformHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final List<String> validateMappings(List<String> indices, GetMappingsResponse response2, Transform transform2) {
            List issues = new ArrayList();
            Iterable $this$forEach$iv = indices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String index2 = (String)element$iv;
                boolean bl = false;
                issues.addAll((Collection)TransformValidator.Companion.validateMappingsResponse(index2, response2, transform2));
            }
            return issues;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexTransformHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ IndexTransformRequest access$getRequest$p(IndexTransformHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ List access$validateMappings(IndexTransformHandler $this, List indices, GetMappingsResponse response2, Transform transform2) {
            return $this.validateMappings(indices, response2, transform2);
        }

        public static final /* synthetic */ void access$putTransform(IndexTransformHandler $this) {
            $this.putTransform();
        }
    }
}

