/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.DeleteCollectionRequest;
import org.apache.solr.cluster.placement.DeleteReplicasRequest;
import org.apache.solr.cluster.placement.DeleteShardsRequest;
import org.apache.solr.cluster.placement.ModificationRequest;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementModificationException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlanFactory;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.ReplicaPlacement;
import org.apache.solr.cluster.placement.impl.NodeMetricImpl;
import org.apache.solr.cluster.placement.plugins.AffinityPlacementConfig;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityPlacementFactory
implements PlacementPluginFactory<AffinityPlacementConfig> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AffinityPlacementConfig config = AffinityPlacementConfig.DEFAULT;

    @Override
    public PlacementPlugin createPluginInstance() {
        return new AffinityPlacementPlugin(this.config.minimalFreeDiskGB, this.config.prioritizedFreeDiskGB, this.config.withCollection, this.config.collectionNodeType);
    }

    @Override
    public void configure(AffinityPlacementConfig cfg) {
        Objects.requireNonNull(cfg, "configuration must never be null");
        this.config = cfg;
    }

    @Override
    public AffinityPlacementConfig getConfig() {
        return this.config;
    }

    static class AffinityPlacementPlugin
    implements PlacementPlugin {
        private final long minimalFreeDiskGB;
        private final long prioritizedFreeDiskGB;
        private final Map<String, String> withCollections;
        private final Map<String, Set<String>> colocatedWith;
        private final Map<String, Set<String>> nodeTypes;
        private final Random replicaPlacementRandom = new Random();

        private AffinityPlacementPlugin(long minimalFreeDiskGB, long prioritizedFreeDiskGB, Map<String, String> withCollections, Map<String, String> collectionNodeTypes) {
            this.minimalFreeDiskGB = minimalFreeDiskGB;
            this.prioritizedFreeDiskGB = prioritizedFreeDiskGB;
            Objects.requireNonNull(withCollections, "withCollections must not be null");
            Objects.requireNonNull(collectionNodeTypes, "collectionNodeTypes must not be null");
            this.withCollections = withCollections;
            if (withCollections.isEmpty()) {
                this.colocatedWith = Map.of();
            } else {
                this.colocatedWith = new HashMap<String, Set<String>>();
                withCollections.forEach((primary, secondary) -> this.colocatedWith.computeIfAbsent((String)secondary, s -> new HashSet()).add(primary));
            }
            if (collectionNodeTypes.isEmpty()) {
                this.nodeTypes = Map.of();
            } else {
                this.nodeTypes = new HashMap<String, Set<String>>();
                collectionNodeTypes.forEach((coll, typesString) -> {
                    List types = StrUtils.splitSmart((String)typesString, (char)',', (boolean)true);
                    if (!types.isEmpty()) {
                        this.nodeTypes.put((String)coll, new HashSet(types));
                    }
                });
            }
            String seed = System.getProperty("tests.seed");
            if (seed != null) {
                this.replicaPlacementRandom.setSeed(seed.hashCode());
            }
        }

        @Override
        @SuppressForbidden(reason="Ordering.arbitrary() has no equivalent in Comparator class. Rather reuse than copy.")
        public List<PlacementPlan> computePlacements(Collection<PlacementRequest> requests, PlacementContext placementContext) throws PlacementException {
            ArrayList<PlacementPlan> placementPlans = new ArrayList<PlacementPlan>(requests.size());
            HashSet<Node> allNodes = new HashSet<Node>();
            for (PlacementRequest request : requests) {
                allNodes.addAll(request.getTargetNodes());
            }
            AttributeFetcher attributeFetcher = placementContext.getAttributeFetcher();
            attributeFetcher.requestNodeSystemProperty("availability_zone").requestNodeSystemProperty("node_type").requestNodeSystemProperty("replica_type");
            attributeFetcher.requestNodeMetric(NodeMetricImpl.NUM_CORES).requestNodeMetric(NodeMetricImpl.FREE_DISK_GB);
            attributeFetcher.fetchFrom(allNodes);
            AttributeValues attrValues = attributeFetcher.fetchAttributes();
            Map<Node, Integer> allCoresOnNodes = this.getCoreCountPerNode(allNodes, attrValues);
            HashMap<String, Map> allNodesWithReplicas = new HashMap<String, Map>();
            for (PlacementRequest request : requests) {
                Set<Node> nodes = request.getTargetNodes();
                SolrCollection solrCollection = request.getCollection();
                nodes = this.filterNodesWithCollection(placementContext.getCluster(), request, attrValues, nodes);
                nodes = this.filterNodesByNodeType(placementContext.getCluster(), request, attrValues, nodes);
                EnumMap<Replica.ReplicaType, Set<Node>> replicaTypeToNodes = this.getAvailableNodesForReplicaTypes(nodes, attrValues);
                Set<String> availabilityZones = this.getZonesFromNodes(nodes, attrValues);
                HashSet<ReplicaPlacement> replicaPlacements = new HashSet<ReplicaPlacement>();
                for (String shardName : request.getShardNames()) {
                    Set nodesWithReplicas = allNodesWithReplicas.computeIfAbsent(solrCollection.getName(), col -> new HashMap()).computeIfAbsent(shardName, s -> {
                        HashSet<Node> newNodeSet = new HashSet<Node>();
                        Shard shard = solrCollection.getShard((String)s);
                        if (shard != null) {
                            for (Replica r : shard.replicas()) {
                                newNodeSet.add(r.getNode());
                            }
                        }
                        return newNodeSet;
                    });
                    for (Replica.ReplicaType replicaType : Replica.ReplicaType.values()) {
                        this.makePlacementDecisions(solrCollection, shardName, availabilityZones, replicaType, request.getCountReplicasToCreate(replicaType), attrValues, replicaTypeToNodes, nodesWithReplicas, allCoresOnNodes, placementContext.getPlacementPlanFactory(), replicaPlacements);
                    }
                }
                placementPlans.add(placementContext.getPlacementPlanFactory().createPlacementPlan(request, replicaPlacements));
            }
            return placementPlans;
        }

        @Override
        public void verifyAllowedModification(ModificationRequest modificationRequest, PlacementContext placementContext) throws PlacementModificationException, InterruptedException {
            if (modificationRequest instanceof DeleteShardsRequest) {
                log.warn("DeleteShardsRequest not implemented yet, skipping: {}", (Object)modificationRequest);
            } else if (modificationRequest instanceof DeleteCollectionRequest) {
                this.verifyDeleteCollection((DeleteCollectionRequest)modificationRequest, placementContext);
            } else if (modificationRequest instanceof DeleteReplicasRequest) {
                this.verifyDeleteReplicas((DeleteReplicasRequest)modificationRequest, placementContext);
            } else {
                log.warn("unsupported request type, skipping: {}", (Object)modificationRequest);
            }
        }

        private void verifyDeleteCollection(DeleteCollectionRequest deleteCollectionRequest, PlacementContext placementContext) throws PlacementModificationException, InterruptedException {
            Cluster cluster = placementContext.getCluster();
            Set colocatedCollections = this.colocatedWith.getOrDefault(deleteCollectionRequest.getCollection().getName(), Set.of());
            for (String primaryName : colocatedCollections) {
                try {
                    if (cluster.getCollection(primaryName) == null) continue;
                    throw new PlacementModificationException("colocated collection " + primaryName + " of " + deleteCollectionRequest.getCollection().getName() + " still present");
                }
                catch (IOException e) {
                    throw new PlacementModificationException("failed to retrieve colocated collection information", e);
                }
            }
        }

        private void verifyDeleteReplicas(DeleteReplicasRequest deleteReplicasRequest, PlacementContext placementContext) throws PlacementModificationException, InterruptedException {
            Cluster cluster = placementContext.getCluster();
            SolrCollection secondaryCollection = deleteReplicasRequest.getCollection();
            Set<String> colocatedCollections = this.colocatedWith.get(secondaryCollection.getName());
            if (colocatedCollections == null) {
                return;
            }
            HashMap secondaryNodeShardReplicas = new HashMap();
            secondaryCollection.shards().forEach(shard -> shard.replicas().forEach(replica -> secondaryNodeShardReplicas.computeIfAbsent(replica.getNode(), n -> new HashMap()).computeIfAbsent(replica.getShard().getShardName(), s -> new AtomicInteger()).incrementAndGet()));
            HashMap colocatingNodes = new HashMap();
            try {
                for (String colocatedCollection : colocatedCollections) {
                    SolrCollection coll = cluster.getCollection(colocatedCollection);
                    coll.shards().forEach(shard -> shard.replicas().forEach(replica -> colocatingNodes.computeIfAbsent(replica.getNode(), n -> new HashSet()).add(coll.getName())));
                }
            }
            catch (IOException ioe) {
                throw new PlacementModificationException("failed to retrieve colocated collection information", ioe);
            }
            PlacementModificationException exception = null;
            for (Replica replica : deleteReplicasRequest.getReplicas()) {
                if (!colocatingNodes.containsKey(replica.getNode())) continue;
                AtomicInteger secondaryCount = secondaryNodeShardReplicas.getOrDefault(replica.getNode(), Map.of()).getOrDefault(replica.getShard().getShardName(), new AtomicInteger());
                if (secondaryCount.get() > 1) {
                    secondaryCount.decrementAndGet();
                    continue;
                }
                if (exception == null) {
                    exception = new PlacementModificationException("delete replica(s) rejected");
                }
                exception.addRejectedModification(replica.toString(), "co-located with replicas of " + colocatingNodes.get(replica.getNode()));
            }
            if (exception != null) {
                throw exception;
            }
        }

        private Set<String> getZonesFromNodes(Set<Node> nodes, AttributeValues attrValues) {
            HashSet<String> azs = new HashSet<String>();
            for (Node n : nodes) {
                azs.add(this.getNodeAZ(n, attrValues));
            }
            return Collections.unmodifiableSet(azs);
        }

        private String getNodeAZ(Node n, AttributeValues attrValues) {
            Optional<String> nodeAz = attrValues.getSystemProperty(n, "availability_zone");
            return nodeAz.orElse("uNd3f1NeD");
        }

        private Map<Node, Integer> getCoreCountPerNode(Set<Node> nodes, AttributeValues attrValues) {
            HashMap<Node, Integer> coresOnNodes = new HashMap<Node, Integer>();
            for (Node node : nodes) {
                attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).ifPresent(count -> coresOnNodes.put(node, (Integer)count));
            }
            return coresOnNodes;
        }

        private EnumMap<Replica.ReplicaType, Set<Node>> getAvailableNodesForReplicaTypes(Set<Node> nodes, AttributeValues attrValues) {
            EnumMap<Replica.ReplicaType, Set<Node>> replicaTypeToNodes = new EnumMap<Replica.ReplicaType, Set<Node>>(Replica.ReplicaType.class);
            for (Replica.ReplicaType replicaType : Replica.ReplicaType.values()) {
                replicaTypeToNodes.put(replicaType, new HashSet());
            }
            for (Node node : nodes) {
                String supportedReplicaTypes;
                if (attrValues.getNodeMetric(node, NodeMetricImpl.FREE_DISK_GB).isEmpty()) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Unknown free disk on node {}, excluding it from placement decisions.", (Object)node.getName());
                    continue;
                }
                if (attrValues.getNodeMetric(node, NodeMetricImpl.FREE_DISK_GB).get() < (double)this.minimalFreeDiskGB) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Node {} free disk ({}GB) lower than configured minimum {}GB, excluding it from placement decisions.", new Object[]{node.getName(), attrValues.getNodeMetric(node, NodeMetricImpl.FREE_DISK_GB).get(), this.minimalFreeDiskGB});
                    continue;
                }
                if (attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).isEmpty()) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Unknown number of cores on node {}, excluding it from placement decisions.", (Object)node.getName());
                    continue;
                }
                String string = supportedReplicaTypes = attrValues.getSystemProperty(node, "replica_type").isPresent() ? attrValues.getSystemProperty(node, "replica_type").get() : null;
                if (supportedReplicaTypes == null || supportedReplicaTypes.isBlank()) {
                    for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                        replicaTypeToNodes.get((Object)rt).add(node);
                    }
                    continue;
                }
                Set set = Arrays.stream(supportedReplicaTypes.split(",")).map(String::trim).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
                for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                    if (!set.contains(rt.name().toLowerCase(Locale.ROOT))) continue;
                    replicaTypeToNodes.get((Object)rt).add(node);
                }
            }
            return replicaTypeToNodes;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressForbidden(reason="Ordering.arbitrary() has no equivalent in Comparator class. Rather reuse than copy.")
        private void makePlacementDecisions(SolrCollection solrCollection, String shardName, Set<String> availabilityZones, Replica.ReplicaType replicaType, int numReplicas, AttributeValues attrValues, EnumMap<Replica.ReplicaType, Set<Node>> replicaTypeToNodes, Set<Node> nodesWithReplicas, Map<Node, Integer> coresOnNodes, PlacementPlanFactory placementPlanFactory, Set<ReplicaPlacement> replicaPlacements) throws PlacementException {
            void var18_24;
            HashMap<String, Integer> azToNumReplicas = new HashMap<String, Integer>();
            for (String az : availabilityZones) {
                azToNumReplicas.put(az, 0);
            }
            HashSet candidateNodes = new HashSet(replicaTypeToNodes.get((Object)replicaType));
            candidateNodes.removeAll(nodesWithReplicas);
            Shard shard = solrCollection.getShard(shardName);
            if (shard != null) {
                for (Replica replica : shard.replicas()) {
                    String az;
                    if (replica.getType() != replicaType || !azToNumReplicas.containsKey(az = this.getNodeAZ(replica.getNode(), attrValues))) continue;
                    azToNumReplicas.put(az, (Integer)azToNumReplicas.get(az) + 1);
                }
            }
            HashMap<String, List> nodesPerAz = new HashMap<String, List>();
            for (Object node : candidateNodes) {
                String string = this.getNodeAZ((Node)node, attrValues);
                List nodesForAz = nodesPerAz.computeIfAbsent(string, k -> new ArrayList());
                nodesForAz.add(node);
            }
            TreeMultimap treeMultimap = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)Ordering.arbitrary());
            for (Map.Entry entry : nodesPerAz.entrySet()) {
                treeMultimap.put((Object)((Integer)azToNumReplicas.get(entry.getKey())), (Object)new AzWithNodes((String)entry.getKey(), (List)entry.getValue()));
            }
            CoresAndDiskComparator coresAndDiskComparator = new CoresAndDiskComparator(attrValues, coresOnNodes, this.prioritizedFreeDiskGB);
            boolean bl = false;
            while (var18_24 < numReplicas) {
                int minNumberOfReplicasPerAz = 0;
                HashSet<Map.Entry> candidateAzEntries = null;
                Iterator it = treeMultimap.entries().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    int numberOfNodes = ((AzWithNodes)entry.getValue()).availableNodesForPlacement.size();
                    if (numberOfNodes == 0) {
                        it.remove();
                        continue;
                    }
                    if (candidateAzEntries == null) {
                        minNumberOfReplicasPerAz = numberOfNodes;
                        candidateAzEntries = new HashSet<Map.Entry>();
                    }
                    if (minNumberOfReplicasPerAz != numberOfNodes) break;
                    candidateAzEntries.add(entry);
                    it.remove();
                }
                if (candidateAzEntries == null) {
                    throw new PlacementException("Not enough eligible nodes to place " + numReplicas + " replica(s) of type " + replicaType + " for shard " + shardName + " of collection " + solrCollection.getName());
                }
                Map.Entry selectedAz = null;
                Node selectedAzBestNode = null;
                for (Map.Entry candidateAzEntry : candidateAzEntries) {
                    AzWithNodes azWithNodes = (AzWithNodes)candidateAzEntry.getValue();
                    List<Node> nodes = azWithNodes.availableNodesForPlacement;
                    if (!azWithNodes.hasBeenSorted) {
                        Collections.shuffle(nodes, this.replicaPlacementRandom);
                        nodes.sort(coresAndDiskComparator);
                        azWithNodes.hasBeenSorted = true;
                    }
                    if (selectedAz != null && coresAndDiskComparator.compare(nodes.get(0), selectedAzBestNode) >= 0) continue;
                    selectedAz = candidateAzEntry;
                    selectedAzBestNode = nodes.get(0);
                }
                AzWithNodes azWithNodes = (AzWithNodes)selectedAz.getValue();
                List<Node> nodes = ((AzWithNodes)selectedAz.getValue()).availableNodesForPlacement;
                Node assignTarget = nodes.remove(0);
                for (Map.Entry removedAzs : candidateAzEntries) {
                    if (removedAzs == selectedAz) continue;
                    treeMultimap.put((Object)((Integer)removedAzs.getKey()), (Object)((AzWithNodes)removedAzs.getValue()));
                }
                treeMultimap.put((Object)((Integer)selectedAz.getKey() + 1), (Object)azWithNodes);
                nodesWithReplicas.add(assignTarget);
                coresOnNodes.merge(assignTarget, 1, Integer::sum);
                replicaPlacements.add(placementPlanFactory.createReplicaPlacement(solrCollection, shardName, assignTarget, replicaType));
                ++var18_24;
            }
        }

        private Set<Node> filterNodesWithCollection(Cluster cluster, PlacementRequest request, AttributeValues attributeValues, Set<Node> initialNodes) throws PlacementException {
            SolrCollection withCollection;
            String withCollectionName = this.withCollections.get(request.getCollection().getName());
            if (withCollectionName == null) {
                return initialNodes;
            }
            try {
                withCollection = cluster.getCollection(withCollectionName);
            }
            catch (Exception e) {
                throw new PlacementException("Error getting info of withCollection=" + withCollectionName, e);
            }
            HashSet withCollectionNodes = new HashSet();
            withCollection.shards().forEach(s -> s.replicas().forEach(r -> withCollectionNodes.add(r.getNode())));
            if (withCollectionNodes.isEmpty()) {
                throw new PlacementException("Collection " + withCollection + " defined in `withCollection` has no replicas on eligible nodes.");
            }
            HashSet<Node> filteredNodes = new HashSet<Node>(initialNodes);
            filteredNodes.retainAll(withCollectionNodes);
            if (filteredNodes.isEmpty()) {
                throw new PlacementException("Collection " + withCollection + " defined in `withCollection` has no replicas on eligible nodes.");
            }
            return filteredNodes;
        }

        private Set<Node> filterNodesByNodeType(Cluster cluster, PlacementRequest request, AttributeValues attributeValues, Set<Node> initialNodes) throws PlacementException {
            Set<String> collNodeTypes = this.nodeTypes.get(request.getCollection().getName());
            if (collNodeTypes == null) {
                return initialNodes;
            }
            Set<Node> filteredNodes = initialNodes.stream().filter(n -> {
                Optional<String> nodePropOpt = attributeValues.getSystemProperty((Node)n, "node_type");
                if (!nodePropOpt.isPresent()) {
                    return false;
                }
                HashSet nodeTypes = new HashSet(StrUtils.splitSmart((String)nodePropOpt.get(), (char)','));
                nodeTypes.retainAll(collNodeTypes);
                return !nodeTypes.isEmpty();
            }).collect(Collectors.toSet());
            if (filteredNodes.isEmpty()) {
                throw new PlacementException("There are no nodes with types: " + collNodeTypes + " expected by collection " + request.getCollection().getName());
            }
            return filteredNodes;
        }

        static class CoresAndDiskComparator
        implements Comparator<Node> {
            private final AttributeValues attrValues;
            private final Map<Node, Integer> coresOnNodes;
            private final long prioritizedFreeDiskGB;

            CoresAndDiskComparator(AttributeValues attrValues, Map<Node, Integer> coresOnNodes, long prioritizedFreeDiskGB) {
                this.attrValues = attrValues;
                this.coresOnNodes = coresOnNodes;
                this.prioritizedFreeDiskGB = prioritizedFreeDiskGB;
            }

            @Override
            public int compare(Node a, Node b) {
                boolean bHasLowFreeSpace;
                boolean aHasLowFreeSpace = this.attrValues.getNodeMetric(a, NodeMetricImpl.FREE_DISK_GB).get() < (double)this.prioritizedFreeDiskGB;
                boolean bl = bHasLowFreeSpace = this.attrValues.getNodeMetric(b, NodeMetricImpl.FREE_DISK_GB).get() < (double)this.prioritizedFreeDiskGB;
                if (aHasLowFreeSpace != bHasLowFreeSpace) {
                    return Boolean.compare(aHasLowFreeSpace, bHasLowFreeSpace);
                }
                return Integer.compare(this.coresOnNodes.get(a), this.coresOnNodes.get(b));
            }
        }

        private static class AzWithNodes {
            final String azName;
            List<Node> availableNodesForPlacement;
            boolean hasBeenSorted;

            AzWithNodes(String azName, List<Node> availableNodesForPlacement) {
                this.azName = azName;
                this.availableNodesForPlacement = availableNodesForPlacement;
                this.hasBeenSorted = false;
            }
        }
    }
}

