/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HUSLColorConverter;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0006\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/github/ajalt/colormath/model/HPLuv;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "p", "l", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFFF)V", "getAlpha", "()F", "getH", "getL", "getP", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toHPLuv", "toLCHuv", "Lcom/github/ajalt/colormath/model/LCHuv;", "toLUV", "Lcom/github/ajalt/colormath/model/LUV;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
public final class HPLuv
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float h;
    private final float p;
    private final float l;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("HPL");

    public HPLuv(float h, float p, float l, float alpha) {
        this.h = h;
        this.p = p;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ HPLuv(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getH() {
        return this.h;
    }

    public final float getP() {
        return this.p;
    }

    public final float getL() {
        return this.l;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public HPLuv(@NotNull Number h, @NotNull Number p, @NotNull Number l, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(h.floatValue(), p.floatValue(), l.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ HPLuv(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<HPLuv> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        if ((double)this.l > 99.9999) {
            return LCHuv.Companion.invoke(100.0f, 0.0f, this.getH(), this.getAlpha());
        }
        if ((double)this.l < 1.0E-5) {
            return LCHuv.Companion.invoke(0.0f, 0.0f, this.getH(), this.getAlpha());
        }
        double max = HUSLColorConverter.INSTANCE.maxSafeChromaForL(this.l);
        double c = max / (double)100 * (double)this.p;
        return LCHuv.Companion.invoke(this.l, (float)c, this.getH(), this.getAlpha());
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return this.toLCHuv().toLUV();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toLCHuv().toXYZ();
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.getH(), this.p, this.l, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return HueColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return HueColor.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return HueColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return HueColor.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return HueColor.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    public final float component1() {
        return this.getH();
    }

    public final float component2() {
        return this.p;
    }

    public final float component3() {
        return this.l;
    }

    public final float component4() {
        return this.getAlpha();
    }

    @NotNull
    public final HPLuv copy(float h, float p, float l, float alpha) {
        return new HPLuv(h, p, l, alpha);
    }

    public static /* synthetic */ HPLuv copy$default(HPLuv hPLuv, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hPLuv.getH();
        }
        if ((n & 2) != 0) {
            f2 = hPLuv.p;
        }
        if ((n & 4) != 0) {
            f3 = hPLuv.l;
        }
        if ((n & 8) != 0) {
            f4 = hPLuv.getAlpha();
        }
        return hPLuv.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HPLuv(h=" + this.getH() + ", p=" + this.p + ", l=" + this.l + ", alpha=" + this.getAlpha() + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.getH());
        result = result * 31 + Float.hashCode(this.p);
        result = result * 31 + Float.hashCode(this.l);
        result = result * 31 + Float.hashCode(this.getAlpha());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HPLuv)) {
            return false;
        }
        HPLuv hPLuv = (HPLuv)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getH()), (Object)Float.valueOf(hPLuv.getH()))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.p), (Object)Float.valueOf(hPLuv.p))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.l), (Object)Float.valueOf(hPLuv.l))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.getAlpha()), (Object)Float.valueOf(hPLuv.getAlpha()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/HPLuv$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/HPLuv;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    public static final class Companion
    implements ColorSpace<HPLuv> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "HPLuv";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public HPLuv convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toHPLuv();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HPLuv create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            n = n <= n2 ? (n2 <= size$iv$iv ? 1 : 0) : 0;
            n2 = 0;
            boolean bl = false;
            if (n == 0) {
                boolean bl2 = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl3 = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            float[] fArray = components;
            int n3 = 3;
            boolean bl4 = false;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl5 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl6 = false;
            return (HPLuv)((Color)new HPLuv(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

