# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the eos_bgp_global module
"""


class Bgp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the eos_bgp_global module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "running_config": {"type": "str"},
        "state": {
            "default": "merged",
            "type": "str",
            "choices": [
                "deleted",
                "purged",
                "merged",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
        },
        "config": {
            "type": "dict",
            "options": {
                "router_id": {"type": "str"},
                "as_number": {"type": "str"},
                "redistribute": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "ospf_route": {
                            "type": "str",
                            "choices": [
                                "internal",
                                "external",
                                "nssa_external_1",
                                "nssa_external_2",
                            ],
                        },
                        "route_map": {"type": "str"},
                        "protocol": {
                            "type": "str",
                            "choices": [
                                "isis",
                                "ospfv3",
                                "ospf",
                                "attached-host",
                                "connected",
                                "rip",
                                "static",
                            ],
                        },
                        "isis_level": {
                            "type": "str",
                            "choices": ["level-1", "level-2", "level-1-2"],
                        },
                    },
                },
                "monitoring": {
                    "type": "dict",
                    "options": {
                        "received": {
                            "type": "str",
                            "choices": ["post_policy", "pre_policy"],
                        },
                        "station": {"type": "str"},
                        "port": {"type": "int"},
                        "timestamp": {
                            "type": "str",
                            "choices": ["none", "send_time"],
                        },
                    },
                },
                "default_metric": {"type": "int"},
                "bgp_params": {
                    "type": "dict",
                    "options": {
                        "labeled_unicast": {
                            "type": "str",
                            "choices": ["ip", "tunnel"],
                        },
                        "host_routes": {"type": "bool"},
                        "transport": {"type": "int"},
                        "next_hop_unchanged": {"type": "bool"},
                        "missing_policy": {
                            "type": "dict",
                            "options": {
                                "action": {
                                    "type": "str",
                                    "choices": [
                                        "deny",
                                        "permit",
                                        "deny-in-out",
                                    ],
                                },
                                "direction": {
                                    "type": "str",
                                    "choices": ["in", "out"],
                                },
                            },
                        },
                        "monitoring": {"type": "bool"},
                        "allowas_in": {
                            "type": "dict",
                            "options": {
                                "count": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                        },
                        "additional_paths": {
                            "type": "str",
                            "choices": ["install", "send", "receive"],
                        },
                        "advertise_inactive": {"type": "bool"},
                        "listen": {
                            "type": "dict",
                            "options": {
                                "range": {
                                    "type": "dict",
                                    "options": {
                                        "peer_group": {
                                            "type": "dict",
                                            "options": {
                                                "peer_filter": {"type": "str"},
                                                "remote_as": {"type": "str"},
                                                "name": {"type": "str"},
                                            },
                                        },
                                        "address": {"type": "str"},
                                    },
                                },
                                "limit": {"type": "int"},
                            },
                        },
                        "route_reflector": {
                            "type": "dict",
                            "options": {
                                "preserve": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "always_compare_med": {"type": "bool"},
                        "client_to_client": {"type": "bool"},
                        "bestpath": {
                            "type": "dict",
                            "options": {
                                "ecmp_fast": {"type": "bool"},
                                "tie_break": {
                                    "type": "str",
                                    "choices": [
                                        "cluster_list_length",
                                        "router_id",
                                    ],
                                },
                                "skip": {"type": "bool"},
                                "as_path": {
                                    "type": "str",
                                    "choices": ["ignore", "multipath_relax"],
                                },
                                "med": {
                                    "type": "dict",
                                    "options": {
                                        "confed": {"type": "bool"},
                                        "missing_as_worst": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "convergence": {
                            "type": "dict",
                            "options": {
                                "slow_peer": {"type": "bool"},
                                "time": {"type": "int"},
                            },
                        },
                        "log_neighbor_changes": {"type": "bool"},
                        "asn": {
                            "type": "str",
                            "choices": ["asdot", "asplain"],
                        },
                        "default": {
                            "type": "str",
                            "choices": ["ipv4_unicast", "ipv6_unicast"],
                        },
                        "route": {"type": "str"},
                        "enforce_first_as": {"type": "bool"},
                        "auto_local_addr": {"type": "bool"},
                        "redistribute_internal": {"type": "bool"},
                        "cluster_id": {"type": "str"},
                        "control_plane_filter": {"type": "bool"},
                        "confederation": {
                            "type": "dict",
                            "options": {
                                "peers": {"type": "str"},
                                "identifier": {"type": "str"},
                            },
                        },
                    },
                },
                "vlan": {"type": "int"},
                "update": {
                    "type": "dict",
                    "options": {
                        "wait_for": {
                            "type": "str",
                            "choices": [
                                "wait_for_convergence",
                                "wait_install",
                            ],
                        },
                        "batch_size": {"type": "int"},
                    },
                },
                "vlan_aware_bundle": {"type": "str"},
                "aggregate_address": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "advertise_only": {"type": "bool"},
                        "match_map": {"type": "str"},
                        "attribute_map": {"type": "str"},
                        "as_set": {"type": "bool"},
                        "summary_only": {"type": "bool"},
                        "address": {"type": "str"},
                    },
                },
                "neighbor": {
                    "elements": "dict",
                    "type": "list",
                    "aliases": ["neighbors"],
                    "options": {
                        "bfd": {"type": "str", "choices": ["c_bit", "enable"]},
                        "weight": {"type": "int"},
                        "default_originate": {
                            "type": "dict",
                            "options": {
                                "route_map": {"type": "str"},
                                "always": {"type": "bool"},
                            },
                        },
                        "next_hop_v6_address": {"type": "str"},
                        "route_reflector_client": {"type": "bool"},
                        "ttl": {"type": "int"},
                        "remove_private_as": {
                            "type": "dict",
                            "options": {
                                "all": {"type": "bool"},
                                "set": {"type": "bool"},
                                "replace_as": {"type": "bool"},
                            },
                        },
                        "local_v6_addr": {"type": "str"},
                        "transport": {
                            "type": "dict",
                            "options": {
                                "connection_mode": {"type": "str"},
                                "remote_port": {"type": "int"},
                            },
                        },
                        "next_hop_unchanged": {"type": "bool"},
                        "monitoring": {"type": "bool"},
                        "ebgp_multihop": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "ttl": {"type": "int"},
                            },
                        },
                        "shutdown": {"type": "bool"},
                        "fall_over": {"type": "bool"},
                        "idle_restart_timer": {"type": "int"},
                        "allowas_in": {
                            "type": "dict",
                            "options": {
                                "count": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                        },
                        "additional_paths": {
                            "type": "str",
                            "choices": ["send", "receive"],
                        },
                        "peer_group": {"type": "str"},
                        "out_delay": {"type": "int"},
                        "import_localpref": {"type": "int"},
                        "prefix_list": {
                            "type": "dict",
                            "options": {
                                "direction": {
                                    "type": "str",
                                    "choices": ["in", "out"],
                                },
                                "name": {"type": "str"},
                            },
                        },
                        "dont_capability_negotiate": {"type": "bool"},
                        "update_source": {"type": "str"},
                        "export_localpref": {"type": "int"},
                        "local_as": {
                            "type": "dict",
                            "options": {
                                "as_number": {"type": "str"},
                                "fallback": {"type": "bool"},
                            },
                        },
                        "maximum_received_routes": {
                            "type": "dict",
                            "options": {
                                "count": {"type": "int"},
                                "warning_limit": {
                                    "type": "dict",
                                    "options": {
                                        "limit_count": {"type": "int"},
                                        "limit_percent": {"type": "int"},
                                    },
                                },
                                "warning_only": {"type": "bool"},
                            },
                        },
                        "encryption_password": {
                            "type": "dict",
                            "no_log": True,
                            "options": {
                                "password": {"type": "str", "no_log": True},
                                "type": {"type": "int", "choices": [0, 7]},
                            },
                        },
                        "link_bandwidth": {
                            "type": "dict",
                            "options": {
                                "default": {"type": "str"},
                                "auto": {"type": "bool"},
                                "set": {"type": "bool"},
                                "update_delay": {"type": "int"},
                            },
                        },
                        "graceful_restart_helper": {"type": "bool"},
                        "neighbor_address": {
                            "type": "str",
                            "aliases": ["peer"],
                        },
                        "next_hop_self": {"type": "bool"},
                        "route_to_peer": {"type": "bool"},
                        "soft_recognition": {
                            "type": "str",
                            "choices": ["all", "None"],
                        },
                        "graceful_restart": {"type": "bool"},
                        "enforce_first_as": {"type": "bool"},
                        "send_community": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "community_attribute": {"type": "str"},
                                "sub_attribute": {
                                    "type": "str",
                                    "choices": [
                                        "extended",
                                        "link-bandwidth",
                                        "standard",
                                    ],
                                },
                                "speed": {"type": "str"},
                                "divide": {
                                    "type": "str",
                                    "choices": ["equal", "ratio"],
                                },
                                "link_bandwidth_attribute": {
                                    "type": "str",
                                    "choices": ["aggregate", "divide"],
                                },
                            },
                        },
                        "description": {"type": "str"},
                        "maximum_accepted_routes": {
                            "type": "dict",
                            "options": {
                                "count": {"type": "int"},
                                "warning_limit": {"type": "int"},
                            },
                        },
                        "auto_local_addr": {"type": "bool"},
                        "metric_out": {"type": "int"},
                        "timers": {
                            "type": "dict",
                            "options": {
                                "holdtime": {"type": "int"},
                                "keepalive": {"type": "int"},
                            },
                        },
                        "route_map": {
                            "type": "dict",
                            "options": {
                                "direction": {
                                    "type": "str",
                                    "choices": ["in", "out"],
                                },
                                "name": {"type": "str"},
                            },
                        },
                        "remote_as": {"type": "str"},
                    },
                },
                "graceful_restart": {
                    "type": "dict",
                    "options": {
                        "stalepath_time": {"type": "int"},
                        "restart_time": {"type": "int"},
                        "set": {"type": "bool"},
                    },
                },
                "timers": {
                    "type": "dict",
                    "options": {
                        "holdtime": {"type": "int"},
                        "keepalive": {"type": "int"},
                    },
                },
                "distance": {
                    "type": "dict",
                    "options": {
                        "internal": {"type": "int"},
                        "local": {"type": "int"},
                        "external": {"type": "int"},
                    },
                },
                "route_target": {
                    "type": "dict",
                    "options": {
                        "action": {
                            "type": "str",
                            "choices": ["both", "import", "export"],
                        },
                        "target": {"type": "str"},
                    },
                },
                "vrfs": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "access_group": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "direction": {"type": "str"},
                                "afi": {
                                    "type": "str",
                                    "choices": ["ipv4", "ipv6"],
                                },
                                "acl_name": {"type": "str"},
                            },
                        },
                        "router_id": {"type": "str"},
                        "vrf": {"type": "str"},
                        "route_target": {
                            "type": "dict",
                            "options": {
                                "action": {
                                    "type": "str",
                                    "choices": ["both", "import", "export"],
                                },
                                "type": {
                                    "type": "str",
                                    "choices": [
                                        "evpn",
                                        "vpn-ipv4",
                                        "vpn-ipv6",
                                    ],
                                },
                                "route_map": {"type": "str"},
                                "target": {"type": "str"},
                                "imported_route": {"type": "bool"},
                            },
                        },
                        "redistribute": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "ospf_route": {
                                    "type": "str",
                                    "choices": [
                                        "internal",
                                        "external",
                                        "nssa_external_1",
                                        "nssa_external_2",
                                    ],
                                },
                                "route_map": {"type": "str"},
                                "protocol": {
                                    "type": "str",
                                    "choices": [
                                        "isis",
                                        "ospfv3",
                                        "ospf",
                                        "attached-host",
                                        "connected",
                                        "rip",
                                        "static",
                                    ],
                                },
                                "isis_level": {
                                    "type": "str",
                                    "choices": [
                                        "level-1",
                                        "level-2",
                                        "level-1-2",
                                    ],
                                },
                            },
                        },
                        "distance": {
                            "type": "dict",
                            "options": {
                                "internal": {"type": "int"},
                                "local": {"type": "int"},
                                "external": {"type": "int"},
                            },
                        },
                        "default_metric": {"type": "int"},
                        "bgp_params": {
                            "type": "dict",
                            "options": {
                                "control_plane_filter": {"type": "bool"},
                                "convergence": {
                                    "type": "dict",
                                    "options": {
                                        "slow_peer": {"type": "bool"},
                                        "time": {"type": "int"},
                                    },
                                },
                                "host_routes": {"type": "bool"},
                                "transport": {"type": "int"},
                                "next_hop_unchanged": {"type": "bool"},
                                "missing_policy": {
                                    "type": "dict",
                                    "options": {
                                        "action": {
                                            "type": "str",
                                            "choices": [
                                                "deny",
                                                "permit",
                                                "deny-in-out",
                                            ],
                                        },
                                        "direction": {
                                            "type": "str",
                                            "choices": ["in", "out"],
                                        },
                                    },
                                },
                                "monitoring": {"type": "bool"},
                                "allowas_in": {
                                    "type": "dict",
                                    "options": {
                                        "count": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "additional_paths": {
                                    "type": "str",
                                    "choices": ["install", "send", "receive"],
                                },
                                "advertise_inactive": {"type": "bool"},
                                "listen": {
                                    "type": "dict",
                                    "options": {
                                        "range": {
                                            "type": "dict",
                                            "options": {
                                                "peer_group": {
                                                    "type": "dict",
                                                    "options": {
                                                        "peer_filter": {
                                                            "type": "str"
                                                        },
                                                        "remote_as": {
                                                            "type": "str"
                                                        },
                                                        "name": {
                                                            "type": "str"
                                                        },
                                                    },
                                                },
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "limit": {"type": "int"},
                                    },
                                },
                                "route_reflector": {
                                    "type": "dict",
                                    "options": {
                                        "preserve": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "always_compare_med": {"type": "bool"},
                                "client_to_client": {"type": "bool"},
                                "bestpath": {
                                    "type": "dict",
                                    "options": {
                                        "ecmp_fast": {"type": "bool"},
                                        "tie_break": {
                                            "type": "str",
                                            "choices": [
                                                "cluster_list_length",
                                                "router_id",
                                            ],
                                        },
                                        "skip": {"type": "bool"},
                                        "as_path": {
                                            "type": "str",
                                            "choices": [
                                                "ignore",
                                                "multipath_relax",
                                            ],
                                        },
                                        "med": {
                                            "type": "dict",
                                            "options": {
                                                "confed": {"type": "bool"},
                                                "missing_as_worst": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                    },
                                },
                                "labeled_unicast": {
                                    "type": "str",
                                    "choices": ["ip", "tunnel"],
                                },
                                "log_neighbor_changes": {"type": "bool"},
                                "asn": {
                                    "type": "str",
                                    "choices": ["asdot", "asplain"],
                                },
                                "default": {
                                    "type": "str",
                                    "choices": [
                                        "ipv4_unicast",
                                        "ipv6_unicast",
                                    ],
                                },
                                "route": {"type": "str"},
                                "enforce_first_as": {"type": "bool"},
                                "auto_local_addr": {"type": "bool"},
                                "redistribute_internal": {"type": "bool"},
                                "cluster_id": {"type": "str"},
                                "confederation": {
                                    "type": "dict",
                                    "options": {
                                        "peers": {"type": "str"},
                                        "identifier": {"type": "str"},
                                    },
                                },
                            },
                        },
                        "update": {
                            "type": "dict",
                            "options": {
                                "wait_for": {
                                    "type": "str",
                                    "choices": [
                                        "wait_for_convergence",
                                        "wait_install",
                                    ],
                                },
                                "batch_size": {"type": "int"},
                            },
                        },
                        "aggregate_address": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "advertise_only": {"type": "bool"},
                                "match_map": {"type": "str"},
                                "attribute_map": {"type": "str"},
                                "as_set": {"type": "bool"},
                                "summary_only": {"type": "bool"},
                                "address": {"type": "str"},
                            },
                        },
                        "neighbor": {
                            "elements": "dict",
                            "aliases": ["neighbors"],
                            "type": "list",
                            "options": {
                                "bfd": {
                                    "type": "str",
                                    "choices": ["c_bit", "enable"],
                                },
                                "weight": {"type": "int"},
                                "default_originate": {
                                    "type": "dict",
                                    "options": {
                                        "route_map": {"type": "str"},
                                        "always": {"type": "bool"},
                                    },
                                },
                                "next_hop_v6_address": {"type": "str"},
                                "route_reflector_client": {"type": "bool"},
                                "ttl": {"type": "int"},
                                "remove_private_as": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "replace_as": {"type": "bool"},
                                    },
                                },
                                "local_v6_addr": {"type": "str"},
                                "transport": {
                                    "type": "dict",
                                    "options": {
                                        "connection_mode": {"type": "str"},
                                        "remote_port": {"type": "int"},
                                    },
                                },
                                "next_hop_unchanged": {"type": "bool"},
                                "monitoring": {"type": "bool"},
                                "ebgp_multihop": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "ttl": {"type": "int"},
                                    },
                                },
                                "shutdown": {"type": "bool"},
                                "fall_over": {"type": "bool"},
                                "idle_restart_timer": {"type": "int"},
                                "allowas_in": {
                                    "type": "dict",
                                    "options": {
                                        "count": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "additional_paths": {
                                    "type": "str",
                                    "choices": ["send", "receive"],
                                },
                                "peer_group": {"type": "str"},
                                "out_delay": {"type": "int"},
                                "import_localpref": {"type": "int"},
                                "prefix_list": {
                                    "type": "dict",
                                    "options": {
                                        "direction": {
                                            "type": "str",
                                            "choices": ["in", "out"],
                                        },
                                        "name": {"type": "str"},
                                    },
                                },
                                "dont_capability_negotiate": {"type": "bool"},
                                "update_source": {"type": "str"},
                                "export_localpref": {"type": "int"},
                                "local_as": {
                                    "type": "dict",
                                    "options": {
                                        "as_number": {"type": "str"},
                                        "fallback": {"type": "bool"},
                                    },
                                },
                                "maximum_received_routes": {
                                    "type": "dict",
                                    "options": {
                                        "count": {"type": "int"},
                                        "warning_limit": {
                                            "type": "dict",
                                            "options": {
                                                "limit_count": {"type": "int"},
                                                "limit_percent": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "warning_only": {"type": "bool"},
                                    },
                                },
                                "encryption_password": {
                                    "type": "dict",
                                    "no_log": True,
                                    "options": {
                                        "password": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "type": {
                                            "type": "int",
                                            "choices": [0, 7],
                                        },
                                    },
                                },
                                "link_bandwidth": {
                                    "type": "dict",
                                    "options": {
                                        "default": {"type": "str"},
                                        "auto": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "update_delay": {"type": "int"},
                                    },
                                },
                                "graceful_restart_helper": {"type": "bool"},
                                "neighbor_address": {
                                    "type": "str",
                                    "aliases": ["peer"],
                                },
                                "next_hop_self": {"type": "bool"},
                                "route_to_peer": {"type": "bool"},
                                "soft_recognition": {
                                    "type": "str",
                                    "choices": ["all", "None"],
                                },
                                "graceful_restart": {"type": "bool"},
                                "enforce_first_as": {"type": "bool"},
                                "send_community": {
                                    "type": "dict",
                                    "options": {
                                        "community_attribute": {"type": "str"},
                                        "sub_attribute": {
                                            "type": "str",
                                            "choices": [
                                                "extended",
                                                "link-bandwidth",
                                                "standard",
                                            ],
                                        },
                                        "speed": {"type": "str"},
                                        "divide": {
                                            "type": "str",
                                            "choices": ["equal", "ratio"],
                                        },
                                        "link_bandwidth_attribute": {
                                            "type": "str",
                                            "choices": ["aggregate", "divide"],
                                        },
                                    },
                                },
                                "description": {"type": "str"},
                                "maximum_accepted_routes": {
                                    "type": "dict",
                                    "options": {
                                        "count": {"type": "int"},
                                        "warning_limit": {"type": "int"},
                                    },
                                },
                                "auto_local_addr": {"type": "bool"},
                                "metric_out": {"type": "int"},
                                "timers": {
                                    "type": "dict",
                                    "options": {
                                        "holdtime": {"type": "int"},
                                        "keepalive": {"type": "int"},
                                    },
                                },
                                "route_map": {
                                    "type": "dict",
                                    "options": {
                                        "direction": {
                                            "type": "str",
                                            "choices": ["in", "out"],
                                        },
                                        "name": {"type": "str"},
                                    },
                                },
                                "remote_as": {"type": "str"},
                            },
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "stalepath_time": {"type": "int"},
                                "restart_time": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "holdtime": {"type": "int"},
                                "keepalive": {"type": "int"},
                            },
                        },
                        "shutdown": {"type": "bool"},
                        "graceful_restart_helper": {"type": "bool"},
                        "ucmp": {
                            "type": "dict",
                            "options": {
                                "link_bandwidth": {
                                    "type": "dict",
                                    "options": {
                                        "update_delay": {"type": "int"},
                                        "mode": {
                                            "type": "str",
                                            "choices": [
                                                "encoding_weighted",
                                                "recursive",
                                                "update_delay",
                                            ],
                                        },
                                    },
                                },
                                "fec": {
                                    "type": "dict",
                                    "options": {
                                        "clear": {"type": "int"},
                                        "trigger": {"type": "int"},
                                    },
                                },
                                "mode": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "nexthops": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "maximum_paths": {
                            "type": "dict",
                            "options": {
                                "max_equal_cost_paths": {"type": "int"},
                                "max_installed_ecmp_paths": {"type": "int"},
                            },
                        },
                        "network": {
                            "type": "list",
                            "aliases": ["networks"],
                            "elements": "dict",
                            "options": {
                                "route_map": {"type": "str"},
                                "address": {"type": "str"},
                            },
                        },
                    },
                },
                "access_group": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "direction": {"type": "str"},
                        "afi": {"type": "str", "choices": ["ipv4", "ipv6"]},
                        "acl_name": {"type": "str"},
                    },
                },
                "graceful_restart_helper": {"type": "bool"},
                "ucmp": {
                    "type": "dict",
                    "options": {
                        "link_bandwidth": {
                            "type": "dict",
                            "options": {
                                "update_delay": {"type": "int"},
                                "mode": {
                                    "type": "str",
                                    "choices": [
                                        "encoding_weighted",
                                        "recursive",
                                    ],
                                },
                            },
                        },
                        "fec": {
                            "type": "dict",
                            "options": {
                                "clear": {"type": "int"},
                                "trigger": {"type": "int"},
                            },
                        },
                        "mode": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "nexthops": {"type": "int"},
                            },
                        },
                    },
                },
                "shutdown": {"type": "bool"},
                "maximum_paths": {
                    "type": "dict",
                    "options": {
                        "max_equal_cost_paths": {"type": "int"},
                        "max_installed_ecmp_paths": {"type": "int"},
                    },
                },
                "network": {
                    "type": "list",
                    "aliases": ["networks"],
                    "elements": "dict",
                    "options": {
                        "route_map": {"type": "str"},
                        "address": {"type": "str"},
                    },
                },
            },
        },
    }  # pylint: disable=C0301
