"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageStyles = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DEFAULT_CHART_STYLES = exports.BarOrientation = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Client route
const PPL_BASE = '/api/ppl';
exports.PPL_BASE = PPL_BASE;
const PPL_SEARCH = '/search';
exports.PPL_SEARCH = PPL_SEARCH;
const DSL_BASE = '/api/dsl';
exports.DSL_BASE = DSL_BASE;
const DSL_SEARCH = '/search';
exports.DSL_SEARCH = DSL_SEARCH;
const DSL_CAT = '/cat.indices';
exports.DSL_CAT = DSL_CAT;
const DSL_MAPPING = '/indices.getFieldMapping';
exports.DSL_MAPPING = DSL_MAPPING;
const OBSERVABILITY_BASE = '/api/observability';
exports.OBSERVABILITY_BASE = OBSERVABILITY_BASE;
const EVENT_ANALYTICS = '/event_analytics';
exports.EVENT_ANALYTICS = EVENT_ANALYTICS;
const SAVED_OBJECTS = '/saved_objects';
exports.SAVED_OBJECTS = SAVED_OBJECTS;
const SAVED_QUERY = '/query';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = '/vis'; // Server route

exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const PPL_ENDPOINT = '/_plugins/_ppl';
exports.PPL_ENDPOINT = PPL_ENDPOINT;
const SQL_ENDPOINT = '/_plugins/_sql';
exports.SQL_ENDPOINT = SQL_ENDPOINT;
const DSL_ENDPOINT = '/_plugins/_dsl';
exports.DSL_ENDPOINT = DSL_ENDPOINT;
const observabilityID = 'observability-dashboards';
exports.observabilityID = observabilityID;
const observabilityTitle = 'Observability';
exports.observabilityTitle = observabilityTitle;
const observabilityPluginOrder = 6000; // Shared Constants

exports.observabilityPluginOrder = observabilityPluginOrder;
const SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
exports.SQL_DOCUMENTATION_URL = SQL_DOCUMENTATION_URL;
const PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
exports.PPL_DOCUMENTATION_URL = PPL_DOCUMENTATION_URL;
const PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
exports.PPL_PATTERNS_DOCUMENTATION_URL = PPL_PATTERNS_DOCUMENTATION_URL;
const UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
exports.UI_DATE_FORMAT = UI_DATE_FORMAT;
const PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
exports.PPL_DATE_FORMAT = PPL_DATE_FORMAT;
const SPAN_REGEX = /span/;
exports.SPAN_REGEX = SPAN_REGEX;
const PPL_SPAN_REGEX = /by\s*span/i;
exports.PPL_SPAN_REGEX = PPL_SPAN_REGEX;
const PPL_STATS_REGEX = /\|\s*stats/i;
exports.PPL_STATS_REGEX = PPL_STATS_REGEX;
const PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
exports.PPL_INDEX_INSERT_POINT_REGEX = PPL_INDEX_INSERT_POINT_REGEX;
const PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
exports.PPL_INDEX_REGEX = PPL_INDEX_REGEX;
const PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
exports.PPL_WHERE_CLAUSE_REGEX = PPL_WHERE_CLAUSE_REGEX;
const PPL_NEWLINE_REGEX = /[\n\r]+/g; // Observability plugin URI

exports.PPL_NEWLINE_REGEX = PPL_NEWLINE_REGEX;
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
}; // Saved Objects

exports.OPENSEARCH_PANELS_API = OPENSEARCH_PANELS_API;
const SAVED_OBJECT = '/object'; // Color Constants

exports.SAVED_OBJECT = SAVED_OBJECT;
const PLOTLY_COLOR = ['#3CA1C7', '#8C55A3', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
exports.PLOTLY_COLOR = PLOTLY_COLOR;
const LONG_CHART_COLOR = PLOTLY_COLOR[1];
exports.LONG_CHART_COLOR = LONG_CHART_COLOR;
const pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
exports.pageStyles = pageStyles;
let VIS_CHART_TYPES;
exports.VIS_CHART_TYPES = VIS_CHART_TYPES;

(function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
})(VIS_CHART_TYPES || (exports.VIS_CHART_TYPES = VIS_CHART_TYPES = {}));

const NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
exports.NUMERICAL_FIELDS = NUMERICAL_FIELDS;
const ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text]; // Live tail constants

exports.ENABLED_VIS_TYPES = ENABLED_VIS_TYPES;
const LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
exports.LIVE_OPTIONS = LIVE_OPTIONS;
const LIVE_END_TIME = 'now';
exports.LIVE_END_TIME = LIVE_END_TIME;
const DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 2,
  FillOpacity: 70,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
exports.DEFAULT_CHART_STYLES = DEFAULT_CHART_STYLES;
const FILLOPACITY_DIV_FACTOR = 200;
exports.FILLOPACITY_DIV_FACTOR = FILLOPACITY_DIV_FACTOR;
const SLIDER_MIN_VALUE = 0;
exports.SLIDER_MIN_VALUE = SLIDER_MIN_VALUE;
const SLIDER_MAX_VALUE = 100;
exports.SLIDER_MAX_VALUE = SLIDER_MAX_VALUE;
const SLIDER_STEP = 1;
exports.SLIDER_STEP = SLIDER_STEP;
const THRESHOLD_LINE_WIDTH = 3;
exports.THRESHOLD_LINE_WIDTH = THRESHOLD_LINE_WIDTH;
const THRESHOLD_LINE_OPACITY = 0.7;
exports.THRESHOLD_LINE_OPACITY = THRESHOLD_LINE_OPACITY;
const MAX_BUCKET_LENGTH = 16;
exports.MAX_BUCKET_LENGTH = MAX_BUCKET_LENGTH;
let BarOrientation;
exports.BarOrientation = BarOrientation;

(function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
})(BarOrientation || (exports.BarOrientation = BarOrientation = {}));

const PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
exports.PLOT_MARGIN = PLOT_MARGIN;
const WAITING_TIME_ON_USER_ACTIONS = 300;
exports.WAITING_TIME_ON_USER_ACTIONS = WAITING_TIME_ON_USER_ACTIONS;
const VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data'
};
exports.VISUALIZATION_ERROR = VISUALIZATION_ERROR;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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