/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFData;
import com.google.common.collect.ImmutableSet;

public enum EPUBProfile {
    DEFAULT,
    IDX,
    DICT,
    EDUPUB,
    PREVIEW;


    public static EPUBProfile makeOPFCompatible(EPUBProfile profile, OPFData opfData, String path, Report report) {
        Object pubTypes;
        Object object = pubTypes = opfData != null ? opfData.getTypes() : ImmutableSet.of();
        if (pubTypes.contains("dictionary") && profile != DICT) {
            report.message(MessageId.OPF_064, EPUBLocation.create(path), new Object[]{"dictionary", DICT});
            return DICT;
        }
        if (pubTypes.contains("edupub") && profile != EDUPUB) {
            report.message(MessageId.OPF_064, EPUBLocation.create(path), new Object[]{"edupub", EDUPUB});
            return EDUPUB;
        }
        if (pubTypes.contains("index") && profile != IDX) {
            report.message(MessageId.OPF_064, EPUBLocation.create(path), new Object[]{"index", IDX});
            return IDX;
        }
        if (pubTypes.contains("preview") && profile != PREVIEW) {
            report.message(MessageId.OPF_064, EPUBLocation.create(path), new Object[]{"preview", PREVIEW});
            return PREVIEW;
        }
        return profile != null ? profile : DEFAULT;
    }
}

