/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.LinkTagHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.SearchDictionary;
import java.util.zip.ZipEntry;

public class EpubStyleSheetsCheck
implements DocumentValidator {
    private final Report report;
    private final EpubPackage epack;

    public EpubStyleSheetsCheck(EpubPackage epack, Report report) {
        this.epack = epack;
        this.report = report;
    }

    @Override
    public boolean validate() {
        SearchDictionary validTypes = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem mi = this.epack.getManifest().getItem(i);
            if (!validTypes.isValidMediaType(mi.getMediaType())) continue;
            String fileToParse = this.epack.getManifestItemFileName(mi);
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            XMLContentDocParser parser = new XMLContentDocParser(this.epack.getZip(), this.report);
            LinkTagHandler h = new LinkTagHandler(this.report);
            parser.parseDoc(fileToParse, h);
            h.checkForMultipleStyleSheets(fileToParse);
        }
        return true;
    }
}

