/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBUtility;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CBResourceBundle {
    Hashtable translations = new Hashtable();
    private static Logger log = Logger.getLogger(CBResourceBundle.class.getName());

    public CBResourceBundle(String baseName) {
        this.loadBundle(baseName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
    }

    public CBResourceBundle(String baseName, Locale locale) {
        this.loadBundle(baseName, locale, ClassLoader.getSystemClassLoader());
    }

    public CBResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        this.loadBundle(baseName, locale, loader);
    }

    protected void loadBundle(String baseName, Locale locale, ClassLoader loader) {
        Vector names = CBResourceBundle.getBundleNames(baseName, locale);
        for (int i = names.size() - 1; i >= 0; --i) {
            URL url = loader.getResource(names.get(i).toString());
            if (!this.loadData(url)) continue;
            return;
        }
        log.warning("unable to load resource bundle '" + baseName + "'");
    }

    protected static Vector getBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(8);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (baseName.toLowerCase().endsWith(".properties")) {
            baseName = baseName.substring(baseName.length() - 11);
        }
        baseName = baseName.replace('.', '/');
        StringBuffer temp = new StringBuffer(baseName);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString() + ".properties");
        result.addElement(temp.toString());
        return result;
    }

    protected boolean loadData(URL url) {
        if (url == null) {
            return false;
        }
        log.finer("Resource Bundle Reading data from " + (url == null ? "null url" : url.toString()));
        try {
            byte[] data = CBUtility.readStream(url.openStream());
            String text = CBUtility.readI18NByteArray(data);
            return this.parseData(text);
        }
        catch (Exception e) {
            log.log(Level.FINER, "Unable to read data from url: " + (url == null ? "(null url)" : url.toString()), e);
            return false;
        }
    }

    protected boolean parseData(String text) {
        boolean success;
        int startSize = this.translations.size();
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            String line = text.substring(start, end);
            if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                try {
                    int equalPos = 0;
                    while (line.charAt((equalPos = line.indexOf(61, equalPos + 1)) - 1) == '\\') {
                    }
                    String key = this.unescape(line.substring(0, equalPos)).trim();
                    String trans = line.substring(equalPos + 1).trim();
                    this.translations.put(key, trans);
                }
                catch (Exception e) {
                    log.log(Level.FINER, "Exception parsing data line '" + line, e);
                }
            }
            start = end + 1;
        }
        boolean bl = success = startSize < this.translations.size();
        if (!success) {
            log.finer("ParseData unsuccessfull - no new data found");
        }
        return success;
    }

    protected String unescape(String escapeMe) {
        int pos = 0;
        while ((pos = escapeMe.indexOf(92, pos)) >= 0) {
            escapeMe = escapeMe.substring(0, pos) + escapeMe.substring(pos + 1);
        }
        return escapeMe;
    }

    public Enumeration keys() {
        return this.translations.keys();
    }

    public Enumeration getKeys() {
        return this.translations.keys();
    }

    public Object get(Object key) {
        return this.translations.get(key);
    }

    public Object getObject(Object key) {
        return this.translations.get(key);
    }

    public String getString(String key) {
        if (key == null) {
            return "";
        }
        Object o = this.translations.get(key);
        if (o == null) {
            return "";
        }
        return o instanceof String ? (String)o : o.toString();
    }
}

