/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert;

import com.ca.commons.cbutil.CBToolBarButton;
import com.ca.commons.security.cert.CertViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class CertGeneralViewPanel
extends JPanel {
    private X509Certificate cert = null;
    private CBToolBarButton installCertificateButton = new CBToolBarButton("&Install Certificate...", null);
    private CBToolBarButton issuerStatementButton = new CBToolBarButton("Issuer &Statement...", null);
    private JLabel topLabel = new JLabel("Certificate Information", CertViewer.certLargeIcon, 2);
    private JLabel intendLabel = new JLabel("This certificate:");
    private JTextArea intend = new JTextArea(7, 20);
    private JLabel subjectLabel = new JLabel("Issued to:");
    private JLabel subject = new JLabel("subject");
    private JLabel issuerLabel = new JLabel("Issued by:");
    private JLabel issuer = new JLabel("issuer");
    private JLabel fromLabel = new JLabel("Valid from");
    private JLabel from = new JLabel("from");
    private JLabel toLabel = new JLabel("to");
    private JLabel to = new JLabel("to");

    public CertGeneralViewPanel(X509Certificate cert) {
        this.cert = cert;
        this.installCertificateButton.setWidthHeight(110, 23);
        this.issuerStatementButton.setWidthHeight(110, 23);
        this.installCertificateButton.setEnabled(false);
        this.issuerStatementButton.setEnabled(false);
        this.intend.setPreferredSize(new Dimension(200, 150));
        this.intend.setMinimumSize(new Dimension(200, 150));
        this.intend.setMaximumSize(new Dimension(200, 150));
        this.intend.setText(" Performs Windows System Component Verification\n Performs Windows Hardware Driver Verification\n Allows data on disk to be encrypted\n Allows secured communication on Internet\n ...");
        this.intend.setEditable(false);
        Font courierBoldFont = new Font("SansSerif", 1, 11);
        this.topLabel.setFont(courierBoldFont);
        this.intendLabel.setFont(courierBoldFont);
        this.subjectLabel.setFont(courierBoldFont);
        this.issuerLabel.setFont(courierBoldFont);
        this.fromLabel.setFont(courierBoldFont);
        this.toLabel.setFont(courierBoldFont);
        JPanel generalPanel = new JPanel();
        generalPanel.setBackground(Color.white);
        JScrollPane intendScroll = new JScrollPane(this.intend);
        intendScroll.setVerticalScrollBarPolicy(22);
        if (cert != null) {
            SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
            this.from.setText(df.format(cert.getNotBefore()));
            this.to.setText(df.format(cert.getNotAfter()));
            this.subject.setText(CertViewer.getMostSignificantName(cert.getSubjectX500Principal().getName()));
            this.issuer.setText(CertViewer.getMostSignificantName(cert.getIssuerX500Principal().getName()));
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBackground(Color.white);
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.add((Component)this.subjectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 30, 6, 0), 0, 0));
        bottomPanel.add((Component)this.subject, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 13, 2, new Insets(1, 5, 6, 0), 0, 0));
        bottomPanel.add((Component)this.issuerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 30, 6, 0), 0, 0));
        bottomPanel.add((Component)this.issuer, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 13, 2, new Insets(1, 5, 6, 0), 0, 0));
        bottomPanel.add((Component)this.fromLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 30, 6, 0), 0, 0));
        bottomPanel.add((Component)this.from, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(1, 5, 6, 0), 0, 0));
        bottomPanel.add((Component)this.toLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 6, 0), 0, 0));
        bottomPanel.add((Component)this.to, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 13, 2, new Insets(1, 5, 6, 0), 0, 0));
        generalPanel.setLayout(new GridBagLayout());
        generalPanel.add((Component)this.topLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 6, 10), 0, 0));
        generalPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 6, 10), 0, 0));
        generalPanel.add((Component)this.intendLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 6, 10), 0, 0));
        generalPanel.add((Component)intendScroll, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 40, 6, 10), 0, 0));
        generalPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 10, 6, 10), 0, 0));
        generalPanel.add((Component)bottomPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 6, 10), 0, 0));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(generalPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 6, 10), 0, 0));
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 6, 5), 0, 0));
        this.installCertificateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertGeneralViewPanel.this.installCertificateButton_actionPerformed(e);
            }
        });
        this.issuerStatementButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertGeneralViewPanel.this.issuerStatementButton_actionPerformed(e);
            }
        });
    }

    private void installCertificateButton_actionPerformed(ActionEvent e) {
        System.out.println("Install the certificate to this machine");
    }

    private void issuerStatementButton_actionPerformed(ActionEvent e) {
        System.out.println("View issuer statement");
    }
}

