/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBSingleSelectionModel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.broker.Broker;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class StopMonitor {
    Vector watchList;
    Frame parent;
    Vector watchingComponents;
    StopMonitorGUI monitor;
    static int threadID = 0;
    private static Logger log = Logger.getLogger(StopMonitor.class.getName());

    public StopMonitor(Broker[] brokerList, Frame parent) {
        this.parent = parent;
        this.watchList = new Vector(brokerList.length);
        this.watchingComponents = new Vector(4);
        for (int i = 0; i < brokerList.length; ++i) {
            this.add(brokerList[i]);
        }
    }

    public void add(Broker b) {
        this.watchList.add(b);
        b.registerStopMonitor(this);
    }

    protected Vector getQueryBrokers() {
        Broker broker;
        int i;
        int noBrokers = this.watchList.size();
        Vector<QueryBroker> doublets = new Vector<QueryBroker>(noBrokers * 2);
        for (i = 0; i < noBrokers; ++i) {
            broker = (Broker)this.watchList.get(i);
            DataQuery query = broker.getCurrent();
            if (query == null || query.isCancelled()) continue;
            doublets.add(new QueryBroker(broker, query));
        }
        for (i = 0; i < noBrokers; ++i) {
            broker = (Broker)this.watchList.get(i);
            Vector queries = broker.getRequestQueue();
            for (int j = 0; j < queries.size(); ++j) {
                doublets.add(new QueryBroker(broker, (DataQuery)queries.get(j)));
            }
        }
        return doublets;
    }

    public boolean queriesPending() {
        for (int i = 0; i < this.watchList.size(); ++i) {
            if (!((Broker)this.watchList.get(i)).hasRequests()) continue;
            return true;
        }
        return false;
    }

    public void addWatcher(Component c) {
        this.watchingComponents.add(c);
    }

    public void updateWatchers() {
        boolean enableStatus = this.queriesPending();
        for (int i = 0; i < this.watchingComponents.size(); ++i) {
            Component c = (Component)this.watchingComponents.get(i);
            if (c.isEnabled() == enableStatus) continue;
            c.setEnabled(enableStatus);
            c.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelQuery(QueryBroker pair) {
        if (pair == null) {
            return;
        }
        DataQuery query = pair.query;
        Broker broker = pair.broker;
        StopMonitor stopMonitor = this;
        synchronized (stopMonitor) {
            if (query.isRunning()) {
                query.cancel();
                new Thread((Runnable)broker, "restarted thread for: " + threadID++ + " " + broker.getClass()).start();
            } else {
                broker.removeQuery(query);
            }
        }
    }

    public void show() {
        Vector QBs = this.getQueryBrokers();
        if (QBs.size() == 0) {
            JOptionPane.showMessageDialog(this.parent, CBIntText.get("There are no outstanding directory queries to cancel."), CBIntText.get("Nothing to do."), 1);
            return;
        }
        if (this.monitor != null) {
            this.monitor.update();
            if (!this.monitor.singleDelete()) {
                this.monitor.setVisible(true);
            }
        } else {
            this.monitor = new StopMonitorGUI(this, QBs);
            this.monitor.setSize(300, 400);
            CBUtility.center(this.monitor, this.parent);
            Thread buttonMonitor = new Thread((Runnable)this.monitor, "Stop Monitor Thread");
            buttonMonitor.start();
            if (!this.monitor.singleDelete()) {
                this.monitor.setVisible(true);
            }
        }
    }

    class StopMonitorListRenderer
    extends JLabel
    implements ListCellRenderer {
        Color highlight = new Color(0, 0, 128);
        Color active = new Color(128, 0, 0);
        Color pending = new Color(0, 128, 0);
        Color cancelled = new Color(64, 64, 64);

        StopMonitorListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataQuery item;
            if (!(value instanceof QueryBroker)) {
                log.warning("Rendering error in StopMonitor");
                this.setText("error");
                return this;
            }
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return this;
                }
                index = selected;
            }
            if ((item = ((QueryBroker)value).query) == null) {
                this.setBackground(Color.white);
                this.setForeground(this.cancelled);
                this.setText("<deleted>");
                return this;
            }
            this.setText(item.toString());
            Color back = Color.white;
            Color fore = Color.black;
            fore = item.isCancelled() ? this.cancelled : (item.isRunning() ? this.active : this.pending);
            if (isSelected) {
                this.setBackground(this.highlight);
                this.setForeground(Color.white);
            } else {
                this.setBackground(back);
                this.setForeground(fore);
            }
            return this;
        }
    }

    class StopMonitorGUI
    extends JDialog
    implements Runnable {
        JList list;
        DefaultListModel model;
        StopMonitor myMonitor;
        boolean finished;
        boolean selected;
        QueryBroker selectedQuery;

        StopMonitorGUI(StopMonitor myMonitor, Vector queryBrokers) {
            super(myMonitor.parent);
            this.finished = false;
            this.selected = false;
            this.selectedQuery = null;
            this.myMonitor = myMonitor;
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            for (int i = 0; i < queryBrokers.size(); ++i) {
                this.model.addElement(queryBrokers.get(i));
            }
            this.list.setSelectionMode(0);
            this.list.setSelectionModel(new CBSingleSelectionModel(this.list));
            this.list.setCellRenderer(new StopMonitorListRenderer());
            this.list.setVisibleRowCount(6);
            this.list.setSelectedIndex(0);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().setView(this.list);
            this.getContentPane().add("Center", scrollPane);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            CBButton ok = new CBButton(CBIntText.get("Delete Query"), CBIntText.get("Delete the current query."));
            buttonPanel.add(ok);
            CBButton cancel = new CBButton(CBIntText.get("Exit"), CBIntText.get("Exit this window."));
            buttonPanel.add(cancel);
            CBButton help = new CBButton(CBIntText.get("Help"), CBIntText.get("Open the help."));
            buttonPanel.add(help);
            CBHelpSystem.useDefaultHelp(help, "abort");
            this.getContentPane().add("South", buttonPanel);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StopMonitorGUI.this.cancelSelectedQuery();
                }
            });
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StopMonitorGUI.this.setVisible(false);
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        StopMonitorGUI.this.cancelSelectedQuery();
                    }
                }
            });
        }

        protected void update() {
            int selectedID = -1;
            Vector queryBrokers = this.myMonitor.getQueryBrokers();
            QueryBroker selectedQuery = (QueryBroker)this.list.getSelectedValue();
            if (selectedQuery != null) {
                selectedID = selectedQuery.id;
            }
            this.model.removeAllElements();
            for (int i = 0; i < queryBrokers.size(); ++i) {
                QueryBroker newQuery = (QueryBroker)queryBrokers.get(i);
                this.model.addElement(newQuery);
                if (selectedID != newQuery.id) continue;
                this.list.setSelectedValue(newQuery, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelSelectedQuery() {
            StopMonitorGUI stopMonitorGUI = this;
            synchronized (stopMonitorGUI) {
                if (this.list.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(this.getContentPane(), CBIntText.get("You must select a query to stop from the list") + "\n" + CBIntText.get("otherwise you can just use the 'cancel' button."), CBIntText.get("Stop Monitor Help"), 1);
                } else {
                    this.selectedQuery = (QueryBroker)this.list.getSelectedValue();
                    this.selected = true;
                    this.model.removeElement(this.selectedQuery);
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVisible(boolean status) {
            super.setVisible(status);
            StopMonitorGUI stopMonitorGUI = this;
            synchronized (stopMonitorGUI) {
                if (status) {
                    this.notify();
                }
            }
        }

        public boolean singleDelete() {
            if (this.model.size() == 0) {
                return false;
            }
            this.list.setSelectedIndex(0);
            if (this.model.size() == 1) {
                this.cancelSelectedQuery();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.finished) {
                try {
                    StopMonitorGUI stopMonitorGUI = this;
                    synchronized (stopMonitorGUI) {
                        if (this.selectedQuery != null) {
                            this.myMonitor.cancelQuery(this.selectedQuery);
                            this.selectedQuery = null;
                        }
                        if (this.isVisible()) {
                            this.wait(250L);
                        } else {
                            this.wait();
                        }
                        this.update();
                    }
                }
                catch (InterruptedException e) {
                    CBUtility.error("Exception in stop monitor: ", e);
                }
            }
        }
    }

    protected class QueryBroker {
        public Broker broker;
        public DataQuery query;
        public int id;

        QueryBroker(Broker b, DataQuery q) {
            this.broker = b;
            this.query = q;
            this.id = q.id;
        }
    }
}

