#!/bin/sh
# OpenDirectory  jxstart.sh $Revision: 1.13 $  $Date: 2006/04/18 04:12:12 $

PATH=/bin:/usr/bin

JAVA_HOME=$(/usr/local/bin/javaPathHelper -h jxplorer)
JAVA_LOC=$(/usr/local/bin/javaPathHelper -c jxplorer)

# use an absolute path instead of a relative one
jars=/usr/local/share/jxplorer/jars

# Find directory of JRE
${JAVA_LOC} -version  >/dev/null 2>&1
if [ "$?" != "0" ] ; then
	OPTJX=$JAVA_LOC

	# $OPTJX MUST be the JXplorer install directory, or a link to it, and contain the JRE

	if [ ! -d $OPTJX -o ! -h $OPTJX ] ; then
		echo "Either java must be in the path, or"
		echo "$OPTJX MUST be the JXplorer install directory, or a link to it, and contain the JRE"
		exit 1
	fi

	cd $OPTJX
        JAVAV=$JAVA_LOC
else
        JAVAV=${JAVA_LOC}
fi

echo "starting JXplorer..."
echo
FAIL=0
if [ "$1" = "console" ] ; then
    $JAVAV -Dcom.apple.macos.useScreenMenuBar=true -cp .:$jars/jxplorer.jar:$jars/help.jar:$jars/jhall.jar:$jars/junit.jar:$jars/ldapsec.jar:$jars/log4j.jar:$jars/dsml/activation.jar:$jars/dsml/commons-logging.jar:$jars/dsml/dom4j.jar:$jars/dsml/jxext.jar:$jars/dsml/mail.jar:$jars/dsml/providerutil.jar:$jars/dsml/saaj-api.jar:$jars/dsml/saaj-ri.jar com.ca.directory.jxplorer.JXplorer

    if [ "$?" != "0" ]; then
        FAIL=1
    fi
else
    echo "Use \"jxplorer console\" if you want logging to the console"
    $JAVAV -Dcom.apple.macos.useScreenMenuBar=true -cp .:$jars/jxplorer.jar:$jars/help.jar:$jars/jhall.jar:$jars/junit.jar:$jars/ldapsec.jar:$jars/log4j.jar:$jars/dsml/activation.jar:$jars/dsml/commons-logging.jar:$jars/dsml/dom4j.jar:$jars/dsml/jxext.jar:$jars/dsml/mail.jar:$jars/dsml/providerutil.jar:$jars/dsml/saaj-api.jar:$jars/dsml/saaj-ri.jar com.ca.directory.jxplorer.JXplorer  >/dev/null 2>&1

    if [ "$?" != "0" ]; then
        FAIL=1
    fi
fi

# Check for success
if [ $FAIL = 0 ]; then
    exit 0
fi

cat <<-!

=========================
JXplorer failed to start
=========================
Please ensure that you have appropriate "xhost" access to the machine you are
running this from. Make sure the DISPLAY environment variable is set correctly.
Otherwise, ask your Unix Systems Administrator for more information on running
X Windows applications.

If you require more information run "jxplorer console" and check the
error produced.
!

exit 1
