# Generated by default/object.tt
package Paws::ApplicationMigration::Job;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreationDateTime => (is => 'ro', isa => 'Str', request_name => 'creationDateTime', traits => ['NameInRequest']);
  has EndDateTime => (is => 'ro', isa => 'Str', request_name => 'endDateTime', traits => ['NameInRequest']);
  has InitiatedBy => (is => 'ro', isa => 'Str', request_name => 'initiatedBy', traits => ['NameInRequest']);
  has JobID => (is => 'ro', isa => 'Str', request_name => 'jobID', traits => ['NameInRequest'], required => 1);
  has ParticipatingServers => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationMigration::ParticipatingServer]', request_name => 'participatingServers', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::ApplicationMigration::TagsMap', request_name => 'tags', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::Job

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::Job object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::Job object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Job.

=head1 ATTRIBUTES


=head2 Arn => Str

the ARN of the specific Job.


=head2 CreationDateTime => Str

Job creation time.


=head2 EndDateTime => Str

Job end time.


=head2 InitiatedBy => Str

Job initiated by field.


=head2 B<REQUIRED> JobID => Str

Job ID.


=head2 ParticipatingServers => ArrayRef[L<Paws::ApplicationMigration::ParticipatingServer>]

Servers participating in a specific Job.


=head2 Status => Str

Job status.


=head2 Tags => L<Paws::ApplicationMigration::TagsMap>

Tags associated with spcific Job.


=head2 Type => Str

Job type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

