/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.IXHTMLSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextLine;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextBlock
extends CompositeSegment<TextLine>
implements IXHTMLSegment {
    protected int textAlignment;
    protected float lineSpacing;
    public float strXPosNewline = -1.0f;
    public static final int NO_CLASSIFICATIONS = 3;
    public static final int ALIGN_LCR = 31;
    public static final int ALIGN_LC = 32;
    public static final int ALIGN_CR = 33;
    public static final int ALIGN_L = 34;
    public static final int ALIGN_C = 35;
    public static final int ALIGN_R = 36;
    public static final int ALIGN_NONE = 37;
    public static final int ALIGN_UNSET = 0;
    protected int classification;
    public static final int PARAGRAPH = 0;
    public static final int HEADING = 1;
    public static final int BODY = 0;
    public static final int BODY_TEXT = 40;
    public static final int HEADING_1 = 41;
    public static final int HEADING_2 = 42;
    public static final int HEADING_3 = 43;
    public static final int ORDERED_LIST_ITEM = 51;
    public static final int UNORDERED_LIST_ITEM = 52;
    public static final int OTHER_TEXT = 9;
    public static final int CELL = 2;

    public TextBlock() {
    }

    public TextBlock(List<TextLine> items) {
        this.items = items;
    }

    public TextBlock(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
    }

    public TextBlock(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
    }

    public TextBlock(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize, List<TextLine> items) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
        this.items = items;
    }

    public TextBlock(float x1, float x2, float y1, float y2, List<TextLine> items) {
        super(x1, x2, y1, y2);
        this.items = items;
    }

    @Override
    public void setElementAttributes(Document resultDocument, Element newSegmentElement, GenericSegment pageDim, float resolution) {
        super.setElementAttributes(resultDocument, newSegmentElement, pageDim, resolution);
        newSegmentElement.setAttribute("font-size", Float.toString(this.getFontSize()));
        String type = "unknown";
        switch (this.classification) {
            case 0: {
                type = "paragraph";
                break;
            }
            case 1: {
                type = "heading";
                break;
            }
            case 9: {
                type = "other-text";
                break;
            }
            case 2: {
                type = "cell";
                break;
            }
            default: {
                type = "error";
            }
        }
        newSegmentElement.setAttribute("type", type);
    }

    @Override
    public void addAsXHTML(Document resultDocument, Element parent) {
        Object tempElement = null;
        Element newParagraphElement = this.classification == 1 || this.classification == 43 ? resultDocument.createElement("h3") : (this.classification == 42 ? resultDocument.createElement("h2") : (this.classification == 41 ? resultDocument.createElement("h1") : (this.classification == 52 ? resultDocument.createElement("li") : resultDocument.createElement("p"))));
        if (this.classification >= 40 && this.classification < 60) {
            Element newTextElement;
            boolean bold = false;
            boolean italic = false;
            boolean underlined = false;
            int superSubscript = 0;
            String textToAdd = "";
            float prevX2 = -1.0f;
            for (TextLine tl1 : this.items) {
                if (tl1.getX1() < prevX2 && prevX2 < this.strXPosNewline) {
                    textToAdd = String.valueOf(textToAdd) + "\n";
                }
                prevX2 = tl1.getX2();
                for (TextLine tl2 : tl1.getItems()) {
                    GenericSegment prevFrag = null;
                    for (TextFragment tf : tl2.getItems()) {
                        if (prevFrag != null) {
                            float horizGap = tf.getX1() - prevFrag.getX2();
                            float afs = (tf.getFontSize() + ((TextSegment)prevFrag).getFontSize()) / 2.0f;
                            if (!tf.getText().trim().matches("[\\s]") && !((TextSegment)prevFrag).getText().trim().matches("[\\s]") && horizGap > afs * 0.15f) {
                                textToAdd = String.valueOf(textToAdd) + " ";
                            }
                        }
                        if (tf.isBold() == bold && tf.isItalic() == italic && tf.isUnderlined() == underlined && tf.getSuperSubscript() == superSubscript) {
                            textToAdd = String.valueOf(textToAdd) + tf.getText();
                        } else {
                            if (textToAdd.trim().length() > 0) {
                                Element newTextElement2;
                                if (superSubscript == 1) {
                                    if (underlined) {
                                        if (bold && italic) {
                                            Element newTextElement4 = resultDocument.createElement("sup");
                                            newParagraphElement.appendChild(newTextElement4);
                                            Element newTextElement3 = resultDocument.createElement("u");
                                            newTextElement4.appendChild(newTextElement3);
                                            newTextElement2 = resultDocument.createElement("b");
                                            newTextElement3.appendChild(newTextElement2);
                                            newTextElement = resultDocument.createElement("i");
                                            newTextElement2.appendChild(newTextElement);
                                        } else if (bold) {
                                            Element newTextElement3 = resultDocument.createElement("sup");
                                            newParagraphElement.appendChild(newTextElement3);
                                            Element newTextElement22 = resultDocument.createElement("u");
                                            newTextElement3.appendChild(newTextElement22);
                                            newTextElement = resultDocument.createElement("b");
                                            newTextElement22.appendChild(newTextElement);
                                        } else if (italic) {
                                            Element newTextElement3 = resultDocument.createElement("sup");
                                            newParagraphElement.appendChild(newTextElement3);
                                            Element newTextElement23 = resultDocument.createElement("u");
                                            newTextElement3.appendChild(newTextElement23);
                                            newTextElement = resultDocument.createElement("i");
                                            newTextElement23.appendChild(newTextElement);
                                        } else {
                                            Element newTextElement24 = resultDocument.createElement("sup");
                                            newParagraphElement.appendChild(newTextElement24);
                                            newTextElement = resultDocument.createElement("u");
                                            newTextElement24.appendChild(newTextElement);
                                        }
                                    } else if (bold && italic) {
                                        Element newTextElement3 = resultDocument.createElement("sup");
                                        newParagraphElement.appendChild(newTextElement3);
                                        Element newTextElement25 = resultDocument.createElement("b");
                                        newTextElement3.appendChild(newTextElement25);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement25.appendChild(newTextElement);
                                    } else if (bold) {
                                        Element newTextElement26 = resultDocument.createElement("sup");
                                        newParagraphElement.appendChild(newTextElement26);
                                        newTextElement = resultDocument.createElement("b");
                                        newTextElement26.appendChild(newTextElement);
                                    } else if (italic) {
                                        Element newTextElement27 = resultDocument.createElement("sup");
                                        newParagraphElement.appendChild(newTextElement27);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement27.appendChild(newTextElement);
                                    } else {
                                        newTextElement = resultDocument.createElement("sup");
                                        newParagraphElement.appendChild(newTextElement);
                                    }
                                } else if (superSubscript == -1) {
                                    if (underlined) {
                                        if (bold && italic) {
                                            Element newTextElement4 = resultDocument.createElement("sub");
                                            newParagraphElement.appendChild(newTextElement4);
                                            Element newTextElement3 = resultDocument.createElement("u");
                                            newTextElement4.appendChild(newTextElement3);
                                            newTextElement2 = resultDocument.createElement("b");
                                            newTextElement3.appendChild(newTextElement2);
                                            newTextElement = resultDocument.createElement("i");
                                            newTextElement2.appendChild(newTextElement);
                                        } else if (bold) {
                                            Element newTextElement3 = resultDocument.createElement("sub");
                                            newParagraphElement.appendChild(newTextElement3);
                                            Element newTextElement28 = resultDocument.createElement("u");
                                            newTextElement3.appendChild(newTextElement28);
                                            newTextElement = resultDocument.createElement("b");
                                            newTextElement28.appendChild(newTextElement);
                                        } else if (italic) {
                                            Element newTextElement3 = resultDocument.createElement("sub");
                                            newParagraphElement.appendChild(newTextElement3);
                                            Element newTextElement29 = resultDocument.createElement("u");
                                            newTextElement3.appendChild(newTextElement29);
                                            newTextElement = resultDocument.createElement("i");
                                            newTextElement29.appendChild(newTextElement);
                                        } else {
                                            Element newTextElement210 = resultDocument.createElement("sub");
                                            newParagraphElement.appendChild(newTextElement210);
                                            newTextElement = resultDocument.createElement("u");
                                            newTextElement210.appendChild(newTextElement);
                                        }
                                    } else if (bold && italic) {
                                        Element newTextElement3 = resultDocument.createElement("sub");
                                        newParagraphElement.appendChild(newTextElement3);
                                        Element newTextElement211 = resultDocument.createElement("b");
                                        newTextElement3.appendChild(newTextElement211);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement211.appendChild(newTextElement);
                                    } else if (bold) {
                                        Element newTextElement212 = resultDocument.createElement("sub");
                                        newParagraphElement.appendChild(newTextElement212);
                                        newTextElement = resultDocument.createElement("b");
                                        newTextElement212.appendChild(newTextElement);
                                    } else if (italic) {
                                        Element newTextElement213 = resultDocument.createElement("sub");
                                        newParagraphElement.appendChild(newTextElement213);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement213.appendChild(newTextElement);
                                    } else {
                                        newTextElement = resultDocument.createElement("sub");
                                        newParagraphElement.appendChild(newTextElement);
                                    }
                                } else if (underlined) {
                                    if (bold && italic) {
                                        Element newTextElement3 = resultDocument.createElement("u");
                                        newParagraphElement.appendChild(newTextElement3);
                                        Element newTextElement214 = resultDocument.createElement("b");
                                        newTextElement3.appendChild(newTextElement214);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement214.appendChild(newTextElement);
                                    } else if (bold) {
                                        Element newTextElement215 = resultDocument.createElement("u");
                                        newParagraphElement.appendChild(newTextElement215);
                                        newTextElement = resultDocument.createElement("b");
                                        newTextElement215.appendChild(newTextElement);
                                    } else if (italic) {
                                        Element newTextElement216 = resultDocument.createElement("u");
                                        newParagraphElement.appendChild(newTextElement216);
                                        newTextElement = resultDocument.createElement("i");
                                        newTextElement216.appendChild(newTextElement);
                                    } else {
                                        newTextElement = resultDocument.createElement("u");
                                        newParagraphElement.appendChild(newTextElement);
                                    }
                                } else if (bold && italic) {
                                    Element newTextElement217 = resultDocument.createElement("b");
                                    newParagraphElement.appendChild(newTextElement217);
                                    newTextElement = resultDocument.createElement("i");
                                    newTextElement217.appendChild(newTextElement);
                                } else if (bold) {
                                    newTextElement = resultDocument.createElement("b");
                                    newParagraphElement.appendChild(newTextElement);
                                } else if (italic) {
                                    newTextElement = resultDocument.createElement("i");
                                    newParagraphElement.appendChild(newTextElement);
                                } else {
                                    newTextElement = newParagraphElement;
                                }
                                String textSection = new String();
                                int n = 0;
                                while (n < textToAdd.length()) {
                                    String thisChar = textToAdd.substring(n, n + 1);
                                    if (thisChar.equals("\n")) {
                                        newTextElement.appendChild(resultDocument.createTextNode(textSection));
                                        newTextElement.appendChild(resultDocument.createElement("br"));
                                        textSection = "";
                                    } else {
                                        textSection = textSection.concat(thisChar);
                                    }
                                    ++n;
                                }
                                if (textSection.length() > 0) {
                                    newTextElement.appendChild(resultDocument.createTextNode(textSection));
                                }
                            }
                            bold = tf.isBold();
                            italic = tf.isItalic();
                            underlined = tf.isUnderlined();
                            textToAdd = "";
                            textToAdd = String.valueOf(textToAdd) + tf.getText();
                            superSubscript = tf.getSuperSubscript();
                        }
                        prevFrag = tf;
                    }
                }
            }
            if (textToAdd.trim().length() > 0) {
                if (bold && italic) {
                    Element newTextElement2 = resultDocument.createElement("b");
                    newParagraphElement.appendChild(newTextElement2);
                    newTextElement = resultDocument.createElement("i");
                    newTextElement2.appendChild(newTextElement);
                } else if (bold) {
                    newTextElement = resultDocument.createElement("b");
                    newParagraphElement.appendChild(newTextElement);
                } else if (italic) {
                    newTextElement = resultDocument.createElement("i");
                    newParagraphElement.appendChild(newTextElement);
                } else {
                    newTextElement = newParagraphElement;
                }
                String textSection = new String();
                int n = 0;
                while (n < textToAdd.length()) {
                    String thisChar = textToAdd.substring(n, n + 1);
                    if (thisChar.equals("\n")) {
                        newTextElement.appendChild(resultDocument.createTextNode(textSection));
                        newTextElement.appendChild(resultDocument.createElement("br"));
                        textSection = "";
                    } else {
                        textSection = textSection.concat(thisChar);
                    }
                    ++n;
                }
                if (textSection.length() > 0) {
                    newTextElement.appendChild(resultDocument.createTextNode(textSection));
                }
            }
        } else {
            Element newTextElement;
            if (this.isBold() && this.isItalic()) {
                Element newTextElement2 = resultDocument.createElement("b");
                newParagraphElement.appendChild(newTextElement2);
                newTextElement = resultDocument.createElement("i");
                newTextElement2.appendChild(newTextElement);
            } else if (this.isBold()) {
                newTextElement = resultDocument.createElement("b");
                newParagraphElement.appendChild(newTextElement);
            } else if (this.isItalic()) {
                newTextElement = resultDocument.createElement("i");
                newParagraphElement.appendChild(newTextElement);
            } else {
                newTextElement = newParagraphElement;
            }
            String theText = this.getText();
            String textSection = new String();
            int n = 0;
            while (n < theText.length()) {
                String thisChar = theText.substring(n, n + 1);
                if (thisChar.equals("\n")) {
                    newTextElement.appendChild(resultDocument.createTextNode(textSection));
                    newTextElement.appendChild(resultDocument.createElement("br"));
                    textSection = "";
                } else {
                    textSection = textSection.concat(thisChar);
                }
                ++n;
            }
            if (textSection.length() > 0) {
                newTextElement.appendChild(resultDocument.createTextNode(textSection));
            }
        }
        parent.appendChild(newParagraphElement);
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public float getStrXPosNewline() {
        return this.strXPosNewline;
    }

    public void setStrXPosNewline(float strXPosNewline) {
        this.strXPosNewline = strXPosNewline;
    }
}

