/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Encoding
implements COSObjectable {
    protected final Map<Integer, COSName> codeToName = new HashMap<Integer, COSName>();
    protected final Map<COSName, Integer> nameToCode = new HashMap<COSName, Integer>();
    private static final Map<COSName, String> NAME_TO_CHARACTER;
    private static final Map<String, COSName> CHARACTER_TO_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadGlyphList(String location) {
        BufferedReader glyphStream = null;
        try {
            InputStream resource = ResourceLoader.loadResource(location);
            glyphStream = new BufferedReader(new InputStreamReader(resource));
            String line = null;
            while ((line = glyphStream.readLine()) != null) {
                int semicolonIndex;
                if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                try {
                    String characterName = line.substring(0, semicolonIndex);
                    String unicodeValue = line.substring(semicolonIndex + 1, line.length());
                    StringTokenizer tokenizer = new StringTokenizer(unicodeValue, " ", false);
                    String value = "";
                    while (tokenizer.hasMoreTokens()) {
                        int characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                        value = value + (char)characterCode;
                    }
                    NAME_TO_CHARACTER.put(COSName.getPDFName(characterName), value);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (glyphStream != null) {
                try {
                    glyphStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Map<Integer, COSName> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }

    public Map<COSName, Integer> getNameToCodeMap() {
        return Collections.unmodifiableMap(this.nameToCode);
    }

    protected void addCharacterEncoding(int code, COSName name) {
        this.codeToName.put(code, name);
        this.nameToCode.put(name, code);
    }

    public int getCode(COSName name) throws IOException {
        Integer code = this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name.getName() + "'");
        }
        return code;
    }

    public COSName getName(int code) throws IOException {
        COSName name = this.codeToName.get(code);
        if (name == null) {
            name = COSName.getPDFName("space");
        }
        return name;
    }

    public COSName getNameFromCharacter(char c) throws IOException {
        COSName name = CHARACTER_TO_NAME.get(Character.toString(c));
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String character = Encoding.getCharacter(this.getName(code));
        return character;
    }

    public static String getCharacter(COSName name) {
        COSName baseName = name;
        String character = NAME_TO_CHARACTER.get(baseName);
        if (character == null) {
            String nameStr = baseName.getName();
            if (nameStr.startsWith("uni")) {
                StringBuilder uniStr = new StringBuilder();
                int chPos = 3;
                while (chPos + 4 <= nameStr.length()) {
                    try {
                        int characterCode = Integer.parseInt(nameStr.substring(chPos, chPos + 4), 16);
                        if (characterCode > 55295 && characterCode < 57344) {
                            Logger.getLogger(Encoding.class.getName()).log(Level.WARNING, "Unicode character name with not allowed code area: " + nameStr);
                        } else {
                            uniStr.append((char)characterCode);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Logger.getLogger(Encoding.class.getName()).log(Level.WARNING, "Not a number in Unicode character name: " + nameStr);
                    }
                    chPos += 4;
                }
                character = uniStr.toString();
            } else {
                if (nameStr.indexOf(46) > 0) {
                    nameStr = nameStr.substring(0, nameStr.indexOf(46));
                    baseName = COSName.getPDFName(nameStr);
                    Encoding.getCharacter(baseName);
                }
                character = nameStr;
            }
        }
        return character;
    }

    static {
        File external;
        NAME_TO_CHARACTER = new HashMap<COSName, String>();
        CHARACTER_TO_NAME = new HashMap<String, COSName>();
        Encoding.loadGlyphList("Resources/glyphlist.txt");
        String location = System.getProperty("glyphlist_ext");
        if (location != null && (external = new File(location)).exists()) {
            Encoding.loadGlyphList(location);
        }
        NAME_TO_CHARACTER.put(COSName.getPDFName(".notdef"), "");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fi"), "fi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fl"), "fl");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ffi"), "ffi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ff"), "ff");
        NAME_TO_CHARACTER.put(COSName.getPDFName("pi"), "pi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("angbracketleft"), "\u3008");
        NAME_TO_CHARACTER.put(COSName.getPDFName("angbracketright"), "\u3009");
        NAME_TO_CHARACTER.put(COSName.getPDFName("circlecopyrt"), "\u00a9");
        NAME_TO_CHARACTER.put(COSName.getPDFName("controlNULL"), "\u0000");
        for (Map.Entry<COSName, String> entry : NAME_TO_CHARACTER.entrySet()) {
            CHARACTER_TO_NAME.put(entry.getValue(), entry.getKey());
        }
    }
}

