/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.JaiI18N;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class ImageLayout
implements Cloneable,
Serializable {
    public static final int MIN_X_MASK = 1;
    public static final int MIN_Y_MASK = 2;
    public static final int WIDTH_MASK = 4;
    public static final int HEIGHT_MASK = 8;
    public static final int TILE_GRID_X_OFFSET_MASK = 16;
    public static final int TILE_GRID_Y_OFFSET_MASK = 32;
    public static final int TILE_WIDTH_MASK = 64;
    public static final int TILE_HEIGHT_MASK = 128;
    public static final int SAMPLE_MODEL_MASK = 256;
    public static final int COLOR_MODEL_MASK = 512;
    int minX = 0;
    int minY = 0;
    int width = 0;
    int height = 0;
    int tileGridXOffset = 0;
    int tileGridYOffset = 0;
    int tileWidth = 0;
    int tileHeight = 0;
    transient SampleModel sampleModel = null;
    transient ColorModel colorModel = null;
    protected int validMask = 0;
    static /* synthetic */ Class class$java$awt$image$SampleModel;
    static /* synthetic */ Class class$java$awt$image$ColorModel;

    public ImageLayout() {
    }

    public ImageLayout(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, SampleModel sampleModel, ColorModel colorModel) {
        this.setMinX(n);
        this.setMinY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
        this.setTileGridXOffset(n5);
        this.setTileGridYOffset(n6);
        this.setTileWidth(n7);
        this.setTileHeight(n8);
        if (sampleModel != null) {
            this.setSampleModel(sampleModel);
        }
        if (colorModel != null) {
            this.setColorModel(colorModel);
        }
    }

    public ImageLayout(int n, int n2, int n3, int n4) {
        this.setMinX(n);
        this.setMinY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
    }

    public ImageLayout(int n, int n2, int n3, int n4, SampleModel sampleModel, ColorModel colorModel) {
        this.setTileGridXOffset(n);
        this.setTileGridYOffset(n2);
        this.setTileWidth(n3);
        this.setTileHeight(n4);
        if (sampleModel != null) {
            this.setSampleModel(sampleModel);
        }
        if (colorModel != null) {
            this.setColorModel(colorModel);
        }
    }

    public ImageLayout(RenderedImage renderedImage) {
        this(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset(), renderedImage.getTileWidth(), renderedImage.getTileHeight(), renderedImage.getSampleModel(), renderedImage.getColorModel());
    }

    public int getValidMask() {
        return this.validMask;
    }

    public final boolean isValid(int n) {
        return (this.validMask & n) == n;
    }

    public ImageLayout setValid(int n) {
        this.validMask |= n;
        return this;
    }

    public ImageLayout unsetValid(int n) {
        this.validMask &= ~n;
        return this;
    }

    public ImageLayout unsetImageBounds() {
        this.unsetValid(15);
        return this;
    }

    public ImageLayout unsetTileLayout() {
        this.unsetValid(240);
        return this;
    }

    public int getMinX(RenderedImage renderedImage) {
        if (this.isValid(1)) {
            return this.minX;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getMinX();
    }

    public ImageLayout setMinX(int n) {
        this.minX = n;
        this.setValid(1);
        return this;
    }

    public int getMinY(RenderedImage renderedImage) {
        if (this.isValid(2)) {
            return this.minY;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getMinY();
    }

    public ImageLayout setMinY(int n) {
        this.minY = n;
        this.setValid(2);
        return this;
    }

    public int getWidth(RenderedImage renderedImage) {
        if (this.isValid(4)) {
            return this.width;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getWidth();
    }

    public ImageLayout setWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageLayout0"));
        }
        this.width = n;
        this.setValid(4);
        return this;
    }

    public int getHeight(RenderedImage renderedImage) {
        if (this.isValid(8)) {
            return this.height;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getHeight();
    }

    public ImageLayout setHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageLayout0"));
        }
        this.height = n;
        this.setValid(8);
        return this;
    }

    public int getTileGridXOffset(RenderedImage renderedImage) {
        if (this.isValid(16)) {
            return this.tileGridXOffset;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getTileGridXOffset();
    }

    public ImageLayout setTileGridXOffset(int n) {
        this.tileGridXOffset = n;
        this.setValid(16);
        return this;
    }

    public int getTileGridYOffset(RenderedImage renderedImage) {
        if (this.isValid(32)) {
            return this.tileGridYOffset;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getTileGridYOffset();
    }

    public ImageLayout setTileGridYOffset(int n) {
        this.tileGridYOffset = n;
        this.setValid(32);
        return this;
    }

    public int getTileWidth(RenderedImage renderedImage) {
        if (this.isValid(64)) {
            return this.tileWidth;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getTileWidth();
    }

    public ImageLayout setTileWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageLayout0"));
        }
        this.tileWidth = n;
        this.setValid(64);
        return this;
    }

    public int getTileHeight(RenderedImage renderedImage) {
        if (this.isValid(128)) {
            return this.tileHeight;
        }
        if (renderedImage == null) {
            return 0;
        }
        return renderedImage.getTileHeight();
    }

    public ImageLayout setTileHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageLayout0"));
        }
        this.tileHeight = n;
        this.setValid(128);
        return this;
    }

    public SampleModel getSampleModel(RenderedImage renderedImage) {
        if (this.isValid(256)) {
            return this.sampleModel;
        }
        if (renderedImage == null) {
            return null;
        }
        return renderedImage.getSampleModel();
    }

    public ImageLayout setSampleModel(SampleModel sampleModel) {
        this.sampleModel = sampleModel;
        this.setValid(256);
        return this;
    }

    public ColorModel getColorModel(RenderedImage renderedImage) {
        if (this.isValid(512)) {
            return this.colorModel;
        }
        if (renderedImage == null) {
            return null;
        }
        return renderedImage.getColorModel();
    }

    public ImageLayout setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.setValid(512);
        return this;
    }

    public String toString() {
        String string = "ImageLayout[";
        boolean bl = true;
        if (this.isValid(1)) {
            string = string + "MIN_X=" + this.minX;
            bl = false;
        }
        if (this.isValid(2)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "MIN_Y=" + this.minY;
            bl = false;
        }
        if (this.isValid(4)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "WIDTH=" + this.width;
            bl = false;
        }
        if (this.isValid(8)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "HEIGHT=" + this.height;
            bl = false;
        }
        if (this.isValid(16)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "TILE_GRID_X_OFFSET=" + this.tileGridXOffset;
            bl = false;
        }
        if (this.isValid(32)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "TILE_GRID_Y_OFFSET=" + this.tileGridYOffset;
            bl = false;
        }
        if (this.isValid(64)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "TILE_WIDTH=" + this.tileWidth;
            bl = false;
        }
        if (this.isValid(128)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "TILE_HEIGHT=" + this.tileHeight;
            bl = false;
        }
        if (this.isValid(256)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "SAMPLE_MODEL=" + this.sampleModel;
            bl = false;
        }
        if (this.isValid(512)) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + "COLOR_MODEL=" + this.colorModel;
        }
        string = string + "]";
        return string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.isValid(256)) {
            objectOutputStream.writeObject(SerializerFactory.getState(this.sampleModel, null));
        }
        if (this.isValid(512)) {
            objectOutputStream.writeObject(SerializerFactory.getState(this.colorModel, null));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        SerializableState serializableState;
        Object object;
        objectInputStream.defaultReadObject();
        if (this.isValid(256)) {
            object = objectInputStream.readObject();
            if (!(object instanceof SerializableState)) {
                this.sampleModel = null;
            }
            serializableState = (SerializableState)object;
            clazz = serializableState.getObjectClass();
            this.sampleModel = (class$java$awt$image$SampleModel == null ? (class$java$awt$image$SampleModel = ImageLayout.class$("java.awt.image.SampleModel")) : class$java$awt$image$SampleModel).isAssignableFrom(clazz) ? (SampleModel)serializableState.getObject() : null;
        }
        if (this.isValid(512)) {
            object = objectInputStream.readObject();
            if (!(object instanceof SerializableState)) {
                this.colorModel = null;
            }
            serializableState = (SerializableState)object;
            clazz = serializableState.getObjectClass();
            this.colorModel = (class$java$awt$image$ColorModel == null ? (class$java$awt$image$ColorModel = ImageLayout.class$("java.awt.image.ColorModel")) : class$java$awt$image$ColorModel).isAssignableFrom(clazz) ? (ColorModel)serializableState.getObject() : null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImageLayout)) {
            return false;
        }
        ImageLayout imageLayout = (ImageLayout)object;
        return this.validMask == imageLayout.validMask && this.width == imageLayout.width && this.height == imageLayout.height && this.minX == imageLayout.minX && this.minY == imageLayout.minY && this.tileHeight == imageLayout.tileHeight && this.tileWidth == imageLayout.tileWidth && this.tileGridXOffset == imageLayout.tileGridXOffset && this.tileGridYOffset == imageLayout.tileGridYOffset && this.sampleModel.equals(imageLayout.sampleModel) && this.colorModel.equals(imageLayout.colorModel);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        n += this.width * n2++;
        n += this.height * n2++;
        n += this.minX * n2++;
        n += this.minY * n2++;
        n += this.tileHeight * n2++;
        n += this.tileWidth * n2++;
        n += this.tileGridXOffset * n2++;
        n += this.tileGridYOffset * n2++;
        n ^= this.sampleModel.hashCode();
        n ^= this.validMask;
        return n ^= this.colorModel.hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

