# Generated by default/object.tt
package Paws::AccessAnalyzer::TrailProperties;
  use Moose;
  has AllRegions => (is => 'ro', isa => 'Bool', request_name => 'allRegions', traits => ['NameInRequest']);
  has CloudTrailArn => (is => 'ro', isa => 'Str', request_name => 'cloudTrailArn', traits => ['NameInRequest'], required => 1);
  has Regions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'regions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::TrailProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::TrailProperties object:

  $service_obj->Method(Att1 => { AllRegions => $value, ..., Regions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::TrailProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->AllRegions

=head1 DESCRIPTION

Contains details about the CloudTrail trail being analyzed to generate
a policy.

=head1 ATTRIBUTES


=head2 AllRegions => Bool

Possible values are C<true> or C<false>. If set to C<true>, Access
Analyzer retrieves CloudTrail data from all regions to analyze and
generate a policy.


=head2 B<REQUIRED> CloudTrailArn => Str

Specifies the ARN of the trail. The format of a trail ARN is
C<arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail>.


=head2 Regions => ArrayRef[Str|Undef]

A list of regions to get CloudTrail data from and analyze to generate a
policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

