
package Paws::DocDB::CreateEventSubscription;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool');
  has EventCategories => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SnsTopicArn => (is => 'ro', isa => 'Str', required => 1);
  has SourceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SourceType => (is => 'ro', isa => 'Str');
  has SubscriptionName => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::DocDB::Tag]');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateEventSubscription');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::DocDB::CreateEventSubscriptionResult');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'CreateEventSubscriptionResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::DocDB::CreateEventSubscription - Arguments for method CreateEventSubscription on L<Paws::DocDB>

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateEventSubscription on the
L<Amazon DocumentDB with MongoDB compatibility|Paws::DocDB> service. Use the attributes of this class
as arguments to method CreateEventSubscription.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateEventSubscription.

=head1 SYNOPSIS

    my $rds = Paws->service('DocDB');
    my $CreateEventSubscriptionResult = $rds->CreateEventSubscription(
      SnsTopicArn      => 'MyString',
      SubscriptionName => 'MyString',
      Enabled          => 1,                      # OPTIONAL
      EventCategories  => [ 'MyString', ... ],    # OPTIONAL
      SourceIds        => [ 'MyString', ... ],    # OPTIONAL
      SourceType       => 'MyString',             # OPTIONAL
      Tags             => [
        {
          Key   => 'MyString',
          Value => 'MyString',
        },
        ...
      ],                                          # OPTIONAL
    );

    # Results:
    my $EventSubscription = $CreateEventSubscriptionResult->EventSubscription;

    # Returns a L<Paws::DocDB::CreateEventSubscriptionResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/rds/CreateEventSubscription>

=head1 ATTRIBUTES


=head2 Enabled => Bool

A Boolean value; set to C<true> to activate the subscription, set to
C<false> to create the subscription but not active it.



=head2 EventCategories => ArrayRef[Str|Undef]

A list of event categories for a C<SourceType> that you want to
subscribe to.



=head2 B<REQUIRED> SnsTopicArn => Str

The Amazon Resource Name (ARN) of the SNS topic created for event
notification. Amazon SNS creates the ARN when you create a topic and
subscribe to it.



=head2 SourceIds => ArrayRef[Str|Undef]

The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens; it can't end with a hyphen or
contain two consecutive hyphens.

Constraints:

=over

=item *

If C<SourceIds> are provided, C<SourceType> must also be provided.

=item *

If the source type is an instance, a C<DBInstanceIdentifier> must be
provided.

=item *

If the source type is a security group, a C<DBSecurityGroupName> must
be provided.

=item *

If the source type is a parameter group, a C<DBParameterGroupName> must
be provided.

=item *

If the source type is a snapshot, a C<DBSnapshotIdentifier> must be
provided.

=back




=head2 SourceType => Str

The type of source that is generating the events. For example, if you
want to be notified of events generated by an instance, you would set
this parameter to C<db-instance>. If this value is not specified, all
events are returned.

Valid values: C<db-instance>, C<db-cluster>, C<db-parameter-group>,
C<db-security-group>, C<db-cluster-snapshot>



=head2 B<REQUIRED> SubscriptionName => Str

The name of the subscription.

Constraints: The name must be fewer than 255 characters.



=head2 Tags => ArrayRef[L<Paws::DocDB::Tag>]

The tags to be assigned to the event subscription.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateEventSubscription in L<Paws::DocDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

