# backupfile.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_BACKUPFILE],
[
  dnl Prerequisites of lib/backupfile.c.
  AC_REQUIRE([AC_HEADER_DIRENT])
  AC_REQUIRE([AC_FUNC_CLOSEDIR_VOID])
  AC_CHECK_HEADERS_ONCE(limits.h stdlib.h string.h)
  AC_CHECK_DECLS_ONCE(getenv malloc)
  jm_CHECK_TYPE_STRUCT_DIRENT_D_INO

  dnl Prerequisites of lib/addext.c.
  AC_REQUIRE([jm_AC_DOS])
  AC_SYS_LONG_FILE_NAMES
  AC_CHECK_HEADERS_ONCE(limits.h string.h unistd.h)
  AC_CHECK_FUNCS(pathconf)
])
#serial 5

dnl From Jim Meyering.
dnl
dnl Check whether struct dirent has a member named d_ino.
dnl

AC_DEFUN([jm_CHECK_TYPE_STRUCT_DIRENT_D_INO],
  [AC_REQUIRE([AC_HEADER_DIRENT])dnl
   AC_CACHE_CHECK([for d_ino member in directory struct],
		  jm_cv_struct_dirent_d_ino,
     [AC_TRY_LINK(dnl
       [
#include <sys/types.h>
#ifdef HAVE_DIRENT_H
# include <dirent.h>
#else /* not HAVE_DIRENT_H */
# define dirent direct
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif /* HAVE_SYS_NDIR_H */
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif /* HAVE_SYS_DIR_H */
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif /* HAVE_NDIR_H */
#endif /* HAVE_DIRENT_H */
       ],
       [struct dirent dp; dp.d_ino = 0;],

       jm_cv_struct_dirent_d_ino=yes,
       jm_cv_struct_dirent_d_ino=no)
     ]
   )
   if test $jm_cv_struct_dirent_d_ino = yes; then
     AC_DEFINE(D_INO_IN_DIRENT, 1,
       [Define if there is a member named d_ino in the struct describing
        directory headers.])
   fi
  ]
)
# dirname.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_DIRNAME],
[
  dnl Prerequisites of lib/dirname.h.
  AC_REQUIRE([jm_AC_DOS])

  dnl Prerequisites of lib/dirname.c.
  AC_REQUIRE([AC_HEADER_STDC])
  AC_CHECK_HEADERS_ONCE(string.h)

  dnl Prerequisites of lib/basename.c.
  AC_REQUIRE([AC_HEADER_STDC])
  AC_CHECK_HEADERS_ONCE(string.h)

  dnl Prerequisites of lib/stripslash.c.
  AC_REQUIRE([AC_HEADER_STDC])
  AC_CHECK_HEADERS_ONCE(string.h)
])
#serial 5

# Define some macros required for proper operation of code in lib/*.c
# on MSDOS/Windows systems.

# From Jim Meyering.

AC_DEFUN([jm_AC_DOS],
  [
    AC_CACHE_CHECK([whether system is Windows or MSDOS], [ac_cv_win_or_dos],
      [
        AC_TRY_COMPILE([],
        [#if !defined _WIN32 && !defined __WIN32__ && !defined __MSDOS__
neither MSDOS nor Windows
#endif],
        [ac_cv_win_or_dos=yes],
        [ac_cv_win_or_dos=no])
      ])

    if test x"$ac_cv_win_or_dos" = xyes; then
      ac_fs_accepts_drive_letter_prefix=1
      ac_fs_backslash_is_file_name_separator=1
    else
      ac_fs_accepts_drive_letter_prefix=0
      ac_fs_backslash_is_file_name_separator=0
    fi

    AH_VERBATIM(FILESYSTEM_PREFIX_LEN,
    [#if FILESYSTEM_ACCEPTS_DRIVE_LETTER_PREFIX
# define FILESYSTEM_PREFIX_LEN(Filename) \
  ((Filename)[0] && (Filename)[1] == ':' ? 2 : 0)
#else
# define FILESYSTEM_PREFIX_LEN(Filename) 0
#endif])

    AC_DEFINE_UNQUOTED([FILESYSTEM_ACCEPTS_DRIVE_LETTER_PREFIX],
      $ac_fs_accepts_drive_letter_prefix,
      [Define on systems for which file names may have a so-called
       `drive letter' prefix, define this to compute the length of that
       prefix, including the colon.])

    AH_VERBATIM(ISSLASH,
    [#if FILESYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR
# define ISSLASH(C) ((C) == '/' || (C) == '\\')
#else
# define ISSLASH(C) ((C) == '/')
#endif])

    AC_DEFINE_UNQUOTED([FILESYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR],
      $ac_fs_backslash_is_file_name_separator,
      [Define if the backslash character may also serve as a file name
       component separator.])
  ])
#serial 7

AC_DEFUN([gl_ERROR],
[
  AC_FUNC_ERROR_AT_LINE
  dnl Note: AC_FUNC_ERROR_AT_LINE does AC_LIBSOURCES([error.h, error.c]).
  jm_PREREQ_ERROR
])

# Prerequisites of lib/error.c.
AC_DEFUN([jm_PREREQ_ERROR],
[
  AC_REQUIRE([AC_HEADER_STDC])
  AC_REQUIRE([AC_FUNC_VPRINTF])
  AC_CHECK_FUNCS(strerror)
  AC_CHECK_DECLS([strerror])
  AC_FUNC_STRERROR_R
])
# getopt.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_GETOPT],
[
  dnl Prerequisites of lib/getopt.c.
  AC_CHECK_HEADERS_ONCE(string.h)
])
# malloc.m4 serial 7
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Jim Meyering.
dnl Determine whether malloc accepts 0 as its argument.
dnl If it doesn't, arrange to use the replacement function.

AC_DEFUN([jm_FUNC_MALLOC],
[
  AC_REQUIRE([AC_FUNC_MALLOC])
  dnl autoconf < 2.57 used the symbol ac_cv_func_malloc_works.
  if test X"$ac_cv_func_malloc_0_nonnull" = Xno || test X"$ac_cv_func_malloc_works" = Xno; then
    gl_PREREQ_MALLOC
  fi
])

# Prerequisites of lib/malloc.c.
AC_DEFUN([gl_PREREQ_MALLOC], [
  :
])
# mbrtowc.m4 serial 5
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Paul Eggert

dnl This file can be removed, and jm_FUNC_MBRTOWC replaced with
dnl AC_FUNC_MBRTOWC, when autoconf 2.57 can be assumed everywhere.

AC_DEFUN([jm_FUNC_MBRTOWC],
[
  AC_CACHE_CHECK([whether mbrtowc and mbstate_t are properly declared],
    jm_cv_func_mbrtowc,
    [AC_TRY_LINK(
       [#include <wchar.h>],
       [mbstate_t state; return ! (sizeof state && mbrtowc);],
       jm_cv_func_mbrtowc=yes,
       jm_cv_func_mbrtowc=no)])
  if test $jm_cv_func_mbrtowc = yes; then
    AC_DEFINE(HAVE_MBRTOWC, 1,
      [Define to 1 if mbrtowc and mbstate_t are properly declared.])
  fi
])
# mbstate_t.m4 serial 9
dnl Copyright (C) 2000, 2001, 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# From Paul Eggert.

# BeOS 5 has <wchar.h> but does not define mbstate_t,
# so you can't declare an object of that type.
# Check for this incompatibility with Standard C.

# AC_TYPE_MBSTATE_T
# -----------------
AC_DEFUN([AC_TYPE_MBSTATE_T],
  [AC_CACHE_CHECK([for mbstate_t], ac_cv_type_mbstate_t,
     [AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
	   [AC_INCLUDES_DEFAULT
#	    include <wchar.h>],
	   [mbstate_t x; return sizeof x;])],
	[ac_cv_type_mbstate_t=yes],
	[ac_cv_type_mbstate_t=no])])
   if test $ac_cv_type_mbstate_t = yes; then
     AC_DEFINE([HAVE_MBSTATE_T], 1,
	       [Define to 1 if <wchar.h> declares mbstate_t.])
   else
     AC_DEFINE([mbstate_t], int,
	       [Define to a type if <wchar.h> does not define.])
   fi])
# memchr.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_FUNC_MEMCHR],
[
  AC_REPLACE_FUNCS(memchr)
  if test $ac_cv_func_memchr = no; then
    jm_PREREQ_MEMCHR
  fi
])

# Prerequisites of lib/memchr.c.
AC_DEFUN([jm_PREREQ_MEMCHR], [
  AC_CHECK_HEADERS_ONCE(limits.h stdlib.h)
  AC_CHECK_HEADERS(bp-sym.h)
])
#serial 1

dnl From Mumit Khan and Paul Eggert
dnl Determine whether mkdir accepts only one argument instead of the usual two.

AC_DEFUN([PATCH_FUNC_MKDIR_TAKES_ONE_ARG],
  [AC_CHECK_FUNCS(mkdir)
   AC_CACHE_CHECK([whether mkdir takes only one argument],
     patch_cv_mkdir_takes_one_arg,
     [patch_cv_mkdir_takes_one_arg=no
      if test $ac_cv_func_mkdir = yes; then
        AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/stat.h>
	  ],
	  [mkdir (".", 0);],
	  ,
	  [AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/stat.h>
	     ],
	     [mkdir (".");],
	     patch_cv_mkdir_takes_one_arg=yes
	  )]
	)
      fi
     ]
   )
   if test $patch_cv_mkdir_takes_one_arg = yes; then
     AC_DEFINE([MKDIR_TAKES_ONE_ARG], 1,
       [Define if mkdir takes only one argument.])
   fi
  ]
)
# onceonly.m4 serial 3
dnl Copyright (C) 2002, 2003 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl This file defines some "once only" variants of standard autoconf macros.
dnl   AC_CHECK_HEADERS_ONCE         like  AC_CHECK_HEADERS
dnl   AC_CHECK_FUNCS_ONCE           like  AC_CHECK_FUNCS
dnl   AC_CHECK_DECLS_ONCE           like  AC_CHECK_DECLS
dnl   AC_REQUIRE([AC_HEADER_STDC])  like  AC_HEADER_STDC
dnl The advantage is that the check for each of the headers/functions/decls
dnl will be put only once into the 'configure' file. It keeps the size of
dnl the 'configure' file down, and avoids redundant output when 'configure'
dnl is run.
dnl The drawback is that the checks cannot be conditionalized. If you write
dnl   if some_condition; then gl_CHECK_HEADERS(stdlib.h); fi
dnl inside an AC_DEFUNed function, the gl_CHECK_HEADERS macro call expands to
dnl empty, and the check will be inserted before the body of the AC_DEFUNed
dnl function.

dnl Autoconf version 2.57 or newer is recommended.
AC_PREREQ(2.54)

# AC_CHECK_HEADERS_ONCE(HEADER1 HEADER2 ...) is a once-only variant of
# AC_CHECK_HEADERS(HEADER1 HEADER2 ...).
AC_DEFUN([AC_CHECK_HEADERS_ONCE], [
  :
  AC_FOREACH([gl_HEADER_NAME], [$1], [
    AC_DEFUN([gl_CHECK_HEADER_]m4_quote(translit(m4_defn([gl_HEADER_NAME]),
                                                 [-./], [___])), [
      AC_CHECK_HEADERS(gl_HEADER_NAME)
    ])
    AC_REQUIRE([gl_CHECK_HEADER_]m4_quote(translit(gl_HEADER_NAME,
                                                   [-./], [___])))
  ])
])

# AC_CHECK_FUNCS_ONCE(FUNC1 FUNC2 ...) is a once-only variant of
# AC_CHECK_FUNCS(FUNC1 FUNC2 ...).
AC_DEFUN([AC_CHECK_FUNCS_ONCE], [
  :
  AC_FOREACH([gl_FUNC_NAME], [$1], [
    AC_DEFUN([gl_CHECK_FUNC_]m4_defn([gl_FUNC_NAME]), [
      AC_CHECK_FUNCS(m4_defn([gl_FUNC_NAME]))
    ])
    AC_REQUIRE([gl_CHECK_FUNC_]m4_defn([gl_FUNC_NAME]))
  ])
])

# AC_CHECK_DECLS_ONCE(DECL1 DECL2 ...) is a once-only variant of
# AC_CHECK_DECLS(DECL1, DECL2, ...).
AC_DEFUN([AC_CHECK_DECLS_ONCE], [
  :
  AC_FOREACH([gl_DECL_NAME], [$1], [
    AC_DEFUN([gl_CHECK_DECL_]m4_defn([gl_DECL_NAME]), [
      AC_CHECK_DECLS(m4_defn([gl_DECL_NAME]))
    ])
    AC_REQUIRE([gl_CHECK_DECL_]m4_defn([gl_DECL_NAME]))
  ])
])
# quote.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_QUOTE],
[
  dnl Prerequisites of lib/quote.c.
  AC_CHECK_HEADERS_ONCE(stddef.h)
])
# quotearg.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_QUOTEARG],
[
  dnl Prerequisites of lib/quotearg.c.
  AC_CHECK_HEADERS_ONCE(wchar.h wctype.h)
  AC_CHECK_FUNCS_ONCE(iswprint mbsinit)
  AC_TYPE_MBSTATE_T
  jm_FUNC_MBRTOWC
])
# realloc.m4 serial 7
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Jim Meyering.
dnl Determine whether realloc works when both arguments are 0.
dnl If it doesn't, arrange to use the replacement function.

AC_DEFUN([jm_FUNC_REALLOC],
[
  AC_REQUIRE([AC_FUNC_REALLOC])
  dnl autoconf < 2.57 used the symbol ac_cv_func_realloc_works.
  if test X"$ac_cv_func_realloc_0_nonnull" = Xno || test X"$ac_cv_func_realloc_works" = Xno; then
    gl_PREREQ_REALLOC
  fi
])

# Prerequisites of lib/realloc.c.
AC_DEFUN([gl_PREREQ_REALLOC], [
  :
])
# rmdir.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_FUNC_RMDIR],
[
  AC_REPLACE_FUNCS(rmdir)
  if test $ac_cv_func_rmdir = no; then
    gl_PREREQ_RMDIR
  fi
])

# Prerequisites of lib/rmdir.c.
AC_DEFUN([gl_PREREQ_RMDIR], [
  AC_REQUIRE([AC_HEADER_STAT])
  :
])

# Check for setmode, DOS style.

# Copyright (C) 2001, 2002 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

AC_DEFUN([AC_FUNC_SETMODE_DOS],
  [AC_CHECK_HEADERS(fcntl.h unistd.h)
   AC_CACHE_CHECK([for DOS-style setmode],
     [ac_cv_func_setmode_dos],
     [AC_TRY_LINK(
	[#include <io.h>
	 #if HAVE_FCNTL_H
	 # include <fcntl.h>
	 #endif
	 #if HAVE_UNISTD_H
	 # include <unistd.h>
	 #endif],
	[int ret = setmode && setmode (1, O_BINARY);],
	[ac_cv_func_setmode_dos=yes],
	[ac_cv_func_setmode_dos=no])])
   if test $ac_cv_func_setmode_dos = yes; then
     AC_DEFINE(HAVE_SETMODE_DOS, 1,
       [Define to 1 if you have the DOS-style `setmode' function.])
   fi])
# Check for stdbool.h that conforms to C99.

# Copyright (C) 2002-2003 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# Prepare for substituting <stdbool.h> if it is not supported.

AC_DEFUN([AM_STDBOOL_H],
[
  AC_REQUIRE([AC_HEADER_STDBOOL])

  # Define two additional variables used in the Makefile substitution.

  if test "$ac_cv_header_stdbool_h" = yes; then
    STDBOOL_H=''
  else
    STDBOOL_H='stdbool.h'
  fi
  AC_SUBST([STDBOOL_H])

  if test "$ac_cv_type__Bool" = yes; then
    HAVE__BOOL=1
  else
    HAVE__BOOL=0
  fi
  AC_SUBST([HAVE__BOOL])
])

# This macro is only needed in autoconf <= 2.54.  Newer versions of autoconf
# have this macro built-in.

AC_DEFUN([AC_HEADER_STDBOOL],
  [AC_CACHE_CHECK([for stdbool.h that conforms to C99],
     [ac_cv_header_stdbool_h],
     [AC_TRY_COMPILE(
	[
	  #include <stdbool.h>
	  #ifndef bool
	   "error: bool is not defined"
	  #endif
	  #ifndef false
	   "error: false is not defined"
	  #endif
	  #if false
	   "error: false is not 0"
	  #endif
	  #ifndef true
	   "error: false is not defined"
	  #endif
	  #if true != 1
	   "error: true is not 1"
	  #endif
	  #ifndef __bool_true_false_are_defined
	   "error: __bool_true_false_are_defined is not defined"
	  #endif

	  struct s { _Bool s: 1; _Bool t; } s;

	  char a[true == 1 ? 1 : -1];
	  char b[false == 0 ? 1 : -1];
	  char c[__bool_true_false_are_defined == 1 ? 1 : -1];
	  char d[(bool) -0.5 == true ? 1 : -1];
	  bool e = &s;
	  char f[(_Bool) -0.0 == false ? 1 : -1];
	  char g[true];
	  char h[sizeof (_Bool)];
	  char i[sizeof s.t];
	],
	[ return !a + !b + !c + !d + !e + !f + !g + !h + !i; ],
	[ac_cv_header_stdbool_h=yes],
	[ac_cv_header_stdbool_h=no])])
   AC_CHECK_TYPES([_Bool])
   if test $ac_cv_header_stdbool_h = yes; then
     AC_DEFINE(HAVE_STDBOOL_H, 1, [Define to 1 if stdbool.h conforms to C99.])
   fi])
#serial 7 -*- autoconf -*-

dnl From Jim Meyering.
dnl
dnl See if the glibc *_unlocked I/O macros or functions are available.
dnl Use only those *_unlocked macros or functions that are declared
dnl (because some of them were declared in Solaris 2.5.1 but were removed
dnl in Solaris 2.6, whereas we want binaries built on Solaris 2.5.1 to run
dnl on Solaris 2.6).

AC_DEFUN([jm_FUNC_GLIBC_UNLOCKED_IO],
[
  dnl Persuade glibc <stdio.h> to declare fgets_unlocked(), fputs_unlocked()
  dnl etc.
  AC_REQUIRE([AC_GNU_SOURCE])

  AC_CHECK_DECLS_ONCE(
     [clearerr_unlocked feof_unlocked ferror_unlocked
      fflush_unlocked fgets_unlocked fputc_unlocked fputs_unlocked
      fread_unlocked fwrite_unlocked getc_unlocked
      getchar_unlocked putc_unlocked putchar_unlocked])
])
#serial 5

dnl From Jim Meyering

dnl Define HAVE_STRUCT_UTIMBUF if `struct utimbuf' is declared --
dnl usually in <utime.h>.
dnl Some systems have utime.h but don't declare the struct anywhere.

AC_DEFUN([jm_CHECK_TYPE_STRUCT_UTIMBUF],
[
  AC_CHECK_HEADERS_ONCE(sys/time.h utime.h)
  AC_REQUIRE([AC_HEADER_TIME])
  AC_CACHE_CHECK([for struct utimbuf], fu_cv_sys_struct_utimbuf,
    [AC_TRY_COMPILE(
      [
#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef HAVE_UTIME_H
# include <utime.h>
#endif
      ],
      [static struct utimbuf x; x.actime = x.modtime;],
      fu_cv_sys_struct_utimbuf=yes,
      fu_cv_sys_struct_utimbuf=no)
    ])

  if test $fu_cv_sys_struct_utimbuf = yes; then
    AC_DEFINE(HAVE_STRUCT_UTIMBUF, 1,
      [Define if struct utimbuf is declared -- usually in <utime.h>.
       Some systems have utime.h but don't declare the struct anywhere. ])
  fi
])
# xalloc.m4 serial 1
dnl Copyright (C) 2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_XALLOC],
[
  gl_PREREQ_XMALLOC
  gl_PREREQ_XSTRDUP
])

# Prerequisites of lib/xmalloc.c.
AC_DEFUN([gl_PREREQ_XMALLOC], [
  AC_REQUIRE([AC_HEADER_STDC])
  AC_REQUIRE([jm_FUNC_MALLOC])
  AC_REQUIRE([jm_FUNC_REALLOC])
])

# Prerequisites of lib/xstrdup.c.
AC_DEFUN([gl_PREREQ_XSTRDUP], [
  AC_REQUIRE([AC_HEADER_STDC])
  AC_CHECK_HEADERS_ONCE(string.h)
])
