package Venus::Role::Testable;

use 5.018;

use strict;
use warnings;

use Moo::Role;

# METHODS

sub isfalse {
  my ($self, $code, @args) = @_;

  $code ||= $self->can('value') ? 'value' : sub{};

  require Venus::Boolean;

  return $self->$code(@args) ? Venus::Boolean::FALSE() : Venus::Boolean::TRUE();
}

sub istrue {
  my ($self, $code, @args) = @_;

  $code ||= $self->can('value') ? 'value' : sub{};

  require Venus::Boolean;

  return $self->$code(@args) ? Venus::Boolean::TRUE() : Venus::Boolean::FALSE();
}

1;



=head1 NAME

Venus::Role::Testable - Testable Role

=cut

=head1 ABSTRACT

Testable Role for Perl 5

=cut

=head1 SYNOPSIS

  package Example;

  use Venus::Class;

  with 'Venus::Role::Testable';

  has 'value';

  sub execute {
    return pop;
  }

  package main;

  my $example = Example->new;

  # $example->istrue(sub{0});

=cut

=head1 DESCRIPTION

This package modifies the consuming package and provides methods for
dispatching method calls and returning truthy returns as true and falsy returns
as false boolean values.

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 isfalse

  isfalse(Str | CodeRef $method, Any @args) (Bool)

The isfalse method dispatches the method call or executes the callback and
returns truthy returns as C<false> and falsy returns as C<true>
L<"boolean"|Venus::Boolean> values.

I<Since C<0.08>>

=over 4

=item isfalse example 1

  package main;

  my $example = Example->new;

  my $true = $example->isfalse(execute => 0);

  # 1

=back

=over 4

=item isfalse example 2

  package main;

  my $example = Example->new;

  my $true = $example->isfalse(sub{0});

  # 1

=back

=over 4

=item isfalse example 3

  package main;

  my $example = Example->new;

  my $false = $example->isfalse(execute => 1);

  # 0

=back

=cut

=head2 istrue

  istrue(Str | CodeRef $method, Any @args) (Bool)

The istrue method dispatches the method call or executes the callback and
returns truthy returns as C<true> and falsy returns as C<false>
L<"boolean"|Venus::Boolean> values.

I<Since C<0.08>>

=over 4

=item istrue example 1

  package main;

  my $example = Example->new;

  my $true = $example->istrue(execute => 1);

  # 1

=back

=over 4

=item istrue example 2

  package main;

  my $example = Example->new;

  my $true = $example->istrue(sub{1});

  # 1

=back

=over 4

=item istrue example 3

  package main;

  my $example = Example->new;

  my $false = $example->istrue(execute => 0);

  # 0

=back

=cut