use Test::More;
use POSIX qw( strtod );
use Feed::PhaseCheck qw(compare_feeds);
use strict;
use warnings;

my $main = {
    "1451276629" => "1.09765",
    "1451276630" => "1.09764916666667",
    "1451276631" => "1.09764833333333",
    "1451276632" => "1.0976475",
    "1451276633" => "1.09764666666667",
    "1451276634" => "1.09764583333333",
    "1451276635" => "1.097645",
    "1451276636" => "1.09764416666667",
    "1451276637" => "1.09764333333333",
    "1451276638" => "1.0976425",
    "1451276639" => "1.09764166666667",
    "1451276640" => "1.09764083333333",
    "1451276641" => "1.09764",
    "1451276642" => "1.097635",
    "1451276643" => "1.09764",
    "1451276644" => "1.097645",
    "1451276645" => "1.0976445",
    "1451276646" => "1.097644",
    "1451276647" => "1.0976435",
    "1451276648" => "1.097643",
    "1451276649" => "1.0976425",
    "1451276650" => "1.097642",
    "1451276651" => "1.0976415",
    "1451276652" => "1.097641",
    "1451276653" => "1.0976405",
    "1451276654" => "1.09764",
    "1451276655" => "1.097645",
    "1451276656" => "1.097645",
    "1451276657" => "1.097645",
    "1451276658" => "1.09764428571429",
    "1451276659" => "1.09764357142857",
    "1451276660" => "1.09764285714286",
    "1451276661" => "1.09764214285714",
    "1451276662" => "1.09764142857143",
    "1451276663" => "1.09764071428571",
    "1451276664" => "1.09764",
    "1451276665" => "1.09763928571429",
    "1451276666" => "1.09763857142857",
    "1451276667" => "1.09763785714286",
    "1451276668" => "1.09763714285714",
    "1451276669" => "1.09763642857143",
    "1451276670" => "1.09763571428571",
    "1451276671" => "1.097635",
    "1451276672" => "1.09764",
    "1451276673" => "1.097645",
    "1451276674" => "1.09764",
    "1451276675" => "1.097645",
    "1451276676" => "1.09765",
    "1451276677" => "1.097655",
    "1451276678" => "1.0976546",
    "1451276679" => "1.0976542",
    "1451276680" => "1.0976538",
    "1451276681" => "1.0976534",
    "1451276682" => "1.097653",
    "1451276683" => "1.0976526",
    "1451276684" => "1.0976522",
    "1451276685" => "1.0976518",
    "1451276686" => "1.0976514",
    "1451276687" => "1.097651",
    "1451276688" => "1.0976506",
    "1451276689" => "1.0976502",
    "1451276690" => "1.0976498",
    "1451276691" => "1.0976494",
    "1451276692" => "1.097649",
    "1451276693" => "1.0976486",
    "1451276694" => "1.0976482",
    "1451276695" => "1.0976478",
    "1451276696" => "1.0976474",
    "1451276697" => "1.097647",
    "1451276698" => "1.0976466",
    "1451276699" => "1.0976462",
    "1451276700" => "1.0976458",
    "1451276701" => "1.0976454",
    "1451276702" => "1.097645",
    "1451276703" => "1.09764447368421",
    "1451276704" => "1.09764394736842",
    "1451276705" => "1.09764342105263",
    "1451276706" => "1.09764289473684",
    "1451276707" => "1.09764236842105",
    "1451276708" => "1.09764184210526",
    "1451276709" => "1.09764131578947",
    "1451276710" => "1.09764078947368",
    "1451276711" => "1.09764026315789",
    "1451276712" => "1.09763973684211",
    "1451276713" => "1.09763921052632",
    "1451276714" => "1.09763868421053",
    "1451276715" => "1.09763815789474",
    "1451276716" => "1.09763763157895",
    "1451276717" => "1.09763710526316",
    "1451276718" => "1.09763657894737",
    "1451276719" => "1.09763605263158",
    "1451276720" => "1.09763552631579",
    "1451276721" => "1.097635",
    "1451276722" => "1.0976",
    "1451276723" => "1.09759",
    "1451276724" => "1.09759",
    "1451276725" => "1.09759",
    "1451276726" => "1.09759",
    "1451276727" => "1.09759",
    "1451276728" => "1.09759",
    "1451276729" => "1.09759",
    "1451276730" => "1.09759",
    "1451276731" => "1.09759",
    "1451276732" => "1.09759",
    "1451276733" => "1.09759",
    "1451276734" => "1.09759",
    "1451276735" => "1.09759",
    "1451276736" => "1.09759",
    "1451276737" => "1.09759",
    "1451276738" => "1.09759",
    "1451276739" => "1.09759",
    "1451276740" => "1.09759",
    "1451276741" => "1.09759",
    "1451276742" => "1.09759",
    "1451276743" => "1.09759",
    "1451276744" => "1.09759",
    "1451276745" => "1.09759",
    "1451276746" => "1.09759",
    "1451276747" => "1.09759",
    "1451276748" => "1.09759",
    "1451276749" => "1.09759",
    "1451276750" => "1.09759",
    "1451276751" => "1.09759",
    "1451276752" => "1.09759",
    "1451276753" => "1.09759",
    "1451276754" => "1.09759",
    "1451276755" => "1.09759166666667",
    "1451276756" => "1.09759333333333",
    "1451276757" => "1.097595",
    "1451276758" => "1.0975925",
    "1451276759" => "1.09759",
    "1451276760" => "1.09759333333333",
    "1451276761" => "1.09759666666667",
    "1451276762" => "1.0976",
    "1451276763" => "1.097595",
    "1451276764" => "1.097595",
    "1451276765" => "1.097595",
    "1451276766" => "1.097595",
    "1451276767" => "1.097595",
    "1451276768" => "1.097595",
    "1451276769" => "1.097595",
    "1451276770" => "1.097595",
    "1451276771" => "1.097595",
    "1451276772" => "1.097595",
    "1451276773" => "1.097595",
    "1451276774" => "1.097595",
    "1451276775" => "1.097595",
    "1451276776" => "1.097595",
    "1451276777" => "1.097595",
    "1451276778" => "1.097595",
    "1451276779" => "1.097595",
    "1451276780" => "1.097595",
    "1451276781" => "1.097595",
    "1451276782" => "1.097595",
    "1451276783" => "1.097595",
    "1451276784" => "1.097595",
    "1451276785" => "1.097595",
    "1451276786" => "1.097595",
    "1451276787" => "1.097595",
    "1451276788" => "1.097595",
    "1451276789" => "1.097595",
    "1451276790" => "1.097595",
    "1451276791" => "1.097595",
    "1451276792" => "1.097595"
};

my $sample = {
    "1451276654" => "1.097655",
    "1451276655" => "1.09765",
    "1451276656" => "1.097655",
    "1451276657" => "1.097625",
    "1451276671" => "1.09763",
    "1451276672" => "1.097625",
    "1451276674" => "1.09764",
    "1451276677" => "1.09765",
    "1451276678" => "1.097655",
    "1451276697" => "1.097655",
    "1451276702" => "1.09765",
    "1451276703" => "1.09764",
    "1451276717" => "1.097625",
    "1451276721" => "1.09763",
    "1451276722" => "1.097585",
    "1451276723" => "1.097595",
    "1451276724" => "1.0976",
    "1451276729" => "1.097595",
    "1451276730" => "1.0976",
    "1451276754" => "1.097585",
    "1451276757" => "1.09759",
    "1451276759" => "1.097585",
    "1451276760" => "1.09759",
    "1451276762" => "1.097595",
    "1451276763" => "1.0976",
    "1451276764" => "1.097595"
};

my $result = {
    '-25' => '1.42320877684933e-08',
    '-6'  => '5.87003643927162e-09',
    '-7'  => '5.92960770027616e-09',
    '7'   => '8.20118750058878e-09',
    '3'   => '7.22041294878286e-09',
    '5'   => '7.47659345992565e-09',
    '-24' => '1.16841199999834e-08',
    '28'  => '1.66375368480699e-08',
    '12'  => '1.24871762227196e-08',
    '-5'  => '5.06987108387202e-09',
    '-23' => '1.17153443766931e-08',
    '-3'  => '3.83235934228907e-09',
    '9'   => '1.1314397636982e-08',
    '-21' => '1.18582951799789e-08',
    '2'   => '5.87660224588642e-09',
    '22'  => '1.4655247974267e-08',
    '-17' => '5.88358792227366e-09',
    '-10' => '5.91627246536542e-09',
    '20'  => '1.39674160557861e-08',
    '18'  => '1.34356254912369e-08',
    '-4'  => '4.0501176066697e-09',
    '14'  => '1.30030812517481e-08',
    '11'  => '1.19578561667302e-08',
    '-2'  => '3.60726804795297e-09',
    '-9'  => '5.90133682409415e-09',
    '4'   => '7.42084366170087e-09',
    '23'  => '1.5154775585743e-08',
    '6'   => '7.84669012101644e-09',
    '-8'  => '6.01874486543873e-09',
    '27'  => '1.65043106963938e-08',
    '13'  => '1.28621864357623e-08',
    '15'  => '1.29423941153097e-08',
    '-16' => '6.28255262589227e-09',
    '21'  => '1.42798725386758e-08',
    '25'  => '1.58762915756715e-08',
    '-19' => '7.5587820497636e-09',
    '-1'  => '2.75907601489926e-09',
    '-12' => '5.96817479574774e-09',
    '24'  => '1.54549567864786e-08',
    '26'  => '1.63298699535131e-08',
    '19'  => '1.37093737784413e-08',
    '8'   => '9.85757425987087e-09',
    '-20' => '1.09693816065723e-08',
    '16'  => '1.32598476778636e-08',
    '-22' => '1.1774842770025e-08',
    '-14' => '6.04945185622769e-09',
    '1'   => '4.10705890300792e-09',
    '17'  => '1.33648276755877e-08',
    '-11' => '5.93855178895727e-09',
    '0'   => '1.91682235765135e-09',
    '-18' => '5.93482404418877e-09',
    '10'  => '1.15697262682651e-08',
    '-15' => '6.23988141994081e-09',
    '-13' => '6.00514148439479e-09'
};

my $max_delay_check = 30;    # seconds
my ($errors, $delay) = compare_feeds($sample, $main, $max_delay_check);

foreach (keys %$result) {
    is_approx_num($result->{$_}, $errors->{$_}, 'Error Calculation Failed', '5%');
}
done_testing();

sub is_approx_num {
    my ($num1, $num2, $msg, $tolerance) = @_;

    $num1 =~ /^(\d+).+?e-(\d+)/;
    my ($val1, $e1) = ($1, $2);

    $num2 =~ /^(\d+).+?e-(\d+)/;
    my ($val2, $e2) = ($1, $2);

    unless (ok($val1 == $val2 && $e1 == $e2, $msg)) {
        diag("'$num1' =~ '$num2'");
    }
}
