package Search::Elasticsearch::Plugin::Watcher;

use Moo;
with 'Search::Elasticsearch::Plugin::Watcher::API';
with 'Search::Elasticsearch::Role::Client::Direct';
__PACKAGE__->_install_api('watcher');

use Search::Elasticsearch 2.00 ();

our $VERSION = '2.03';

#===================================
sub _init_plugin {
#===================================
    my ( $class, $params ) = @_;

    Moo::Role->apply_roles_to_object( $params->{client},
        qw(Search::Elasticsearch::Plugin::Watcher::Namespace) );
}

package Search::Elasticsearch::Plugin::Watcher::Namespace;

use Moo::Role;

has 'watcher' => ( is => 'lazy', init_arg => undef );

sub _build_watcher {
    shift->_build_namespace('+Search::Elasticsearch::Plugin::Watcher');
}

1;

=pod

=encoding UTF-8

=head1 NAME

Search::Elasticsearch::Plugin::Watcher - DEPRECATED Plugin providing Watcher API for Search::Elasticsearch

=head1 VERSION

version 2.03

=head1 DESCRIPTION

See L<Search::Elasticsearch::Plugin::XPack> instead.

=head1 AUTHOR

Clinton Gormley <drtech@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Elasticsearch BV.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut

__END__

# ABSTRACT: DEPRECATED Plugin providing Watcher API for Search::Elasticsearch

