package Business::EDI::CodeList::CodeListResponsibleAgencyCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {3055;}
my $usage       = 'C';

# *    3055  Code list responsible agency code                       [C]
# Desc: Code specifying the agency responsible for a code
# list.
# Repr: an..3

my %code_hash = (
'1' => [ 'CCC (Customs Co-operation Council)',
    'Customs Co-operation Council (now World Customs Organization).' ],
'2' => [ 'CEC (Commission of the European Communities)',
    'Generic: see also 140, 141, 142, 162.' ],
'3' => [ 'IATA (International Air Transport Association)',
    "The airline industry's international organisation." ],
'4' => [ 'ICC (International Chamber of Commerce)',
    'International Chamber of Commerce.' ],
'5' => [ 'ISO (International Organization for Standardization)',
    'International Organization of Standardization.' ],
'6' => [ 'UN/ECE (United Nations - Economic Commission for Europe)',
    'United Nations Economic Commission for Europe.' ],
'7' => [ "CEFIC (Conseil Europeen des Federations de l'Industrie",
    'Chimique) EDI project for chemical industry.' ],
'8' => [ 'EDIFICE',
    'Standardised electronic commerce forum for companies with interests in computing, electronics and telecommunications.' ],
'9' => [ 'GS1',
    'GS1 (formerly EAN International), an organisation of GS1 Member Organisations, which manages the GS1 System.' ],
'10' => [ 'ODETTE',
    'Organization for Data Exchange through Tele-Transmission in Europe (European automotive industry project).' ],
'11' => [ "Lloyd's register of shipping",
    "A register of ocean going vessels maintained by Lloyd's of London." ],
'12' => [ 'UIC (International union of railways)',
    'International Union of Railways.' ],
'13' => [ 'ICAO (International Civil Aviation Organization)',
    'International Civil Aviation Organization.' ],
'14' => [ 'ICS (International Chamber of Shipping)',
    'International Chamber of Shipping.' ],
'15' => [ 'RINET (Reinsurance and Insurance Network)',
    'Reinsurance and Insurance Network.' ],
'16' => [ 'US, D&B (Dun & Bradstreet Corporation)',
    'Identifies the Dun & Bradstreet Corporation, United States.' ],
'17' => [ 'S.W.I.F.T.',
    'Society for Worldwide Interbank Financial Telecommunications s.c.' ],
'18' => [ 'Conventions on SAD and transit (EC and EFTA)',
    'SAD = Single Administrative Document.' ],
'19' => [ 'FRRC (Federal Reserve Routing Code)',
    'Federal Reserve Routing Code.' ],
'20' => [ 'BIC (Bureau International des Containeurs)',
    "The container industry's international organisation responsible for the issuance of container-related codes." ],
'21' => [ 'Assigned by transport company',
    'Codes assigned by a transport company.' ],
'22' => [ 'US, ISA (Information Systems Agreement)',
    'Codes assigned by the ISA for use by its members.' ],
'23' => [ 'FR, EDITRANSPORT',
    'French association developing EDI in transport logistics.' ],
'24' => [ 'AU, ROA (Railways of Australia)',
    'Maintains code lists which are accepted by Australian government railways.' ],
'25' => [ 'EDITEX (Europe)',
    'EDI group for the textile and clothing industry.' ],
'26' => [ 'NL, Foundation Uniform Transport Code',
    'Foundation Uniform Transport Code is the EDI organisation for shippers, carriers and other logistic service providers in the Netherlands.' ],
'27' => [ 'US, FDA (Food and Drug Administration)',
    'U.S. food and drug administration.' ],
'28' => [ 'EDITEUR (European book sector electronic data interchange',
    'group) Code identifying the pan European user group for the book industry as an organisation responsible for code values in the book industry.' ],
'29' => [ 'GB, FLEETNET',
    'Association of fleet vehicle hiring and leasing companies in the UK.' ],
'30' => [ 'GB, ABTA (Association of British Travel Agencies)',
    'ABTA, Association of British Travel Agencies.' ],
'31' => [ 'FI, Finish State Railway',
    'Finish State Railway.' ],
'32' => [ 'PL, Polish State Railway',
    'Polish State Railway.' ],
'33' => [ 'BG, Bulgaria State Railway',
    'Bulgaria State Railway.' ],
'34' => [ 'RO, Rumanian State Railway',
    'Rumanian State Railway.' ],
'35' => [ 'CZ, Tchechian State Railway',
    'Tchechian State Railway.' ],
'36' => [ 'HU, Hungarian State Railway',
    'Hungarian State Railway.' ],
'37' => [ 'GB, British Railways',
    'British Railways.' ],
'38' => [ 'ES, Spanish National Railway',
    'Spanish National Railway.' ],
'39' => [ 'SE, Swedish State Railway',
    'Swedish State Railway.' ],
'40' => [ 'NO, Norwegian State Railway',
    'Norwegian State Railway.' ],
'41' => [ 'DE, German Railway',
    'German Railway.' ],
'42' => [ 'AT, Austrian Federal Railways',
    'Austrian Federal Railways.' ],
'43' => [ 'LU, Luxembourg National Railway Company',
    'Luxembourg National Railway Company.' ],
'44' => [ 'IT, Italian State Railways',
    'Italian State Railways.' ],
'45' => [ 'NL, Netherlands Railways',
    'Netherlands Railways.' ],
'46' => [ 'CH, Swiss Federal Railways',
    'Swiss Federal Railways.' ],
'47' => [ 'DK, Danish State Railways',
    'Danish State Railways.' ],
'48' => [ 'FR, French National Railway Company',
    'French National Railway Company.' ],
'49' => [ 'BE, Belgian National Railway Company',
    'Belgian National Railway Company.' ],
'50' => [ 'PT, Portuguese Railways',
    'Portuguese Railways.' ],
'51' => [ 'SK, Slovakian State Railways',
    'Slovakian State Railways.' ],
'52' => [ 'IE, Irish Transport Company',
    'Irish Transport Company.' ],
'53' => [ 'FIATA (International Federation of Freight Forwarders',
    'Associations) International Federation of Freight Forwarders Associations.' ],
'54' => [ 'IMO (International Maritime Organisation)',
    'International Maritime Organisation.' ],
'55' => [ 'US, DOT (United States Department of Transportation)',
    'United States Department of Transportation.' ],
'56' => [ 'TW, Trade-van',
    'Trade-van is an EDI/VAN service centre for customs, transport, and insurance in national and international trade.' ],
'57' => [ 'TW, Chinese Taipei Customs',
    'Customs authorities of Chinese Taipei responsible for collecting import duties and preventing smuggling.' ],
'58' => [ 'EUROFER',
    'European steel organisation - EDI project for the European steel industry.' ],
'59' => [ 'DE, EDIBAU',
    'National body responsible for the German codification in the construction area.' ],
'60' => [ 'Assigned by national trade agency',
    'The code list is from a national agency.' ],
'61' => [ 'Association Europeenne des Constructeurs de Materiel',
    'Aerospatial (AECMA) A code to identify the Association Europeenne des Constructeurs de Materiel Aeropsatial (European Association of Aerospace Products Manufacturers) as an authorizing agency for code lists.' ],
'62' => [ 'US, DIstilled Spirits Council of the United States (DISCUS)',
    'United States DIstilled Spirits Council of the United States (DISCUS).' ],
'63' => [ 'North Atlantic Treaty Organization (NATO)',
    'A code to identify the North Atlantic Treaty Organization (NATO) as an authorizing agency for code lists.' ],
'64' => [ 'FR, EDIFRANCE',
    'French association responsible for coordination and promotion of EDI application in France.' ],
'65' => [ 'GS1 France',
    'Organisation responsible for the GS1 System in France.' ],
'66' => [ 'MY, Malaysian Customs and Excise',
    'Malaysia Royal Customs and Excise.' ],
'67' => [ 'MY, Malaysia Central Bank',
    'Malaysia Central Bank is a regulatory body set up by the government to charge with promoting economic monetary and credit condition favourable to commercial and industrial activity.' ],
'68' => [ 'GS1 Italy',
    'Organisation responsible for the GS1 System in Italy.' ],
'69' => [ 'US, National Alcohol Beverage Control Association (NABCA)',
    'United States National Alcohol Beverage Control Association (NABCA).' ],
'70' => [ 'MY, Dagang.Net',
    'Malaysia, Dagang.Net is a national clearing house which provide EDI/VAN service for customs, transport, retail and financial and other industries in the national and international trade.' ],
'71' => [ 'US, FCC (Federal Communications Commission)',
    'A code representing the United States Federal Communication Commission (FCC).' ],
'72' => [ 'US, MARAD (Maritime Administration)',
    'A code representing the United States Maritime Administration (MARAD) under the Department of Transportation (DOT).' ],
'73' => [ 'US, DSAA (Defense Security Assistance Agency)',
    'A code representing the United States Defense Security Assistance Agency (DSAA) under the Department of Defense (DOD).' ],
'74' => [ 'US, NRC (Nuclear Regulatory Commission)',
    'A code representing the United States Nuclear Regulatory Commission (NRC).' ],
'75' => [ 'US, ODTC (Office of Defense Trade Controls)',
    'A code representing the United States Office of Defense Trade Controls (ODTC) under the Department of State.' ],
'76' => [ 'US, ATF (Bureau of Alcohol, Tobacco and Firearms)',
    'A code representing the United States Bureau of Alcohol, Tobacco and Firearms, Department of Treasury (ATF).' ],
'77' => [ 'US, BXA (Bureau of Export Administration)',
    'A code representing the United States Bureau of Export Administration (BXA) under the Department of Commerce (DOC) .' ],
'78' => [ 'US, FWS (Fish and Wildlife Service)',
    'A code depicting the United States Fish and Wildlife Service (FWS).' ],
'79' => [ 'US, OFAC (Office of Foreign Assets Control)',
    'A code representing the United States Office of Foreign Assets Controls (OFAC).' ],
'80' => [ 'BRMA/RAA - LIMNET - RINET Joint Venture',
    'Joint venture between BRMA (Brokers & Reinsurance Markets Association) / RAA (Reinsurance Association of America) - LIMNET (London Insurance Market Network) - RINET (Reinsurance and Insurance Network).' ],
'81' => [ 'RU, (SFT) Society for Financial Telecommunications',
    'Russian company representing the users of the Global Financial Telecommunication Network (GFTN).' ],
'82' => [ 'NO, Enhetsregisteret ved Bronnoysundregisterne',
    'The co-ordinating register for companies and business units of companies at the Bronnoysund register centre.' ],
'83' => [ 'US, National Retail Federation',
    'The National Retail Federation is the trade association for the general merchandise retailing industry. In addition to providing support and education services, they also maintain and publish standard colour and size codes for the retail industry.' ],
'84' => [ 'DE, BRD (Gesetzgeber der Bundesrepublik Deutschland)',
    'German legislature.' ],
'85' => [ 'North America, Telecommunications Industry Forum',
    'Trade association representing telecommunications service providers, equipment manufacturers, suppliers to the industry and customers.' ],
'86' => [ 'Assigned by party originating the message',
    'Codes assigned by the party originating the message.' ],
'87' => [ 'Assigned by carrier',
    'Codes assigned by the carrier.' ],
'88' => [ 'Assigned by owner of operation',
    'Assigned by owner of operation (e.g. used in construction).' ],
'89' => [ 'Assigned by distributor',
    'Codes assigned by a distributor.' ],
'90' => [ 'Assigned by manufacturer',
    'Codes assigned by a manufacturer.' ],
'91' => [ "Assigned by seller or seller's agent",
    "Codes assigned by a seller or seller's agent." ],
'92' => [ "Assigned by buyer or buyer's agent",
    "Codes assigned by a buyer or buyer's agent." ],
'93' => [ 'AT, Austrian Customs',
    'Austrian customs organization.' ],
'94' => [ 'AT, Austrian PTT',
    'The Austrian organization responsible for assigning telephone (voice/data) + telex numbers, postcodes, and postal account numbers.' ],
'95' => [ 'AU, Australian Customs Service',
    'Australian Customs Service.' ],
'96' => [ 'CA, Revenue Canada, Customs and Excise',
    'Canada Customs and Revenue Agency.' ],
'97' => [ 'CH, Administration federale des contributions',
    'Indirect taxation (e.g. turn-over/sales taxes).' ],
'98' => [ 'CH, Direction generale des douanes',
    'Customs (incl. ISO alpha 2 country code).' ],
'99' => [ 'CH, Division des importations et exportations, OFAEE',
    'Import and export licences.' ],
'100' => [ 'CH, Entreprise des PTT',
    'Telephone (voice/data) + telex numbers, postcodes, postal account numbers.' ],
'101' => [ 'CH, Carbura',
    "Centrale suisse pour l'importation de carburants et combustibles liquides (Oil products)." ],
'102' => [ "CH, Centrale suisse pour l'importation du charbon",
    'Coal.' ],
'103' => [ 'CH, Office fiduciaire des importateurs de denrees',
    'alimentaires Foodstuff.' ],
'104' => [ 'CH, Association suisse code des articles',
    'Swiss article numbering association.' ],
'105' => [ 'DK, Ministry of taxation, Central Customs and Tax',
    'Administration Danish Customs administration.' ],
'106' => [ 'FR, Direction generale des douanes et droits indirects',
    'French Customs.' ],
'107' => [ 'FR, INSEE',
    'Institut National de la Statistique et des Etudes Economiques.' ],
'108' => [ 'FR, Banque de France',
    'Banque de France.' ],
'109' => [ 'GB, H.M. Customs & Excise',
    'United Kingdom H.M. Customs and Excise.' ],
'110' => [ 'IE, Revenue Commissioners, Customs AEP project',
    'Ireland Revenue Commissioners Customs Automated Entry Processing project.' ],
'111' => [ 'US, U.S. Customs Service',
    'United States Customs Service.' ],
'112' => [ 'US, U.S. Census Bureau',
    'The Bureau of the Census of the U.S. Dept. of Commerce.' ],
'113' => [ 'GS1 US',
    'Organisation responsible for the GS1 System in the USA.' ],
'114' => [ 'US, ABA (American Bankers Association)',
    'United States American Bankers Association.' ],
'116' => [ 'US, ANSI ASC X12',
    'American National Standards Institute ASC X12.' ],
'117' => [ 'AT, Geldausgabeautomaten-Service Gesellschaft m.b.H.',
    'Austrian Geldausgabeautomaten-Service Gesellschaft m.b.H.' ],
'118' => [ 'SE, Svenska Bankfoereningen',
    'Swedish bankers association.' ],
'119' => [ 'IT, Associazione Bancaria Italiana',
    'Italian Associazione Bancaria Italiana.' ],
'120' => [ "IT, Socieata' Interbancaria per l'Automazione",
    "Italian Socieata' Interbancaria per l'Automazione." ],
'121' => [ 'CH, Telekurs AG',
    'Swiss Telekurs AG.' ],
'122' => [ 'CH, Swiss Securities Clearing Corporation',
    'Swiss Securities Clearing Corporation.' ],
'123' => [ 'NO, Norwegian Interbank Research Organization',
    'Norwegian Interbank Research Organization.' ],
'124' => [ "NO, Norwegian Bankers' Association",
    "Norwegian Bankers' Association." ],
'125' => [ "FI, The Finnish Bankers' Association",
    "Finnish Bankers' Association." ],
'126' => [ 'US, NCCMA (Account Analysis Codes)',
    'The United States organization responsible for issuing account analysis codes.' ],
'127' => [ 'DE, ARE (AbRechnungs Einheit)',
    'A German code for subsidiary unit number.' ],
'128' => [ "BE, Belgian Bankers' Association",
    "Belgian Bankers' Association." ],
'129' => [ 'BE, Belgian Ministry of Finance',
    'VAT numbers.' ],
'130' => [ 'DK, Danish Bankers Association',
    'Code identifying the organisation responsible for the issuance of bank related codes in Denmark.' ],
'131' => [ 'DE, German Bankers Association',
    "German Bankers' Association." ],
'132' => [ 'GB, BACS Limited',
    "An organization that operates the United Kingdom's electronic fund transfer service on behalf of the major Banks and Building Societies." ],
'133' => [ 'GB, Association for Payment Clearing Services',
    'British Association for Payment Clearing Services.' ],
'134' => [ 'GB, APACS (Association of payment clearing services)',
    'The association which manages the United Kingdom payment clearing system, and among other thing manages the UK bank sort code numbering system.' ],
'135' => [ 'GB, The Clearing House',
    'British financial transaction clearing house.' ],
'136' => [ 'GS1 UK',
    'Organisation responsible for the GS1 System in the United Kingdom.' ],
'137' => [ 'AT, Verband oesterreichischer Banken und Bankiers',
    'Austrian bankers association.' ],
'138' => [ "FR, CFONB (Comite francais d'organ. et de normalisation",
    'bancaires) National body responsible for the French codification in banking activity.' ],
'139' => [ 'Universal Postal Union (UPU)',
    'The Universal Postal Union (UPU) is an international organization that coordinates postal policies between member nations, and hence the world-wide postal system.' ],
'140' => [ 'CEC (Commission of the European Communities), DG/XXI-01',
    'Responsible for computerization within Customs area.' ],
'141' => [ 'CEC (Commission of the European Communities), DG/XXI-B-1',
    'International Commission of the European Communities.' ],
'142' => [ 'CEC (Commission of the European Communities), DG/XXXIV',
    'Statistical Office of the European Communities: e.g. Geonomenclature.' ],
'143' => [ 'NZ, New Zealand Customs',
    'New Zealand Customs.' ],
'144' => [ 'NL, Netherlands Customs',
    'Netherlands Customs.' ],
'145' => [ 'SE, Swedish Customs',
    'Swedish Customs.' ],
'146' => [ 'DE, German Customs',
    'German Customs.' ],
'147' => [ 'BE, Belgian Customs',
    'Belgian Customs.' ],
'148' => [ 'ES, Spanish Customs',
    'Spanish Customs.' ],
'149' => [ 'IL, Israel Customs',
    'Israeli Customs.' ],
'150' => [ 'HK, Hong Kong Customs',
    'Hong Kong Customs.' ],
'151' => [ 'JP, Japan Customs',
    'Japan Customs.' ],
'152' => [ 'SA, Saudi Arabia Customs',
    'Saudi Arabia Customs.' ],
'153' => [ 'IT, Italian Customs',
    'Italian Customs.' ],
'154' => [ 'GR, Greek Customs',
    'Greek Customs.' ],
'155' => [ 'PT, Portuguese Customs',
    'Portuguese Customs.' ],
'156' => [ 'LU, Luxembourg Customs',
    'Luxembourg Customs.' ],
'157' => [ 'NO, Norwegian Customs',
    'Norwegian Customs.' ],
'158' => [ 'FI, Finnish Customs',
    'Finnish Customs.' ],
'159' => [ 'IS, Iceland Customs',
    'Iceland Customs.' ],
'160' => [ 'LI, Liechtenstein authority',
    'Identification of relevant responsible agency for e.g. banking/financial matters still pending. For e.g. Customs, currency, post/telephone: see relevant CH entry.' ],
'161' => [ 'UNCTAD (United Nations - Conference on Trade And',
    'Development) United Nations - Conference on Trade And Development.' ],
'162' => [ 'CEC (Commission of the European Communities), DG/XIII-D-5',
    'Responsible for TEDIS - incl. CEBIS -, INSIS and CADDIA projects.' ],
'163' => [ 'US, FMC (Federal Maritime Commission)',
    'United States Federal Maritime Commission.' ],
'164' => [ 'US, DEA (Drug Enforcement Agency)',
    'United States Drug Enforcement Agency.' ],
'165' => [ 'US, DCI (Distribution Codes, INC.)',
    'United States Distribution Codes, Inc. organization.' ],
'166' => [ 'US, National Motor Freight Classification Association',
    'The organisation in the USA which is responsible for code maintenance in the trucking industry.' ],
'167' => [ 'US, AIAG (Automotive Industry Action Group)',
    'United States Automotive Industry Action Group.' ],
'168' => [ 'US, FIPS (Federal Information Publishing Standard)',
    'A code issued by the United States National Institute for Science and Technology (NIST) to identify a Federal Information Publishing Standard.' ],
'169' => [ 'CA, SCC (Standards Council of Canada)',
    'Standards Council of Canada.' ],
'170' => [ 'CA, CPA (Canadian Payment Association)',
    'Canadian Payment Association.' ],
'171' => [ 'NL, Interpay Girale Services',
    'Interpay Girale Services.' ],
'172' => [ 'NL, Interpay Debit Card Services',
    'Interpay Debit Card Services.' ],
'173' => [ 'NO, NORPRO',
    'Norwegian electronic data interchange standards organization.' ],
'174' => [ 'DE, DIN (Deutsches Institut fuer Normung)',
    'German standardization institute.' ],
'175' => [ 'FCI (Factors Chain International)',
    'Factors Chain International.' ],
'176' => [ 'BR, Banco Central do Brazil',
    'Brazilian central bank.' ],
'177' => [ 'AU, LIFA (Life Insurance Federation of Australia)',
    'Life Insurance Federation of Australia.' ],
'178' => [ 'AU, SAA (Standards Association of Australia)',
    'Standards Association of Australia.' ],
'179' => [ 'US, Air transport association of America',
    'U.S. -based trade association representing the major North American scheduled airlines.' ],
'180' => [ 'DE, BIA (Berufsgenossenschaftliches Institut fuer',
    "Arbeitssicherheit) German institute of the workmen's compensation board." ],
'181' => [ 'Edibuild',
    'EDI organization for companies in the construction industry.' ],
'182' => [ 'US, Standard Carrier Alpha Code (Motor)',
    'Organisation maintaining the SCAC lists and transportation operating in North America.' ],
'183' => [ 'US, American Petroleum Institute',
    'US-based trade association representing oil and natural gas producers, shippers, refineries, marketers, and major suppliers to the industry.' ],
'184' => [ 'AU, ACOS (Australian Chamber of Shipping)',
    'The national organisation for the maritime industry in Australia.' ],
'185' => [ 'DE, BDI (Bundesverband der Deutschen Industrie e.V.)',
    'German industry association.' ],
'186' => [ 'US, GSA (General Services Administration)',
    'The US General Services Administration.' ],
'187' => [ 'US, DLMSO (Defense Logistics Management Standards Office)',
    'The Defense Logistics Management Standards Office.' ],
'188' => [ 'US, NIST (National Institute of Standards and Technology)',
    'The US National Institute of Standards and Technology.' ],
'189' => [ 'US, DoD (Department of Defense)',
    'The US Department of Defense.' ],
'190' => [ 'US, VA (Department of Veterans Affairs)',
    'The Department of Veterans Affairs.' ],
'191' => [ 'IAPSO (United Nations Inter-Agency Procurement Services',
    'Office) United Nations organization responsible for maintaining the United Nations Common Coding System (UNCCS) which is used extensively by UN agencies in procurement and statistical analysis.' ],
'192' => [ "Shipper's association",
    "Code assigned by a shipper's association." ],
'193' => [ 'EU, European Telecommunications Informatics Services (ETIS)',
    'European Telecommunications Informatics Services is a non-profit cooperative organisation owned by European public network operators, working in the field of information technology.' ],
'194' => [ 'AU, AQIS (Australian Quarantine and Inspection Service)',
    'Australian Quarantine and Inspection Service.' ],
'195' => [ 'CO, DIAN (Direccion de Impuestos y Aduanas Nacionales)',
    'The Colombian customs organization.' ],
'196' => [ 'US, COPAS (Council of Petroleum Accounting Society)',
    'Organization supplying codes of oil field equipment and tubular goods used by joint operators in the petroleum industry.' ],
'197' => [ 'US, DISA (Data Interchange Standards Association)',
    'The organization maintaining code lists under the administration of the data interchange standards association.' ],
'198' => [ 'CO, Superintendencia Bancaria De Colombia',
    'The organization which assigns identification numbers to financial institutions conducting business in Colombia.' ],
'199' => [ 'FR, Direction de la Comptabilite Publique',
    'The French public accounting office.' ],
'200' => [ 'GS1 Netherlands',
    'Organisation responsible for the GS1 System in The Netherlands.' ],
'201' => [ 'US, WSSA(Wine and Spirits Shippers Association)',
    'United States based Wine and Spirits Shippers association.' ],
'202' => [ 'PT, Banco de Portugal',
    'Portuguese Central Bank.' ],
'203' => [ "FR, GALIA (Groupement pour l'Amelioration des Liaisons dans",
    "l'Industrie Automobile) The national organisation representing France in ODETTE (Organisation for Data Exchanges through Tele- Transmission in Europe)." ],
'204' => [ 'DE, VDA (Verband der Automobilindustrie E.V.)',
    'The national organisation representing Germany in ODETTE (Organisation for Data Exchange through Tele- Transmission in Europe).' ],
'205' => [ 'IT, ODETTE Italy',
    'The national organisation representing Italy in ODETTE (Organisation for Data Exchange through Tele- Transmission in Europe).' ],
'206' => [ 'NL, ODETTE Netherlands',
    'The national organisation representing Netherlands in ODETTE (Organisation for Data Exchange through Tele- Transmission in Europe).' ],
'207' => [ 'ES, ODETTE Spain',
    'The national organisation representing Spain in ODETTE (Organisation for Data Exchange through Tele- Transmission in Europe).' ],
'208' => [ 'SE, ODETTE Sweden',
    'The national organisation representing Scandinavian countries in ODETTE (Organisation for Data Exchange through Tele-Transmission in Europe).' ],
'209' => [ 'GB, ODETTE United Kingdom',
    'The national organisation representing UK in ODETTE (Organisation for Data Exchange through Tele- Transmission in Europe).' ],
'210' => [ 'EU, EDI for financial, informational, cost, accounting,',
    'auditing and social areas (EDIFICAS) - Europe European association dealing with accounting and auditing.' ],
'211' => [ 'FR, EDI for financial, informational, cost, accounting,',
    'auditing and social areas (EDIFICAS) - France French association dealing with accounting and auditing.' ],
'212' => [ 'DE, Deutsch Telekom AG',
    'German telecommunication services agency.' ],
'213' => [ 'JP, NACCS Center (Nippon Automated Cargo Clearance System',
    'Operations Organization) NACCS (Nippon Automated Cargo Clearance System Operation Organization) Center is the operations organization of the automated cargo clearance system in Japan.' ],
'214' => [ 'US, AISI (American Iron and Steel Institute)',
    'American iron and steel institute.' ],
'215' => [ 'AU, APCA (Australian Payments Clearing Association)',
    'Australian association responsible for the management of payment clearing.' ],
'216' => [ 'US, Department of Labor',
    'To identify the United States department of labour.' ],
'217' => [ 'US, N.A.I.C. (National Association of Insurance',
    'Commissioners) To identify the United States, National Association of Insurance Commissioners.' ],
'218' => [ 'GB, The Association of British Insurers',
    'An association that administers code lists on behalf of the UK insurance community.' ],
'219' => [ "FR, d'ArvA",
    'Value added network administering insurance code lists on behalf of the French insurance community.' ],
'220' => [ 'FI, Finnish tax board',
    'Finnish tax board.' ],
'221' => [ "FR, CNAMTS (Caisse Nationale de l'Assurance Maladie des",
    'Travailleurs Salaries) The French public institution funding health-care for salaried workers.' ],
'222' => [ 'DK, Danish National Board of Health',
    'The national authority responsible for the supervision of health activities in Denmark.' ],
'223' => [ 'DK, Danish Ministry of Home Affairs',
    'The ministry responsible for all interior affairs concerning the Danish people.' ],
'224' => [ 'US, Aluminum Association',
    'Organization that assigns identification numbers for the aluminum industry.' ],
'225' => [ 'US, CIDX (Chemical Industry Data Exchange)',
    'Organization that assigns identification numbers for the chemical Industry.' ],
'226' => [ 'US, Carbide Manufacturers',
    'Organization that assigns identification numbers for the iron and carbide manufacturing industry.' ],
'227' => [ 'US, NWDA (National Wholesale Druggist Association)',
    'Organization that assigns identification numbers for the wholesale drug industry.' ],
'228' => [ 'US, EIA (Electronic Industry Association)',
    'Organization that assigns identification numbers for the electronic industry.' ],
'229' => [ 'US, American Paper Institute',
    'Organization that assigns identification numbers for the American paper industry.' ],
'230' => [ 'US, VICS (Voluntary Inter-Industry Commerce Standards)',
    'Organization that assigns identification numbers for the retail industry.' ],
'231' => [ 'Copper and Brass Fabricators Council',
    'Organization that assigns identification numbers for the copper and brass fabricators industry.' ],
'232' => [ 'GB, Inland Revenue',
    'Code identifying the government department responsible for assessing and collecting revenue consisting of taxes and inland duties in Great Britain.' ],
'233' => [ 'US, OMB (Office of Management and Budget)',
    'Codes are assigned by the United States Office of Management and Budget.' ],
'234' => [ 'DE, Siemens AG',
    'Siemens AG, Germany.' ],
'235' => [ 'AU, Tradegate (Electronic Commerce Australia)',
    'Australian industry body coordinating codes for use in local and international commerce and trade.' ],
'236' => [ 'US, United States Postal Service (USPS)',
    'Code specifying the official postal service of the United States.' ],
'237' => [ 'US, United States health industry',
    'Code assigned by the United States health industry.' ],
'238' => [ 'US, TDCC (Transportation Data Coordinating Committee)',
    'United States Transportation Data Coordinating Committee.' ],
'239' => [ 'US, HL7 (Health Level 7)',
    'United States, electronic data interchange standards- making organization, Health Level 7.' ],
'240' => [ 'US, CHIPS (Clearing House Interbank Payment Systems)',
    'United States financial clearing house.' ],
'241' => [ 'PT, SIBS (Sociedade Interbancaria de Servicos)',
    'Portuguese automated clearing house.' ],
'244' => [ 'US, Department of Health and Human Services',
    'United States Department of Health and Human Services.' ],
'245' => [ 'GS1 Denmark',
    'Organisation responsible for the GS1 System in Denmark.' ],
'246' => [ 'GS1 Germany',
    'Organisation responsible for the GS1 System in Germany.' ],
'247' => [ 'US, HBICC (Health Industry Business Communication Council)',
    'Code identifying the United States HIBCC (Health Industry Business Communication Council).' ],
'248' => [ 'US, ASTM (American Society of Testing and Materials)',
    'A not-for-profit organization that provides a forum for producers, users, ultimate consumers, and those having a general interest (representatives of government and academia) to meet on common ground and write standards for materials, products, systems, and services.' ],
'249' => [ 'IP (Institute of Petroleum)',
    'An independent European centre for the advancement and dissemination of technical, economic and professional knowledge relating to the international oil and gas industry.' ],
'250' => [ 'US, UOP (Universal Oil Products)',
    'An United States based organization that provides products, services and technology primarily in the areas of petroleum refining, olefins, aromatics, and gas processing.' ],
'251' => [ 'AU, HIC (Health Insurance Commission)',
    'Australian agency responsible for administering the Health Insurance Act.' ],
'252' => [ 'AU, AIHW (Australian Institute of Health and Welfare)',
    'Australian statutory authority responsible for the national collection of health related statistics and health related data definitions.' ],
'253' => [ 'AU, NCCH (National Centre for Classification in Health)',
    'Australian national authority responsible for healthcare classifications.' ],
'254' => [ 'AU, DOH (Australian Department of Health)',
    'Australian government department responsible for administration of health policy.' ],
'255' => [ 'AU, ADA (Australian Dental Association)',
    'Industry association responsible for the classification of dental services in Australia.' ],
'256' => [ 'US, AAR (Association of American Railroads)',
    'The official United States organization of the railroads in North America.' ],
'257' => [ 'ECCMA (Electronic Commerce Code Management Association)',
    'The Electronic Commerce Code Management Association, a not for profit membership organization, which manages codes used in electronic commerce.' ],
'258' => [ 'JP, Japanese Ministry of Transport',
    'Japanese Ministry of Transport.' ],
'259' => [ 'JP, Japanese Maritime Safety Agency',
    'Japanese Maritime Safety Agency.' ],
'261' => [ 'EEG7, European Expert Group 7 (Insurance)',
    'European Expert Group 7 for Insurance.' ],
'262' => [ 'DE, GDV (Gesamtverband der Deutschen',
    'Versicherungswirtschaft e.V.) Gesamtverband der Deutschen Versicherungswirtschaft e.V. (German Insurance Association).' ],
'263' => [ 'CA, CSIO (Centre for Study of Insurance Operations)',
    'The Centre for Study of Insurance Operations (CSIO) in Canada.' ],
'264' => [ 'FR, AGF (Assurances Generales de France)',
    'Code lists are administered by Assurances Generales de France (AGF).' ],
'265' => [ 'SE, Central bank',
    'Swedish central bank.' ],
'266' => [ 'US, DoA (Department of Agriculture)',
    'Department of Agriculture, United States federal agency.' ],
'267' => [ 'RU, Central Bank of Russia',
    'Central bank of Russia.' ],
'268' => [ 'FR, DGI (Direction Generale des Impots)',
    'French taxation authority.' ],
'269' => [ 'GRE (Reference Group of Experts)',
    'An international association that administers code lists on behalf of business credit information users and providers.' ],
'270' => [ 'Concord EDI group',
    'An organisation of international transport equipment leasing companies and transport equipment repair providers responsible for promoting the use of EDI standards and standard business terms.' ],
'271' => [ 'InterContainer InterFrigo',
    'European railway associated organisation involved in the transport of containers by rail.' ],
'272' => [ 'Joint Automotive Industry agency',
    'The Joint Automotive Industry (JAI) agency is in charge of code lists that are common to automotive industry groups.' ],
'273' => [ 'CH, SCC (Swiss Chambers of Commerce)',
    'Swiss Chambers of Commerce.' ],
'274' => [ 'ITIGG (International Transport Implementation Guidelines',
    "Group) ITIGG is the UN/EDIFACT transport message development group's organisation responsible for the issuance of globally harmonised transport-related codes." ],
'275' => [ 'ES, Banco de Espaa',
    'The Spanish central bank.' ],
'276' => [ 'Assigned by Port Community',
    'Codes assigned by the Port Community.' ],
'277' => [ 'BIGNet (Business Information Group Network)',
    'Identifies the Business Information Group Network, an international trade alliance that administers code lists on behalf of business information users and providers.' ],
'278' => [ 'Eurogate',
    'An international trade alliance that administers code lists on behalf of business information users and providers.' ],
'279' => [ 'NL, Graydon',
    'Identifies the Graydon Corporation in the Netherlands.' ],
'280' => [ 'FR, Euler',
    'A company in France responsible for assigning codes in the credit insurance industry.' ],
'281' => [ 'GS1 Belgium and Luxembourg',
    'Organisation responsible for the GS1 System in Belgium and Luxembourg.' ],
'282' => [ 'DE, Creditreform International e.V.',
    'Identifies the Creditreform International e.V. in Germany (e.V.: eingetragener Verein).' ],
'283' => [ 'DE, Hermes Kreditversicherungs AG',
    'Identifies the Hermes Kreditversicherungs AG in Germany (AG: Aktiengesellschaft).' ],
'284' => [ "TW, Taiwanese Bankers' Association",
    'Code identifying the organization responsible for the issuance of bank related codes in Taiwan.' ],
'285' => [ 'ES, Asociacin Espaola de Banca',
    'Code identifying the organization responsible for the issuance of bank related codes in Spain.' ],
'286' => [ 'SE, TCO (Tjnstemnnes Central Organisation)',
    'The Swedish Confederation of Professional Employees.' ],
'287' => [ 'DE, FORTRAS (Forschungs- und Entwicklungsgesellschaft fr',
    'Transportwesen GMBH) German research and development institute for transport matters.' ],
'288' => [ 'OSJD (Organizacija Sotrudnichestva Zeleznih Dorog)',
    'Code identifying OSJD, Organisation for Co-operation of Railways.' ],
'289' => [ 'JP,JIPDEC/ECPC  (Japan Information Processing Development',
    'Center / Electronic Commerce Promotion Center) JIPDEC/ECPC is a nonprofit foundation for promoting electronic commerce, and is the registration agency of the standard company code in Japan.' ],
'290' => [ 'JP, JAMA',
    'Japan Automobile Manufacturers Association, Inc.' ],
'291' => [ 'JP, JAPIA',
    'Japan Auto Parts Industries Association.' ],
'292' => [ 'FI, TIEKE The Information Technology Development Centre of',
    'Finland The national organization representing Finland in electronic data interchange for trade and industry.' ],
'293' => [ 'DE, BDEW (Bundesverband der Energie- und Wasserwirtschaft',
    'e.V.) The Federal Association of Energy and Water (BDEW) is the trade association of the German industries for natural gas, electricity supply, long-distance heating and water supply.' ],
'294' => [ 'GS1 Austria',
    'Organisation responsible for the GS1 System in Austria.' ],
'295' => [ 'AU, Australian Therapeutic Goods Administration',
    'Austrialian administration responsible for the regulation of therapeutic goods in Australia.' ],
'296' => [ 'ITU (International Telecommunication Union)',
    'International Telecommunication Union.' ],
'297' => [ 'IT, Ufficio IVA',
    'Ufficio responsabile gestione partite IVA is the Italian Institute issuing VAT registration numbers.' ],
'298' => [ 'GS1 Spain',
    'Organisation responsible for the GS1 System in Spain.' ],
'299' => [ 'BE, Seagha',
    'Organisation responsible for assigning maritime related identification numbers in Belgian ports.' ],
'300' => [ 'SE, Swedish International Freight Association',
    'Swedish International Freight Association (SIFA).' ],
'301' => [ 'DE, BauDatenbank GmbH',
    'The organisation responsible for issuing and maintaining commodity codes for use in the German construction industry.' ],
'302' => [ 'DE, Bundesverband des Deutschen Textileinzelhandels e.V.',
    'The organisation responsible for issuing and maintaining commodity codes for use in the German textile industry.' ],
'303' => [ 'GB, Trade Service Information Ltd (TSI)',
    'A United Kingdom authority responsible for the allocation of identification codes to products in the building sector.' ],
'304' => [ 'DE, Bundesverband Deutscher Heimwerker-, Bau- und',
    'Gartenfachmaerkte e.V. The organisation responsible for issuing and maintaining commodity codes for use in German stores for do-it- yourself, construction and garden articles.' ],
'305' => [ 'ETSO (European Transmission System Operator)',
    'The European organisation representing the electrical industry transmission system operators.' ],
'306' => [ 'SMDG (Ship-planning Message Design Group)',
    'User Group for Shipping Lines and Container Terminals.' ],
'307' => [ 'JP, Ministry of Justice',
    'Japanese Ministry of Justice.' ],
'309' => [ 'JP, JASTPRO (Japan Association for Simplification of',
    'International Trade Procedures) JASTPRO is a nonprofit organization for simplifying international trade procedures and is the responsible agency for the registration of the "Japan Exporters and Importers Standard Code".' ],
'310' => [ 'DE, SAP AG (Systeme, Anwendungen und Produkte)',
    'Systeme, Anwendungen und Produkte (German software company).' ],
'311' => [ 'JP, TDB (Teikoku Databank, Ltd.)',
    'TDB (Teikoku Databank, Ltd.) conducts corporate credit research and maintains company codes based on research activities for supporting business transactions in Japan.' ],
'312' => [ 'FR, AGRO EDI EUROPE',
    'French association developing EDI in the agricultural and food processing sectors.' ],
'313' => [ 'FR, Groupement National Interprofessionnel des Semences et',
    'Plants French organization of seed and plant professionals responsible for assigning codes in the botanical seed sectors.' ],
'314' => [ 'OAGi (Open Applications Group, Incorporated)',
    'Open Applications Group, Incorporated.' ],
'315' => [ 'US, STAR (Standards for Technology in Automotive Retail)',
    'Standards for Technology in Automotive Retail.' ],
'316' => [ 'GS1 Finland',
    'Organisation responsible for the GS1 system in Finland.' ],
'317' => [ 'GS1 Brazil',
    'Organisation responsible for the GS1 system in Brazil.' ],
'318' => [ 'IETF (Internet Engineering Task Force)',
    'IETF - Internet Engineering Task Force.' ],
'319' => [ 'FR, GTF',
    'Group of Terrestrial Freight Forwarders.' ],
'320' => [ 'DK, Danish National IT and Telcom Agency (ITA)',
    'Code specifying the Danish National IT and Telcom Agency as codelist responsible Agency.' ],
'321' => [ 'EASEE-Gas (European Association for the Streamlining of',
    'Energy Exchange for gas) The European organization whose working group Edig@s is responsible for the management of gas related codes and messages.' ],
'322' => [ 'IS, ICEPRO',
    'Icelandic committee of e-commerce and trade procedures.' ],
'323' => [ 'PROTECT',
    'A group of European ports, national competent authorities and port community systems exchanging information about dangerous goods and vessel movements.' ],
'324' => [ 'GS1 Ireland',
    'Organisation responsible for the GS1 system in Ireland.' ],
'325' => [ 'GS1 Russia',
    'Organisation responsible for the GS1 system in Russia.' ],
'326' => [ 'GS1 Poland',
    'Organisation responsible for the GS1 system in Poland.' ],
'327' => [ 'GS1 Estonia',
    'Organisation responsible for the GS1 system in Estonia.' ],
'328' => [ 'Assigned by ultimate recipient of the message',
    'A code assigned by the party who is the ultimate recipient of the message.' ],
'329' => [ 'Assigned by loading dock operator',
    'The code is assigned by the operator of a loading dock.' ],
'331' => [ 'US, Agricultural Marketing Service (AMS)',
    'A division of the US Department of Agriculture. AMS inspects and grades agricultural products and gathers import and export statistics for farm products.' ],
'332' => [ 'DE, DVGW Service & Consult GmbH',
    'Subsidiary of DVGW German Technical and Scientific Association for Gas and Water. As a technical standardization organization, the DVGW promotes technical standards for the production, transportation, distribution and use of gas and drinking water in the Federal Republic of Germany.' ],
'333' => [ 'US, Animal and Plant Health Inspection Service (APHIS)',
    'A division of the US Department of Agriculture. APHIS regulates the import and export of plants, animals and their products.' ],
'334' => [ 'US, Bureau of Labor Statistics (BLS)',
    'A division of the US Department of Labor. BLS is the principal fact-finding agency for the Federal Government in the broad field of labor economics and statistics.' ],
'335' => [ 'US, Bureau of Transportation Statistics (BTS)',
    'A division of the US Department of Transportation. BTS administers data collection, analysis, and reporting and to ensure the most cost-effective use of transportation- monitoring resources.' ],
'336' => [ 'US, Customs and Border Protection (CBP)',
    'A division of US Department of Homeland Security.' ],
'337' => [ 'US, Center for Disease Control (CDC)',
    'A division of the US Department of Health and Human Services. CDC promotes health and quality of life by preventing and controlling disease, injury, and disability.' ],
'338' => [ 'US, Consumer Product Safety Commission (CPSC)',
    'An independent commission within the US federal government. CPSC works to protect consumers from products that pose a fire, electrical, chemical, or mechanical hazard or can injure children.' ],
'339' => [ 'US, Directorate of Defense Trade Controls (DDTC)',
    'A division of the US Department of State. DDTC is charged with controlling the export and temporary import of defense articles and defense services covered by the United States.' ],
'340' => [ 'US, Environmental Protection Agency (EPA)',
    'An independent agency within the US federal government. EPA registers and controls imports of pesticides, Ozone Depleting Substances, and bulk chemicals; controls conformity of vehicles and engines to the Clean Air Act, and tracks hazardous wastes.' ],
'341' => [ 'US, Federal Aviation Administration (FAA)',
    'A division of the US Department of Transportation. FAA is responsible for the safety of hazardous materials shipments when flown into and from US air space.' ],
'342' => [ 'US, Foreign Agriculture Service (FAS)',
    'A division of the US Department of Agriculture. FAS works to improve foreign market access for US products, build new markets, improve the competitive position of US agriculture in the global marketplace, and provide food aid and technical assistance to foreign countries.' ],
'343' => [ 'US, Federal Motor Carrier Safety Administration (FMCSA)',
    'A division of the US Department of Transportation. FMCSA is focused on reducing crashes, injuries, and fatalities involving large trucks and buses.' ],
'344' => [ 'US, Food Safety Inspection Service (FSIS)',
    "A division of the US Department of Agriculture. FSIS is responsible for ensuring that the nation's commercial supply of meat, poultry, and egg products is safe, wholesome, and correctly labeled and packaged." ],
'345' => [ 'US, Foreign Trade Zones Board (FTZB)',
    'FTZB licenses, regulates, and monitors the activity of foreign-trade zones (FTZ) in the United States.' ],
'346' => [ 'US, The Grain Inspection, Packers and Stockyards',
    'Administration (GIPSA) A division of the US Department of Agriculture. GIPSA facilitates the marketing of livestock, poultry, meat, cereals, oilseeds, and related agricultural products, and promotes fair and competitive trading practices for the overall benefit of consumers and American agriculture.' ],
'347' => [ 'US, Import Administration (IA)',
    'A division of the US Department of Commerce. IA enforces the US unfair trade laws (i.e., the anti-dumping and countervailing duty laws) and develops and implements other policies and programs aimed at countering foreign unfair trade practices.' ],
'348' => [ 'US, Internal Revenue Service (IRS)',
    'A division of the US Department of the Treasury. IRS collects excise taxes on imports and on conveyances involved in international traffic.' ],
'349' => [ 'US, International Trade Commission (ITC)',
    'An independent commission. ITC investigates the effects of dumped and subsidized imports on domestic industries and conducts global safeguard investigations.' ],
'350' => [ 'US, National Highway Traffic Safety Administration (NHTSA)',
    'A division of the US Department of Transportation. NHTSA monitors the importation of motor vehicles and motor vehicle equipment to ensure compliance with applicable Federal motor vehicle safety standards.' ],
'351' => [ 'US, National Marine Fisheries Service (NMFS)',
    'A division of the US Department of Commerce. NMFS issues permits to support their effort to regulate commercial and recreational international transactions involving resources such as such as swordfish, tooth fish, and tuna while overseeing the management, conservation and protection of living marine resources within the areas of ocean surrounding the United States.' ],
'352' => [ 'US, Office of Fossil Energy (OFE)',
    'A division of the US Department of Energy.' ],
'353' => [ 'US, Office of Foreign Missions (OFM)',
    'A division of the US Department of State. OFM provides the legal foundation to facilitate secure and efficient operations of US missions abroad, and of foreign missions and international organizations in the United States.' ],
'354' => [ 'US, Bureau of Oceans and International Environmental and',
    'Scientific Affairs (OES) A division of the US Department of State. OES works with issues surrounding foreign policy formulation and implementation in global environment, science, and technology.' ],
'355' => [ 'US, Office of Naval Intelligence (ONI)',
    'A division of the US Department of Defense (Navy).' ],
'356' => [ 'US, Pipeline and Hazardous Materials Safety Administration',
    "(PHMSA) A division of the US Department of Transportation. PHMSA works to protect the American public and the environment by ensuring the safe and secure movement of hazardous materials to industry and consumers by all transportation modes, including the nation's pipelines." ],
'357' => [ 'US, Alcohol and Tobacco Tax and Trade Bureau (TTB)',
    'A division of the US Department of the Treasury. TTB collects alcohol, tobacco, firearms, and ammunition excise taxes; to ensure that these products are labeled, advertised, and marketed in accordance with the law; and administers the laws and regulations.' ],
'358' => [ 'US, Army Corp of Engineers (USACE)',
    'A division of the US Department of Defense (Army). USACE protects the US aquatic resources, while allowing reasonable development through fair, flexible and balanced permit decisions.' ],
'359' => [ 'US, Agency for International Development (USAID)',
    'USAID is an independent US federal government agency. USAID supports long-term and equitable economic growth and advances US foreign policy objectives.' ],
'360' => [ 'US, Coast Guard (USCG)',
    'A division of US Department of Homeland Security. USCG is a military branch of the United States involved in maritime law, mariner assistance, and search and rescue.' ],
'361' => [ 'US, Office of the United States Trade Representative (USTR)',
    'An office within the US Executive Branch, Office of the President. USTR negotiates directly with foreign governments to create trade agreements; resolves disputes and participates in global trade policy organizations; meets with governments, business groups, legislators and public interest groups to gather input on trade issues; and explains the presidents trade policy positions.' ],
'362' => [ 'International Commission for the Conservation of Atlantic',
    'Tunas (ICCAT) An inter-governmental fishery organization responsible for the conservation of tunas and tuna-like species in the Atlantic Ocean and its adjacent seas.' ],
'363' => [ 'Inter-American Tropical Tuna Commission (IATTC)',
    'An organization responsible for the conservation and management of fisheries for tunas and other species taken by tuna-fishing vessels in the eastern Pacific Ocean.' ],
'364' => [ 'Commission for the Conservation of Southern Bluefin Tuna',
    '(CCSBT) An organization which oversees the management and conservation of southern blue fin tuna.' ],
'365' => [ 'Indian Ocean Tuna Commission (IOTC)',
    'An intergovernmental organization mandated to manage tuna and tuna-like species in the Indian Ocean and adjacent seas.' ],
'366' => [ 'International Botanical Congress',
    'International organization responsible for the international identification of botanical species.' ],
'367' => [ 'International Commission on Zoological Nomenclature',
    'International organization responsible for the International Code of Zoological Nomenclature (ICZN).' ],
'368' => [ 'International Society for Horticulture Science',
    'International organization responsible for the International Code of Nomenclature for Cultivated Plants (ICNCP).' ],
'369' => [ 'Chemical Abstract Service (CAS)',
    'Chemical Abstract Service (CAS) is a division of the American Chemical Society (ACS) responsible for the CAS registry.' ],
'370' => [ 'Social Security Administration (SSA)',
    'The Social Security Administration (SSA) is an independent agency of the US government. SSA issues Social Security Numbers (SSN) used to identify parties/entities in a trade transaction.' ],
'371' => [ 'INMARSAT',
    'Satellite communications organization that provides vessel call sign used by ships as an identifier.' ],
'372' => [ 'Agent of ship at the intended port of arrival',
    'Name and contact details of the agent of the ship at the intended port of arrival.' ],
'373' => [ 'US Air Force',
    'The aerial warfare division of the U.S. Department of Defense.' ],
'374' => [ 'US, Bureau of Explosives',
    'A self-policing agency to promote the safe transportation of explosives and other hazardous materials on roads and railways.' ],
'375' => [ 'Basel Convention Secretariat',
    'Agency which maintains the list and specifications of goods for control of transboundary movements of hazardous wastes and their disposal.' ],
'376' => [ 'PANTONE',
    'Color code controlling organisation.' ],
'377' => [ 'IS, National Registry of Iceland',
    'The national registry of Iceland, responsible for legal registration ID for persons.' ],
'378' => [ 'IS, Internal Revenue Directorate of Iceland',
    'Tax authorities of Iceland, responsible for VAT codes and registration ID for legal entities.' ],
'379' => [ 'IANA (Internet Assigned Numbers Authority)',
    'The Internet Assigned Numbers Authority (IANA) is responsible for the global coordination of the DNS Root, IP addressing, and other Internet protocol resources.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
