package Business::EDI::CodeList::IdentificationCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {return "0007";}
my $usage       = 'B';

# 0007  Identification code qualifier
# Desc: Qualifier referring to the identification code.
# Repr: an..4

my %code_hash = (
'1' => [ 'DUNS (Data Universal Numbering System)',
    'Partner identification code assigned by Dun & Bradstreet.' ],
'4' => [ 'IATA (International Air Transport Association)',
    'Partner identification code assigned by the International Air Transport Association.' ],
'5' => [ 'INSEE (Institut National de la Statistique et des Etudes',
     ],
'Economiques)' => [ '- SIRET',
    'French national statistics institute. SIRET means Systeme Informatique du Repertoire des entreprises et de leurs ETablissements.' ],
'8' => [ 'UCC Communications ID (Uniform Code Council Communications',
     ],
'The' => [ 'Uniform Code Council Communications Identifier is a',
    'ten digit code used to uniquely identify physical and logical locations.' ],
'9' => [ 'DUNS (Data Universal Numbering System) with 4 digit suffix',
    'Partner identification code assigned by Dun & Bradstreet with the 4 digit suffix.' ],
'12' => [ 'Telephone number',
    'Partner identification code corresponds to the partner telephone number.' ],
'14' => [ 'GS1',
    'Partner identification code assigned by GS1, an international organization of GS1 Member Organizations that manages the GS1 System.' ],
'18' => [ 'AIAG (Automotive Industry Action Group)',
    'Partner identification code assigned by the Automotive Industry Action Group.' ],
'22' => [ 'INSEE (Institut National de la Statistique et des Etudes',
     ],
'Economiques)' => [ '- SIREN',
    'French national statistics institute. SIREN means Systeme Informatique du Repertoire des ENtreprises (et de leurs etablissements).' ],
'30' => [ 'ISO 6523: Organization identification',
    'Partner identification code specified in ISO 6523 (Structures for the identification of organizations).' ],
'31' => [ 'DIN (Deutsches Institut fuer Normung)',
    'German standardization institute.' ],
'33' => [ 'BfA (Bundesversicherungsanstalt fuer Angestellte)',
    'German social security association.' ],
'34' => [ 'National Statistical Agency',
    'Partner identification code assigned by a national statistical agency.' ],
'51' => [ 'GEIS (General Electric Information Services)',
    'Partner identification code assigned by General Electric Information Services.' ],
'52' => [ 'INS (IBM Network Services)',
    'Partner identification code assigned by IBM Network Services.' ],
'53' => [ 'Datenzentrale des Einzelhandels',
    'German data centre for retail trade.' ],
'54' => [ 'Bundesverband der Deutschen Baustoffhaendler',
    'German building material trade association.' ],
'55' => [ 'Bank identifier code',
    'Partner identification code corresponds to the partner bank identification code.' ],
'57' => [ 'KTNet (Korea Trade Network Services)',
    'Partner identification code assigned by Korea Trade Network Services.' ],
'58' => [ 'UPU (Universal Postal Union)',
    'Partner identification code assigned by the Universal Postal Union.' ],
'59' => [ 'ODETTE (Organization for Data Exchange through Tele-',
     ],
'Transmission' => [ 'in Europe)',
    'European automotive industry project.' ],
'61' => [ 'SCAC (Standard Carrier Alpha Code)',
    'Directory of standard multimodal carriers and tariff agent codes. The SCAC lists and codes transportation companies.' ],
'63' => [ 'ECA (Electronic Commerce Australia)',
    'Australian association for electronic commerce.' ],
'65' => [ 'TELEBOX 400 (Deutsche Telekom)',
    'German telecommunications service.' ],
'80' => [ 'NHS (National Health Service)',
    'United Kingdom National Health Service.' ],
'82' => [ 'Statens Teleforvaltning',
    'Norwegian telecommunications regulatory authority (NTRA).' ],
'84' => [ 'Athens Chamber of Commerce',
    'Greek Chamber of Commerce.' ],
'85' => [ 'Swiss Chamber of Commerce',
    'Swiss Chamber of Commerce.' ],
'86' => [ 'US Council for International Business',
    'United States Council for International Business.' ],
'87' => [ 'National Federation of Chambers of Commerce and Industry',
    'Belgium National Federation of Chambers of Commerce and Industry.' ],
'89' => [ 'Association of British Chambers of Commerce',
    'Association of British Chambers of Commerce.' ],
'90' => [ 'SITA (Societe Internationale de Telecommunications',
     ],
'SITA' => [ '(Societe Internationale de Telecommunications',
    'Aeronautiques).' ],
'91' => [ "Assigned by seller or seller's agent",
    "Partner identification code assigned by the seller or seller's agent." ],
'92' => [ "Assigned by buyer or buyer's agent",
    "Partner identification code assigned by the buyer or buyer's agent." ],
'103' => [ 'TW, Trade-van',
    'Trade-van is an EDI VAN service center for customs, transport, and insurance in national and international trade.' ],
'128' => [ 'CH, BCNR (Swiss Clearing Bank Number)',
    'Code for the identification of a Swiss clearing bank as a sender and/or receiver of an electronic message.' ],
'129' => [ 'CH, BPI (Swiss Business Partner Identification)',
    'Code for the identification of a corporate or a Swiss non-clearing bank as a sender and/or receiver of an electronic message.' ],
'144' => [ 'US, DoDAAC (Department of Defense Activity Address Code)',
    'Code assigned to uniquely identify all military units in the United States Department of Defense.' ],
'145' => [ 'FR, DGCP (Direction Generale de la Comptabilite Publique)',
    'Code assigned by the French public accounting office.' ],
'146' => [ 'FR, DGI (Direction Generale des Impots)',
    'Code assigned by the French taxation authority.' ],
'147' => [ 'JP, JIPDEC/ECPC (Japan Information Processing Development',
     ],
'Corporation' => [ '/ Electronic Commerce Promotion Center)',
    'Partner identification code which is registered with JIPDEC/ECPC.' ],
'148' => [ 'ITU (International Telecommunications Union) Data Network',
     ],
'Identification' => [ 'Code (DNIC)',
    'Data network identification code assigned by the ITU.' ],
'500' => [ 'DE, BDEW (Bundesverband der Energie- und Wasserwirtschaft',
     ],
'The' => [ 'Federal Association of Energy and Water (BDEW) is the',
    'trade association of the German industries for natural gas, electricity supply, long-distance heating and water supply.' ],
'501' => [ 'EASEE-gas (European Association for the Streamlining of',
     ],
'Energy' => [ 'Exchange)',
    'Partner identification code which is registered with EASEE-gas.' ],
'502' => [ 'DE, DVGW (Deutsche Vereinigung des Gas- und Wasserfaches',
     ],
'The' => [ 'DVGW is the German Technical and Scientific',
    'Association for Gas and Water.' ],
'Z01' => [ 'Vehicle registration number',
    'Registration number of a vehicle assigned by a recognised authority.' ],
'ZZZ' => [ 'Mutually defined',
    'Mutually defined between trading partners.' ],
);
sub get_codes { return \%code_hash; }

1;
