use v6;

use Test;

use Util::Uuencode;

my $text = q:to/EOGAUNT/;
Methinks I am a prophet new inspired
And thus expiring do foretell of him:
His rash fierce blaze of riot cannot last,
For violent fires soon burn out themselves;
Small showers last long, but sudden storms are short;
He tires betimes that spurs too fast betimes;
With eager feeding food doth choke the feeder:
Light vanity, insatiate cormorant,
Consuming means, soon preys upon itself.
This royal throne of kings, this scepter'd isle,
This earth of majesty, this seat of Mars,
This other Eden, demi-paradise,
This fortress built by Nature for herself
Against infection and the hand of war,
This happy breed of men, this little world,
This precious stone set in the silver sea,
Which serves it in the office of a wall,
Or as a moat defensive to a house,
Against the envy of less happier lands,
This blessed plot, this earth, this realm, this England,
This nurse, this teeming womb of royal kings,
Fear'd by their breed and famous by their birth,
Renowned for their deeds as far from home,
For Christian service and true chivalry,
As is the sepulchre in stubborn Jewry,
Of the world's ransom, blessed Mary's Son,
This land of such dear souls, this dear dear land,
Dear for her reputation through the world,
Is now leased out, I die pronouncing it,
Like to a tenement or pelting farm:
England, bound in with the triumphant sea
Whose rocky shore beats back the envious siege
Of watery Neptune, is now bound in with shame,
With inky blots and rotten parchment bonds:
That England, that was wont to conquer others,
Hath made a shameful conquest of itself.
Ah, would the scandal vanish with my life,
How happy then were my ensuing death!
EOGAUNT


my $encoded;

lives-ok {
    $encoded = uuencode($text) ;
}, "uuencode (plain text)";

my $decoded;

lives-ok {
    $decoded = uudecode($encoded);
}, "uudecode";

is $decoded.decode, $text, "and it was round-tripped successfully";

my $image = $*PROGRAM.parent.add('data/test_image.jpg').slurp(:bin);

lives-ok {
    $encoded = uuencode($image) ;
}, "uuencode (binary file)";

lives-ok {
    $decoded = uudecode($encoded);
}, "uudecode";

is-deeply $decoded, $image, "and it was round-tripped successfully";

# Test that we can decode one made by the real uuencode
$encoded = $*PROGRAM.parent.add('data/test_image.jpg.uu').slurp;

lives-ok {
    $decoded = uudecode($encoded);
}, "uudecode the image encoded by the real uuencode";

is-deeply $decoded, $image, "and it was round-tripped successfully";

done-testing();

# vim: ft=raku
