package Sah::SchemaR::cpan::modname;

our $DATE = '2021-07-19'; # DATE
our $VERSION = '0.013'; # VERSION

our $rschema = ["str",[{description=>"\nThis is a schema you can use when you want to accept a Perl module name. It\noffers basic checking of syntax as well as a couple of conveniences. First, it\noffers completion from list of locally installed Perl modules. Second, it\ncontains coercion rule so you can also input `Foo-Bar`, `Foo/Bar`, `Foo/Bar.pm`\nor even 'Foo.Bar' and it will be normalized into `Foo::Bar`.\n\nNote that this schema does not check that the Perl module exists or is installed\nlocally. To check that, use the `perl::modname::installed` schema. And there's\nalso a `perl::modname::not_installed` schema.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"Foo::Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo-Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar.pm"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo.Bar"},{valid=>0,value=>"Foo|Bar"}],match=>"\\A(?:[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*)\\z",prefilters=>["Perl::normalize_perl_modname"],summary=>"Perl module name, e.g. Foo::Bar","x.completion"=>"perl_modname"},{description=>"\nLike perl::modname, but with completion from module names on CPAN (using lcpan).\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo::Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo-Bar"}],"x.completion"=>["lcpan_modname"]}],["perl::modname","str"]];

1;
# ABSTRACT: 

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::cpan::modname -  

=head1 VERSION

This document describes version 0.013 of Sah::SchemaR::cpan::modname (from Perl distribution Sah-Schemas-CPAN), released on 2021-07-19.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-CPAN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-CPAN>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-CPAN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2019, 2018, 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
