#!/usr/bin/perl -w
#
#    bidi.pl
#
#    $Id: bidi.pl,v 1.1 2001/02/12 03:56:54 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use utf8;

use ExtUtils::testlib;
use ICU qw(U_ZERO_ERROR); 
use ICU::BiDi;

print "<pre>\n";

my $bd = ICU::BiDi->new();
print "bd = $bd\n";

my $status = U_ZERO_ERROR;
$bd = ICU::BiDi->new(\$status);
print "bd = $bd\n";
print "isInverse = ".$bd->isInverse()."\n";
$bd->setInverse(1);
print "isInverse = ".$bd->isInverse()."\n";
$bd->setInverse(0);
print "isInverse = ".$bd->isInverse()."\n";

=head
my $text = "hello, world\nIt is me. I'm back.";
dispTextMetric($text);
charIter($text);
wordIter($text);
lineIter($text);
sentenceIter($text);
my $loc = new ICU::Locale('en_US');
my $bi = ICU::BreakIterator->createWordInstance($loc, \$status);
print "getDisplayName = ".$bi->getDisplayName($loc)."\n";
my $jaloc = new ICU::Locale('fr_FR');
print "getDisplayName in \'fr_FR\' = ".$bi->getDisplayName($loc, $jaloc)."\n";

#print "status = $status\n";
#print "\$bi->setText(\"$text\");\n";
#$bi->setText($text);
#my $current = $bi->current();
#print "current = $current\n";
#my $first = $bi->first();
#print "first = $first\n";
#my $current = $bi->current();
#print "current = $current\n";
#my $next = $bi->next();
#print "next = $next\n";
#my $last = $bi->last();
#my $current = $bi->current();
#print "current = $current\n";
#print "last = $last\n";
=cut
print "</pre>\n";
exit(0);

=head
sub charIter {
  my ($text) = @_;
  #print "text = $text\n";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createCharacterInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create char interator\n";
    return;
  }
  $bi->setText($text);
  print "char breaks at: ";
  $bi->first();
  my $next = $bi->next();
  while ($next != DONE) {
    print "$next, ";
    $next = $bi->next();
  }
  print "\n";
}

sub lineIter {
  my ($text) = @_;
  #print "text = $text\n";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createLineInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create line interator\n";
    return;
  }
  $bi->setText($text);
  print "line breaks at: ";
  $bi->first();
  my $next = $bi->next();
  while ($next != DONE) {
    print "$next, ";
    $next = $bi->next();
  }
  print "\n";
}

sub wordIter {
  my ($text) = @_;
  #print "text = $text\n";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createWordInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create word interator\n";
    return;
  }
  $bi->setText($text);
  print "word: ";
  print "isBoundary(9)=".$bi->isBoundary(9).", ";
  print "isBoundary(13)=".$bi->isBoundary(13).", ";
  print "preceding(18)=".$bi->preceding(18).", ";
  print "next(3)=".$bi->next(3).", ";
  print "last=".$bi->last()."\n";
  $bi->first();
  my $next = $bi->next();
  print "word breaks at: ";
  while ($next != DONE) {
    print "$next, ";
    $next = $bi->next();
  }
  print "\n";
  print "previous = ".$bi->previous()."\n";
}

sub sentenceIter {
  my ($text) = @_;
  #print "text = $text\n";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createSentenceInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create sentence interator\n";
    return;
  }
  $bi->setText($text);
  print "sentence breaks at: ";
  $bi->first();
  my $next = $bi->next();
  while ($next != DONE) {
    print "$next, ";
    $next = $bi->next();
  }
  print "\n";
}

sub dispTextMetric {
  my ($text) = @_;
  $text =~ s/\n/|/mg;
  print "$text\n";
  print "0123456789012345678901234567890123456789012345678901234567890123456789\n";
  print "          1         2         3         4         5         6  \n";
}
=cut
